/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.acl.GuardedResource;
import com.sun.enterprise.security.acl.Resource;
import com.sun.enterprise.security.acl.ResourceAccessManager;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.enterprise.security.acl.WebResource;
import com.sun.web.security.AccessControlInfo;
import com.sun.web.security.BasicAuthentication;
import com.sun.web.security.FormAuthentication;
import com.sun.web.security.HttpAuthenticator;
import com.sun.web.security.MutualAuthentication;
import com.sun.web.security.ProtectionDomain;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.HttpServletRequestFacade;

abstract class SecurityHandler {
    private static final boolean debug = false;
    private ResourceAccessManager accessManager;
    private RoleMapper roleMapper;
    private AccessControlInfo acInfo;
    private Context context;

    protected SecurityHandler(Context context) {
        this.context = context;
        this.acInfo = AccessControlInfo.getInstance(context);
        this.accessManager = this.acInfo.getAccessManager();
        this.roleMapper = RoleMapper.getRoleMapper(this.acInfo.getApplicationName());
    }

    public boolean authenticateRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return true;
    }

    public boolean authorizeRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpServletRequestFacade fac = (HttpServletRequestFacade)request;
        String path = fac.getRealRequest().getLookupPath().toLowerCase();
        if (path.startsWith("/web-inf")) {
            response.sendError(403);
            return false;
        }
        return true;
    }

    protected HttpAuthenticator getAuthenticator(HttpServletRequest req, HttpServletResponse res) {
        GuardedResource g2 = this.getGuard(req);
        if (this.initSecurityContext(req, res)) {
            return null;
        }
        if (g2 == null) {
            HttpSession session = req.getSession(false);
            if (session == null) {
                return null;
            }
            FormAuthentication auth = (FormAuthentication)session.getAttribute("AuthenticationRealm");
            if (auth != null) {
                FormAuthentication fauth = new FormAuthentication(req, res);
                fauth.setRealm(auth.getRealm());
                fauth.setErrorPage(auth.getErrorPage());
                fauth.setLoginPage(auth.getLoginPage());
                auth = fauth;
                session.setAttribute("AuthenticationRealm", auth);
                if (auth.shouldAuthenticate()) {
                    return auth;
                }
            }
            return null;
        }
        ProtectionDomain pd = this.acInfo.getProtectionDomain(this.context);
        if (pd.getAuthMethod().equals("BASIC")) {
            BasicAuthentication bauth = new BasicAuthentication(req, res);
            bauth.setRealm(pd.getRealmName());
            return bauth;
        }
        if (pd.getAuthMethod().equals("FORM")) {
            FormAuthentication fauth = new FormAuthentication(req, res);
            fauth.setRealm(pd.getRealmName());
            fauth.setErrorPage(pd.getLoginErrorPage());
            fauth.setLoginPage(pd.getLoginPage());
            return fauth;
        }
        if (pd.getAuthMethod().equals("CLIENT-CERT")) {
            return new MutualAuthentication(req, res);
        }
        return null;
    }

    protected GuardedResource getGuard(HttpServletRequest req) {
        Resource r2 = this.getResource(req);
        GuardedResource gres = this.accessManager.getGuardedResource(r2);
        if (gres == null) {
            String resName = req.getRequestURI();
            String method = req.getMethod();
            WebResource res = new WebResource(this.acInfo.getApplicationName(), resName, method);
            gres = this.accessManager.getGuardedResource(res);
        }
        return gres;
    }

    private Resource getResource(HttpServletRequest req) {
        String resName = req.getRequestURI();
        String method = req.getMethod();
        WebResource r2 = new WebResource(this.acInfo.getApplicationName(), resName, method);
        return r2;
    }

    protected ResourceAccessManager getResourceAccessManager() {
        return this.accessManager;
    }

    protected RoleMapper getRoleMapper() {
        return this.roleMapper;
    }

    protected boolean initSecurityContext(HttpServletRequest req, HttpServletResponse res) {
        SecurityContext sc = null;
        HttpSession session = req.getSession(false);
        if (session != null && (sc = (SecurityContext)session.getAttribute("SecurityContext")) != null) {
            SecurityContext.setCurrent(sc);
        }
        sc = SecurityContext.getCurrent();
        return req.getUserPrincipal() != null;
    }
}

