/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.acl.Resource;
import com.sun.enterprise.security.acl.WebResource;
import com.sun.web.security.AccessControlInfo;
import com.sun.web.security.DataConstraint;
import com.sun.web.security.HttpSecurityHandler;
import com.sun.web.security.LogHandler;
import com.sun.web.security.RequestSecurityProviderImpl;
import com.sun.web.security.SecurityHandler;
import com.sun.web.server.WebServer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.HttpServletRequestFacade;
import org.apache.tomcat.core.InterceptorException;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.ServiceInterceptor;

public class SecurityInterceptor
implements ServiceInterceptor {
    public static final boolean debug = false;
    private LogHandler logHandler = new LogHandler();
    private static SecurityInterceptor defaultInterceptor = null;
    static /* synthetic */ Class class$com$sun$web$security$SecurityInterceptor;

    private SecurityInterceptor() {
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static SecurityInterceptor getInstance() {
        if (defaultInterceptor == null) {
            Class clazz = class$com$sun$web$security$SecurityInterceptor != null ? class$com$sun$web$security$SecurityInterceptor : (class$com$sun$web$security$SecurityInterceptor = SecurityInterceptor.class$("com.sun.web.security.SecurityInterceptor"));
            synchronized (clazz) {
                defaultInterceptor = new SecurityInterceptor();
            }
        }
        return defaultInterceptor;
    }

    private Resource getResource(Context context, HttpServletRequest req) {
        String resName = req.getRequestURI();
        String method = req.getMethod();
        WebResource r2 = new WebResource(AccessControlInfo.getInstance(context).getApplicationName(), resName, method);
        return r2;
    }

    public void postInvoke(Context context, Servlet servlet, HttpServletRequest req, HttpServletResponse res) throws InterceptorException {
        this.logHandler.logRequest(context, req, res);
    }

    public void preInvoke(final Context context, Servlet servlet, HttpServletRequest req, HttpServletResponse res) throws InterceptorException {
        SecurityContext.setCurrent(null);
        Resource r2 = this.getResource(context, req);
        String cons = (String)DataConstraint.getInstance().getConstraint(r2);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(context.getClassLoader());
                return null;
            }
        });
        if (cons == null) {
            cons = "UNKNOWN";
        }
        SecurityInterceptor.setSSLAttributes(req);
        try {
            SecurityHandler sh;
            if (!req.isSecure()) {
                if ("INTEGRAL".equalsIgnoreCase(cons) || "CONFIDENTIAL".equalsIgnoreCase(cons)) {
                    String port = "";
                    if (WebServer.getSecurePort() != 443) {
                        port = String.valueOf(port) + ":" + WebServer.getSecurePort();
                    }
                    String url = "https://" + req.getServerName() + port + r2.getName();
                    String qstring = req.getQueryString();
                    qstring = qstring == null ? "" : "?" + qstring;
                    res.sendRedirect(res.encodeURL(String.valueOf(url) + qstring));
                    return;
                }
            } else if ("NONE".equalsIgnoreCase(cons) && !HttpUtils.getRequestURL(req).toString().endsWith("/j_security_check")) {
                String port = "";
                if (WebServer.getWebPort() != 80) {
                    port = String.valueOf(port) + ":" + WebServer.getWebPort();
                }
                String url = "http://" + req.getServerName() + port + r2.getName();
                String qstring = req.getQueryString();
                qstring = qstring == null ? "" : "?" + qstring;
                res.sendRedirect(res.encodeURL(String.valueOf(url) + qstring));
                return;
            }
            if (!(sh = HttpSecurityHandler.getInstance(context)).authenticateRequest(req, res)) {
                this.logHandler.logError(context, req, res);
                throw new SecurityException("Client could not be authenticated.");
            }
            if (!sh.authorizeRequest(req, res)) {
                this.logHandler.logError(context, req, res);
                throw new SecurityException("Client could not be authorized.");
            }
        }
        catch (Exception e10) {
            throw new InterceptorException(e10);
        }
    }

    public static void setSSLAttributes(HttpServletRequest req) {
        if (req.isSecure()) {
            Request request = ((HttpServletRequestFacade)req).getRealRequest();
            request.setScheme("https");
            request.setAttribute("javax.servlet.request.X509Certificate", RequestSecurityProviderImpl.getCertChain(req));
        }
    }
}

