/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.server;

import com.sun.enterprise.J2EESecurityManager;
import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.Switch;
import com.sun.enterprise.distributedtx.J2EETransactionManagerImpl;
import com.sun.enterprise.log.LogUtil;
import com.sun.enterprise.naming.NamingManagerImpl;
import com.sun.enterprise.resource.PoolManager;
import com.sun.enterprise.security.KeyTool;
import com.sun.enterprise.server.EJBServer;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.InvocationManagerImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.Utility;
import com.sun.web.security.SSLSocketFactory;
import com.sun.web.server.ServletDeployer;
import com.sun.web.server.ServletDeployerImpl;
import com.sun.web.server.WebService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.security.SecureRandom;
import java.util.Properties;

public final class WebServer {
    private static final String HTTP_PORT = "web.http.port";
    private static final String WEB_DOCUMENT_ROOT = "web.documentroot";
    private static final String HTTPS_PORT = "web.https.port";
    private static final String ENABLE_INVOKER = "web.enable.invoker";
    private static ServerConfiguration config = ServerConfiguration.getConfiguration();
    private static WebServer server = null;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$web$server$WebServer != null ? class$com$sun$web$server$WebServer : (class$com$sun$web$server$WebServer = WebServer.class$("com.sun.web.server.WebServer")));
    private WebService webService;
    private ServletDeployer servletDeployer;
    static /* synthetic */ Class class$com$sun$web$server$WebServer;

    private WebServer() throws Exception {
        KeyTool.initProvider();
        this.webService = new WebService(WebServer.getWebPort(), null, Utility.getLocalHost(), new File(FileUtil.getAbsolutePath(WebServer.getDocumentRoot())).toURL());
        this.webService.addEndPoint(WebServer.getSecurePort(), null, new SSLSocketFactory());
        new Thread(new Runnable(){

            public void run() {
                new SecureRandom().nextBytes(new byte[1]);
            }
        }).start();
        this.initDeployer();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public ServletDeployer getDeployer() {
        return this.servletDeployer;
    }

    public static String getDocumentRoot() {
        if (System.getProperty(WEB_DOCUMENT_ROOT) == null) {
            return config.getProperty(WEB_DOCUMENT_ROOT);
        }
        return System.getProperty(WEB_DOCUMENT_ROOT);
    }

    public static WebServer getInstance() {
        if (server == null) {
            Class clazz = class$com$sun$web$server$WebServer != null ? class$com$sun$web$server$WebServer : (class$com$sun$web$server$WebServer = WebServer.class$("com.sun.web.server.WebServer"));
            synchronized (clazz) {
                try {
                    server = new WebServer();
                }
                catch (Exception e10) {
                    e10.printStackTrace();
                }
            }
        }
        return server;
    }

    public static int getSecurePort() {
        return Integer.parseInt(config.getProperty(HTTPS_PORT));
    }

    public static int getWebPort() {
        return Integer.parseInt(config.getProperty(HTTP_PORT));
    }

    public WebService getWebService() {
        return this.webService;
    }

    private void initDeployer() {
        try {
            this.servletDeployer = new ServletDeployerImpl(this);
        }
        catch (RemoteException re) {
            re.printStackTrace();
            throw new RuntimeException("Cannot start web server.");
        }
    }

    private static void initializeLogs() throws IOException {
        File dir = LogUtil.getLogDirectory("httpd", "web");
        LogUtil.initDefaultLogFiles(dir);
    }

    public static boolean isInvokerEnabled() {
        return Boolean.valueOf(config.getProperty(ENABLE_INVOKER, "false"));
    }

    public static void main(String[] args) {
        Utility.checkJVMVersion();
        System.out.println(localStrings.getLocalString("web.server.started", "Starting the Web Server ..."));
        System.setSecurityManager(new J2EESecurityManager());
        try {
            Properties defaultProperties = new Properties();
            String propsFile = FileUtil.getAbsolutePath("config" + File.separator + "default.properties");
            FileInputStream fis = new FileInputStream(propsFile);
            defaultProperties.load(fis);
            fis.close();
            Properties props = new Properties();
            String recoverableStr = defaultProperties.getProperty("distributed.transaction.recovery");
            boolean recoverable = "true".equals(recoverableStr);
            EJBServer.initJTSProperties(recoverable, false, props);
            ORBManager.init(null, props);
            WebServer.initializeLogs();
            Switch sw = Switch.getSwitch();
            InvocationManagerImpl im = new InvocationManagerImpl();
            sw.setInvocationManager(im);
            J2EETransactionManagerImpl tm = new J2EETransactionManagerImpl();
            sw.setTransactionManager(tm);
            if (recoverable) {
                System.err.println(localStrings.getLocalString("web.server.recovery", "Perform recovery of XAResources..."));
                PoolManager poolMgr = tm.getPoolManager();
                poolMgr.recoverJdbcXAResources();
            }
            NamingManagerImpl nm = new NamingManagerImpl();
            sw.setNamingManager(nm);
            WebServer server = WebServer.getInstance();
            server.start();
        }
        catch (Exception e10) {
            e10.printStackTrace(System.err);
        }
    }

    public void start() throws Exception {
        this.webService.start();
        ((ServletDeployerImpl)this.servletDeployer).doActivate();
    }
}

