/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.server;

import com.sun.enterprise.Switch;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.InvocationManagerImpl;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.web.security.HttpSecurityHandler;
import com.sun.web.security.RequestSecurityProviderImpl;
import com.sun.web.security.SecurityInterceptor;
import com.sun.web.server.WebServer;
import java.io.File;
import java.net.InetAddress;
import java.net.URL;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.LifecycleInterceptor;
import org.apache.tomcat.core.ServiceInterceptor;
import org.apache.tomcat.net.ServerSocketFactory;
import org.apache.tomcat.server.EndpointManager;
import org.apache.tomcat.server.HttpServer;

public class WebService {
    private HttpServer server;
    private URL docRoot;
    private ServiceInterceptor serviceInt;
    private LifecycleInterceptor initInt;
    private LifecycleInterceptor destroyInt;
    private File wDir;

    public WebService(int port, InetAddress addr, String hostname, URL docRoot) {
        this.server = new HttpServer(port, addr, hostname);
        this.docRoot = docRoot;
        this.server.getDefaultContext().setDocumentBase(docRoot);
        this.wDir = new File(FileUtil.getAbsolutePath("repository/" + hostname + "/web"));
        this.wDir.mkdirs();
        InvocationManagerImpl invmgr = (InvocationManagerImpl)Switch.getSwitch().getInvocationManager();
        if (invmgr != null) {
            this.serviceInt = invmgr.getServiceInterceptor();
            this.initInt = invmgr.getInitInterceptor();
            this.destroyInt = invmgr.getDestroyInterceptor();
        }
        this.initContext(this.server.getDefaultContext());
    }

    public Context addContext(String contextName, URL docBase) {
        Context ctx = this.server.addContext(contextName, docBase);
        this.initContext(ctx);
        return ctx;
    }

    public void addEndPoint(int port, InetAddress addr, ServerSocketFactory factory) throws Exception {
        EndpointManager manager = EndpointManager.getManager();
        manager.addEndpoint(this.server, port, addr, factory);
    }

    public URL getDocumentRoot() {
        return this.docRoot;
    }

    public HttpServer getServer() {
        return this.server;
    }

    public void initContext(Context ctx) {
        ctx.setClassLoader(new JarClassLoader());
        ctx.setInvokerEnabled(WebServer.isInvokerEnabled());
        File workingDir = new File(this.wDir, ctx.getPath());
        workingDir.mkdirs();
        ctx.setWorkDir(workingDir, true);
        ctx.setRequestSecurityProvider(RequestSecurityProviderImpl.getInstance());
        if (SecurityInterceptor.getInstance() != null) {
            ctx.addServiceInterceptor(SecurityInterceptor.getInstance());
        }
        if (this.serviceInt != null) {
            ctx.addServiceInterceptor(this.serviceInt);
        }
        if (this.initInt != null) {
            ctx.addInitInterceptor(this.initInt);
        }
        if (this.destroyInt != null) {
            ctx.addDestroyInterceptor(this.destroyInt);
        }
    }

    public static void main(String[] args) {
        try {
            WebService ws = new WebService(8000, null, "localhost", new URL("file:///home/harishp/cvsroot/j2ee/build/unix/public_html"));
            ws.start();
        }
        catch (Exception e10) {
            e10.printStackTrace();
        }
    }

    public void removeContext(String contextName) {
        Context ctx = this.getServer().getContext(contextName);
        this.getServer().removeContext(contextName);
        HttpSecurityHandler.removeInstance(ctx);
    }

    public void start() throws Exception {
        this.server.start();
    }
}

