/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.parser;

import com.sun.xml.parser.AttributeDecl;
import com.sun.xml.parser.ContentModel;
import com.sun.xml.parser.ContentModelState;
import com.sun.xml.parser.ElementDecl;
import com.sun.xml.parser.ElementValidator;
import com.sun.xml.parser.EndOfInputException;
import com.sun.xml.parser.ExternalEntity;
import com.sun.xml.parser.Parser;
import com.sun.xml.parser.SimpleHashtable;
import com.sun.xml.util.XmlNames;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidatingParser
extends Parser {
    private SimpleHashtable ids = new SimpleHashtable();
    private final EmptyValidator EMPTY = new EmptyValidator();

    public ValidatingParser() {
        this.setIsValidating(true);
    }

    public ValidatingParser(boolean bl2) {
        this();
        if (bl2) {
            this.setErrorHandler(new HandlerBase(){

                public void error(SAXParseException sAXParseException) throws SAXException {
                    throw sAXParseException;
                }
            });
        }
    }

    void afterDocument() {
        this.ids.clear();
    }

    void afterRoot() throws SAXException {
        Enumeration enumeration = this.ids.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Boolean bl2 = (Boolean)this.ids.get(string);
            if (Boolean.FALSE != bl2) continue;
            this.error("V-024", new Object[]{string});
        }
    }

    private boolean isUnparsedEntity(String string) {
        Object object = this.entities.getNonInterned(string);
        if (object == null || !(object instanceof ExternalEntity)) {
            return false;
        }
        return ((ExternalEntity)object).notation != null;
    }

    ContentModel newContentModel(char c10, ContentModel contentModel) {
        return new ContentModel(c10, contentModel);
    }

    ContentModel newContentModel(String string) {
        return new ContentModel(string);
    }

    ElementValidator newValidator(ElementDecl elementDecl) {
        if (elementDecl.validator != null) {
            return elementDecl.validator;
        }
        if (elementDecl.model != null) {
            return new ChildrenValidator(elementDecl);
        }
        elementDecl.validator = elementDecl.contentType == null || elementDecl.contentType == "ANY" ? ElementValidator.ANY : (elementDecl.contentType == "EMPTY" ? this.EMPTY : new MixedValidator(elementDecl));
        return elementDecl.validator;
    }

    void validateAttributeSyntax(AttributeDecl attributeDecl, String string) throws SAXException {
        if (attributeDecl.type == "ID") {
            Boolean bl2;
            if (!XmlNames.isName(string)) {
                this.error("V-025", new Object[]{string});
            }
            if ((bl2 = (Boolean)this.ids.getNonInterned(string)) == null || bl2.equals(Boolean.FALSE)) {
                this.ids.put(string.intern(), Boolean.TRUE);
            } else {
                this.error("V-026", new Object[]{string});
            }
        } else if (attributeDecl.type == "IDREF") {
            Boolean bl3;
            if (!XmlNames.isName(string)) {
                this.error("V-027", new Object[]{string});
            }
            if ((bl3 = (Boolean)this.ids.getNonInterned(string)) == null) {
                this.ids.put(string.intern(), Boolean.FALSE);
            }
        } else if (attributeDecl.type == "IDREFS") {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            boolean bl4 = false;
            while (stringTokenizer.hasMoreTokens()) {
                Boolean bl5;
                string = stringTokenizer.nextToken();
                if (!XmlNames.isName(string)) {
                    this.error("V-027", new Object[]{string});
                }
                if ((bl5 = (Boolean)this.ids.getNonInterned(string)) == null) {
                    this.ids.put(string.intern(), Boolean.FALSE);
                }
                bl4 = true;
            }
            if (!bl4) {
                this.error("V-039", null);
            }
        } else if (attributeDecl.type == "NMTOKEN") {
            if (!XmlNames.isNmtoken(string)) {
                this.error("V-028", new Object[]{string});
            }
        } else if (attributeDecl.type == "NMTOKENS") {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            boolean bl6 = false;
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                if (!XmlNames.isNmtoken(string)) {
                    this.error("V-028", new Object[]{string});
                }
                bl6 = true;
            }
            if (!bl6) {
                this.error("V-032", null);
            }
        } else if (attributeDecl.type == "ENUMERATION") {
            int n2 = 0;
            while (n2 < attributeDecl.values.length) {
                if (string.equals(attributeDecl.values[n2])) {
                    return;
                }
                ++n2;
            }
            this.error("V-029", new Object[]{string});
        } else if (attributeDecl.type == "NOTATION") {
            int n3 = 0;
            while (n3 < attributeDecl.values.length) {
                if (string.equals(attributeDecl.values[n3])) {
                    return;
                }
                ++n3;
            }
            this.error("V-030", new Object[]{string});
        } else if (attributeDecl.type == "ENTITY") {
            if (!this.isUnparsedEntity(string)) {
                this.error("V-031", new Object[]{string});
            }
        } else if (attributeDecl.type == "ENTITIES") {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            boolean bl7 = false;
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                if (!this.isUnparsedEntity(string)) {
                    this.error("V-031", new Object[]{string});
                }
                bl7 = true;
            }
            if (!bl7) {
                this.error("V-040", null);
            }
        } else if (attributeDecl.type != "CDATA") {
            throw new InternalError(attributeDecl.type);
        }
    }

    class EmptyValidator
    extends ElementValidator {
        EmptyValidator() {
        }

        public void consume(String string) throws SAXException {
            ValidatingParser.this.error("V-033", null);
        }

        public void text() throws SAXException {
            ValidatingParser.this.error("V-033", null);
        }
    }

    class MixedValidator
    extends ElementValidator {
        private ElementDecl element;

        MixedValidator(ElementDecl elementDecl) {
            this.element = elementDecl;
        }

        public void consume(String string) throws SAXException {
            String string2 = this.element.contentType;
            int n2 = 8;
            while ((n2 = string2.indexOf(string, n2 + 1)) >= 9) {
                char c10;
                if (string2.charAt(n2 - 1) != '|' || (c10 = string2.charAt(n2 + string.length())) != '|' && c10 != ')') continue;
                return;
            }
            ValidatingParser.this.error("V-034", new Object[]{this.element.name, string, string2});
        }
    }

    class ChildrenValidator
    extends ElementValidator {
        private ContentModelState state;
        private String name;

        ChildrenValidator(ElementDecl elementDecl) {
            this.state = new ContentModelState(elementDecl.model);
            this.name = elementDecl.name;
        }

        public void consume(String string) throws SAXException {
            if (this.state == null) {
                ValidatingParser.this.error("V-035", new Object[]{this.name, string});
            } else {
                try {
                    this.state = this.state.advance(string);
                }
                catch (EndOfInputException endOfInputException) {
                    ValidatingParser.this.error("V-036", new Object[]{this.name, string});
                }
            }
        }

        public void done() throws SAXException {
            if (this.state != null && !this.state.terminate()) {
                ValidatingParser.this.error("V-038", new Object[]{this.name});
            }
        }

        public void text() throws SAXException {
            ValidatingParser.this.error("V-037", new Object[]{this.name});
        }
    }
}

