/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.EventQueue;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.FolderNotFoundException;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.MethodNotSupportedException;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.event.ConnectionEvent;
import javax.mail.event.ConnectionListener;
import javax.mail.event.FolderEvent;
import javax.mail.event.FolderListener;
import javax.mail.event.MailEvent;
import javax.mail.event.MessageChangedEvent;
import javax.mail.event.MessageChangedListener;
import javax.mail.event.MessageCountEvent;
import javax.mail.event.MessageCountListener;
import javax.mail.search.SearchTerm;

public abstract class Folder {
    protected Store store;
    protected int mode = -1;
    public static final int HOLDS_MESSAGES = 1;
    public static final int HOLDS_FOLDERS = 2;
    public static final int READ_ONLY = 1;
    public static final int READ_WRITE = 2;
    private Vector connectionListeners = null;
    private Vector folderListeners = null;
    private Vector messageCountListeners = null;
    private Vector messageChangedListeners = null;
    private EventQueue q;

    protected Folder(Store store) {
        this.store = store;
    }

    public synchronized void addConnectionListener(ConnectionListener connectionListener) {
        if (this.connectionListeners == null) {
            this.connectionListeners = new Vector();
        }
        this.connectionListeners.addElement(connectionListener);
    }

    public synchronized void addFolderListener(FolderListener folderListener) {
        if (this.folderListeners == null) {
            this.folderListeners = new Vector();
        }
        this.folderListeners.addElement(folderListener);
    }

    public synchronized void addMessageChangedListener(MessageChangedListener messageChangedListener) {
        if (this.messageChangedListeners == null) {
            this.messageChangedListeners = new Vector();
        }
        this.messageChangedListeners.addElement(messageChangedListener);
    }

    public synchronized void addMessageCountListener(MessageCountListener messageCountListener) {
        if (this.messageCountListeners == null) {
            this.messageCountListeners = new Vector();
        }
        this.messageCountListeners.addElement(messageCountListener);
    }

    public abstract void appendMessages(Message[] var1) throws MessagingException;

    public abstract void close(boolean var1) throws MessagingException;

    public void copyMessages(Message[] messageArray, Folder folder) throws MessagingException {
        if (!folder.exists()) {
            throw new FolderNotFoundException(String.valueOf(folder.getFullName()) + " does not exist", folder);
        }
        folder.appendMessages(messageArray);
    }

    public abstract boolean create(int var1) throws MessagingException;

    public abstract boolean delete(boolean var1) throws MessagingException;

    public abstract boolean exists() throws MessagingException;

    public abstract Message[] expunge() throws MessagingException;

    public void fetch(Message[] messageArray, FetchProfile fetchProfile) throws MessagingException {
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.terminateQueue();
    }

    public abstract Folder getFolder(String var1) throws MessagingException;

    public abstract String getFullName();

    public abstract Message getMessage(int var1) throws MessagingException;

    public abstract int getMessageCount() throws MessagingException;

    public synchronized Message[] getMessages() throws MessagingException {
        int n2 = this.getMessageCount();
        Message[] messageArray = new Message[n2];
        int n3 = 1;
        while (n3 <= n2) {
            messageArray[n3 - 1] = this.getMessage(n3);
            ++n3;
        }
        return messageArray;
    }

    public synchronized Message[] getMessages(int n2, int n3) throws MessagingException {
        Message[] messageArray = new Message[n3 - n2 + 1];
        int n4 = n2;
        while (n4 <= n3) {
            messageArray[n4 - n2] = this.getMessage(n4);
            ++n4;
        }
        return messageArray;
    }

    public synchronized Message[] getMessages(int[] nArray) throws MessagingException {
        int n2 = nArray.length;
        Message[] messageArray = new Message[n2];
        int n3 = 0;
        while (n3 < n2) {
            messageArray[n3] = this.getMessage(nArray[n3]);
            ++n3;
        }
        return messageArray;
    }

    public int getMode() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Folder not open");
        }
        return this.mode;
    }

    public abstract String getName();

    public synchronized int getNewMessageCount() throws MessagingException {
        if (!this.isOpen()) {
            return -1;
        }
        int n2 = 0;
        int n3 = this.getMessageCount();
        int n4 = 1;
        while (n4 <= n3) {
            try {
                if (this.getMessage(n4).isSet(Flags.Flag.RECENT)) {
                    ++n2;
                }
            }
            catch (MessageRemovedException messageRemovedException) {}
            ++n4;
        }
        return n2;
    }

    public abstract Folder getParent() throws MessagingException;

    public abstract Flags getPermanentFlags();

    public abstract char getSeparator() throws MessagingException;

    public Store getStore() {
        return this.store;
    }

    public abstract int getType() throws MessagingException;

    public URLName getURLName() throws MessagingException {
        URLName uRLName = this.getStore().getURLName();
        String string = this.getFullName();
        StringBuffer stringBuffer = new StringBuffer();
        char c10 = this.getSeparator();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, new Character(c10).toString(), true);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.charAt(0) == c10) {
                    stringBuffer.append("/");
                    continue;
                }
                stringBuffer.append(string2);
            }
        }
        return new URLName(uRLName.getProtocol(), uRLName.getHost(), uRLName.getPort(), stringBuffer.toString(), uRLName.getUsername(), null);
    }

    public synchronized int getUnreadMessageCount() throws MessagingException {
        if (!this.isOpen()) {
            return -1;
        }
        int n2 = 0;
        int n3 = this.getMessageCount();
        int n4 = 1;
        while (n4 <= n3) {
            try {
                if (!this.getMessage(n4).isSet(Flags.Flag.SEEN)) {
                    ++n2;
                }
            }
            catch (MessageRemovedException messageRemovedException) {}
            ++n4;
        }
        return n2;
    }

    public abstract boolean hasNewMessages() throws MessagingException;

    public abstract boolean isOpen();

    public boolean isSubscribed() {
        return true;
    }

    public Folder[] list() throws MessagingException {
        return this.list("%");
    }

    public abstract Folder[] list(String var1) throws MessagingException;

    public Folder[] listSubscribed() throws MessagingException {
        return this.listSubscribed("%");
    }

    public Folder[] listSubscribed(String string) throws MessagingException {
        return this.list(string);
    }

    protected void notifyConnectionListeners(int n2) {
        if (this.connectionListeners != null) {
            ConnectionEvent connectionEvent = new ConnectionEvent(this, n2);
            this.queueEvent(connectionEvent, this.connectionListeners);
        }
        if (n2 == 3) {
            this.terminateQueue();
        }
    }

    protected void notifyFolderListeners(int n2) {
        if (this.folderListeners != null) {
            FolderEvent folderEvent = new FolderEvent(this, this, n2);
            this.queueEvent(folderEvent, this.folderListeners);
        }
        this.store.notifyFolderListeners(n2, this);
    }

    protected void notifyFolderRenamedListeners(Folder folder) {
        if (this.folderListeners != null) {
            FolderEvent folderEvent = new FolderEvent(this, this, folder, 3);
            this.queueEvent(folderEvent, this.folderListeners);
        }
        this.store.notifyFolderRenamedListeners(this, folder);
    }

    protected void notifyMessageAddedListeners(Message[] messageArray) {
        if (this.messageCountListeners == null) {
            return;
        }
        MessageCountEvent messageCountEvent = new MessageCountEvent(this, 1, false, messageArray);
        this.queueEvent(messageCountEvent, this.messageCountListeners);
    }

    protected void notifyMessageChangedListeners(int n2, Message message) {
        if (this.messageChangedListeners == null) {
            return;
        }
        MessageChangedEvent messageChangedEvent = new MessageChangedEvent(this, n2, message);
        this.queueEvent(messageChangedEvent, this.messageChangedListeners);
    }

    protected void notifyMessageRemovedListeners(boolean bl2, Message[] messageArray) {
        if (this.messageCountListeners == null) {
            return;
        }
        MessageCountEvent messageCountEvent = new MessageCountEvent(this, 2, bl2, messageArray);
        this.queueEvent(messageCountEvent, this.messageCountListeners);
    }

    public abstract void open(int var1) throws MessagingException;

    private synchronized void queueEvent(MailEvent mailEvent, Vector vector) {
        if (this.q == null) {
            this.q = new EventQueue();
        }
        Vector vector2 = (Vector)vector.clone();
        this.q.enqueue(mailEvent, vector2);
    }

    public synchronized void removeConnectionListener(ConnectionListener connectionListener) {
        if (this.connectionListeners != null) {
            this.connectionListeners.removeElement(connectionListener);
        }
    }

    public synchronized void removeFolderListener(FolderListener folderListener) {
        if (this.folderListeners != null) {
            this.folderListeners.removeElement(folderListener);
        }
    }

    public synchronized void removeMessageChangedListener(MessageChangedListener messageChangedListener) {
        if (this.messageChangedListeners != null) {
            this.messageChangedListeners.removeElement(messageChangedListener);
        }
    }

    public synchronized void removeMessageCountListener(MessageCountListener messageCountListener) {
        if (this.messageCountListeners != null) {
            this.messageCountListeners.removeElement(messageCountListener);
        }
    }

    public abstract boolean renameTo(Folder var1) throws MessagingException;

    public Message[] search(SearchTerm searchTerm) throws MessagingException {
        return this.search(searchTerm, this.getMessages());
    }

    public Message[] search(SearchTerm searchTerm, Message[] messageArray) throws MessagingException {
        Vector<Message> vector = new Vector<Message>();
        int n2 = 0;
        while (n2 < messageArray.length) {
            try {
                if (messageArray[n2].match(searchTerm)) {
                    vector.addElement(messageArray[n2]);
                }
            }
            catch (MessageRemovedException messageRemovedException) {}
            ++n2;
        }
        Object[] objectArray = new Message[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public synchronized void setFlags(int n2, int n3, Flags flags, boolean bl2) throws MessagingException {
        int n4 = n2;
        while (n4 <= n3) {
            try {
                Message message = this.getMessage(n4);
                message.setFlags(flags, bl2);
            }
            catch (MessageRemovedException messageRemovedException) {}
            ++n4;
        }
    }

    public synchronized void setFlags(int[] nArray, Flags flags, boolean bl2) throws MessagingException {
        int n2 = 0;
        while (n2 < nArray.length) {
            try {
                Message message = this.getMessage(nArray[n2]);
                message.setFlags(flags, bl2);
            }
            catch (MessageRemovedException messageRemovedException) {}
            ++n2;
        }
    }

    public synchronized void setFlags(Message[] messageArray, Flags flags, boolean bl2) throws MessagingException {
        int n2 = 0;
        while (n2 < messageArray.length) {
            try {
                messageArray[n2].setFlags(flags, bl2);
            }
            catch (MessageRemovedException messageRemovedException) {}
            ++n2;
        }
    }

    public void setSubscribed(boolean bl2) throws MessagingException {
        throw new MethodNotSupportedException();
    }

    private synchronized void terminateQueue() {
        if (this.q != null) {
            Vector vector = new Vector();
            vector.setSize(1);
            this.q.enqueue(new MailEvent(new Object()){

                public void dispatch(Object object) {
                    Thread.currentThread().interrupt();
                }
            }, vector);
            this.q = null;
        }
    }

    public String toString() {
        String string = this.getFullName();
        if (string != null) {
            return string;
        }
        return super.toString();
    }
}

