/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.MultipartDataSource;
import javax.mail.Part;

public abstract class Multipart {
    protected Vector parts = new Vector();
    protected String contentType = "multipart/mixed";
    protected Part parent;

    protected Multipart() {
    }

    public synchronized void addBodyPart(BodyPart bodyPart) throws MessagingException {
        if (this.parts == null) {
            this.parts = new Vector();
        }
        this.parts.addElement(bodyPart);
        bodyPart.setParent(this);
    }

    public synchronized void addBodyPart(BodyPart bodyPart, int n2) throws MessagingException {
        if (this.parts == null) {
            this.parts = new Vector();
        }
        this.parts.insertElementAt(bodyPart, n2);
        bodyPart.setParent(this);
    }

    public BodyPart getBodyPart(int n2) throws MessagingException {
        if (this.parts == null) {
            throw new IndexOutOfBoundsException("No such BodyPart");
        }
        return (BodyPart)this.parts.elementAt(n2);
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getCount() throws MessagingException {
        if (this.parts == null) {
            return 0;
        }
        return this.parts.size();
    }

    public Part getParent() {
        return this.parent;
    }

    public void removeBodyPart(int n2) throws MessagingException {
        if (this.parts == null) {
            throw new IndexOutOfBoundsException("No such BodyPart");
        }
        BodyPart bodyPart = (BodyPart)this.parts.elementAt(n2);
        this.parts.removeElementAt(n2);
        bodyPart.setParent(null);
    }

    public boolean removeBodyPart(BodyPart bodyPart) throws MessagingException {
        if (this.parts == null) {
            throw new MessagingException("No such body part");
        }
        boolean bl2 = this.parts.removeElement(bodyPart);
        bodyPart.setParent(null);
        return bl2;
    }

    protected void setMultipartDataSource(MultipartDataSource multipartDataSource) throws MessagingException {
        this.contentType = multipartDataSource.getContentType();
        int n2 = multipartDataSource.getCount();
        int n3 = 0;
        while (n3 < n2) {
            this.addBodyPart(multipartDataSource.getBodyPart(n3));
            ++n3;
        }
    }

    public void setParent(Part part) {
        this.parent = part;
    }

    public abstract void writeTo(OutputStream var1) throws IOException, MessagingException;
}

