/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import com.sun.mail.util.LineInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.PasswordAuthentication;
import javax.mail.Provider;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.URLName;

public final class Session {
    private Properties props;
    private Authenticator authenticator;
    private Hashtable authTable = new Hashtable();
    private boolean debug = false;
    private Vector providers = new Vector();
    private Hashtable providersByProtocol = new Hashtable();
    private Hashtable providersByClassName = new Hashtable();
    private Properties addressMap = new Properties();
    private static Session defaultSession = null;
    static /* synthetic */ Class class$javax$mail$Session;
    static /* synthetic */ Class class$javax$mail$URLName;

    private Session(Properties properties, Authenticator authenticator) {
        this.props = properties;
        this.authenticator = authenticator;
        if (Boolean.valueOf(properties.getProperty("mail.debug")).booleanValue()) {
            this.debug = true;
        }
        Class<?> clazz = authenticator != null ? authenticator.getClass() : this.getClass();
        this.loadProviders(clazz);
        this.loadAddressMap(clazz);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean getDebug() {
        return this.debug;
    }

    public static Session getDefaultInstance(Properties properties, Authenticator authenticator) {
        if (defaultSession == null) {
            defaultSession = new Session(properties, authenticator);
        } else if (Session.defaultSession.authenticator != authenticator && (Session.defaultSession.authenticator == null || authenticator == null || Session.defaultSession.authenticator.getClass().getClassLoader() != authenticator.getClass().getClassLoader())) {
            throw new SecurityException("Access to default session denied");
        }
        return defaultSession;
    }

    public Folder getFolder(URLName uRLName) throws MessagingException {
        Store store = this.getStore(uRLName);
        store.connect();
        return store.getFolder(uRLName);
    }

    public static Session getInstance(Properties properties, Authenticator authenticator) {
        return new Session(properties, authenticator);
    }

    public PasswordAuthentication getPasswordAuthentication(URLName uRLName) {
        return (PasswordAuthentication)this.authTable.get(uRLName);
    }

    public Properties getProperties() {
        return this.props;
    }

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    public Provider getProvider(String string) throws NoSuchProviderException {
        if (string == null || string.length() <= 0) {
            throw new NoSuchProviderException("Invalid protocol: null");
        }
        Provider provider = null;
        String string2 = this.props.getProperty("mail." + string + ".class");
        if (string2 != null) {
            if (this.debug) {
                System.out.println("DEBUG: mail." + string + ".class property exists and points to " + string2);
            }
            provider = (Provider)this.providersByClassName.get(string2);
        }
        if (provider != null) {
            return provider;
        }
        provider = (Provider)this.providersByProtocol.get(string);
        if (provider == null) {
            throw new NoSuchProviderException("No provider for " + string);
        }
        if (this.debug) {
            System.out.println("\nDEBUG: getProvider() returning " + provider.toString());
        }
        return provider;
    }

    public Provider[] getProviders() {
        Object[] objectArray = new Provider[this.providers.size()];
        this.providers.copyInto(objectArray);
        return objectArray;
    }

    private Object getService(Provider provider, URLName uRLName) throws NoSuchProviderException {
        if (provider == null) {
            throw new NoSuchProviderException("null");
        }
        if (uRLName == null) {
            uRLName = new URLName(provider.getProtocol(), null, -1, null, null, null);
        }
        Object var3_3 = null;
        try {
            Class<?> clazz = Class.forName(provider.getClassName());
            Class[] classArray = new Class[]{class$javax$mail$Session != null ? class$javax$mail$Session : (class$javax$mail$Session = Session.class$("javax.mail.Session")), class$javax$mail$URLName != null ? class$javax$mail$URLName : (class$javax$mail$URLName = Session.class$("javax.mail.URLName"))};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this, uRLName};
            var3_3 = constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            if (this.debug) {
                exception.printStackTrace();
            }
            throw new NoSuchProviderException(provider.getProtocol());
        }
        return var3_3;
    }

    public Store getStore() throws NoSuchProviderException {
        return this.getStore(this.getProperty("mail.store.protocol"));
    }

    public Store getStore(String string) throws NoSuchProviderException {
        return this.getStore(new URLName(string, null, -1, null, null, null));
    }

    public Store getStore(Provider provider) throws NoSuchProviderException {
        return this.getStore(provider, null);
    }

    private Store getStore(Provider provider, URLName uRLName) throws NoSuchProviderException {
        if (provider == null || provider.getType() != Provider.Type.STORE) {
            throw new NoSuchProviderException("invalid provider");
        }
        try {
            return (Store)this.getService(provider, uRLName);
        }
        catch (ClassCastException classCastException) {
            throw new NoSuchProviderException("incorrect class");
        }
    }

    public Store getStore(URLName uRLName) throws NoSuchProviderException {
        String string = uRLName.getProtocol();
        Provider provider = this.getProvider(string);
        return this.getStore(provider, uRLName);
    }

    public Transport getTransport() throws NoSuchProviderException {
        return this.getTransport(this.getProperty("mail.transport.protocol"));
    }

    public Transport getTransport(String string) throws NoSuchProviderException {
        return this.getTransport(new URLName(string, null, -1, null, null, null));
    }

    public Transport getTransport(Address address) throws NoSuchProviderException {
        String string = (String)((Hashtable)this.addressMap).get(address.getType());
        if (string == null) {
            throw new NoSuchProviderException("No provider for Address type: " + address.getType());
        }
        return this.getTransport(string);
    }

    public Transport getTransport(Provider provider) throws NoSuchProviderException {
        return this.getTransport(provider, null);
    }

    private Transport getTransport(Provider provider, URLName uRLName) throws NoSuchProviderException {
        if (provider == null || provider.getType() != Provider.Type.TRANSPORT) {
            throw new NoSuchProviderException("invalid provider");
        }
        try {
            return (Transport)this.getService(provider, uRLName);
        }
        catch (ClassCastException classCastException) {
            throw new NoSuchProviderException("incorrect class");
        }
    }

    public Transport getTransport(URLName uRLName) throws NoSuchProviderException {
        String string = uRLName.getProtocol();
        Provider provider = this.getProvider(string);
        return this.getTransport(provider, uRLName);
    }

    private void loadAddressMap(Class clazz) {
        block14: {
            InputStream inputStream = null;
            String string = "/META-INF/javamail.default.address.map";
            inputStream = clazz.getResourceAsStream(string);
            if (inputStream != null) {
                try {
                    this.addressMap.load(inputStream);
                    inputStream.close();
                }
                catch (IOException iOException) {
                }
                catch (SecurityException securityException) {}
            }
            InputStream inputStream2 = null;
            String string2 = "/META-INF/javamail.address.map";
            inputStream2 = clazz.getResourceAsStream(string2);
            if (inputStream2 != null) {
                try {
                    this.addressMap.load(inputStream2);
                    inputStream2.close();
                }
                catch (IOException iOException) {}
            }
            InputStream inputStream3 = null;
            try {
                String string3 = String.valueOf(System.getProperty("java.home")) + File.separator + "lib" + File.separator + "javamail.address.map";
                inputStream3 = new BufferedInputStream(new FileInputStream(string3));
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (SecurityException securityException) {}
            if (inputStream3 == null) break block14;
            try {
                this.addressMap.load(inputStream3);
                inputStream3.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void loadProviders(Class clazz) {
        block24: {
            block23: {
                Object object;
                block22: {
                    BufferedInputStream bufferedInputStream = null;
                    try {
                        object = String.valueOf(System.getProperty("java.home")) + File.separator + "lib" + File.separator + "javamail.providers";
                        bufferedInputStream = new BufferedInputStream(new FileInputStream((String)object));
                        if (bufferedInputStream != null) {
                            this.loadProvidersFromStream(bufferedInputStream);
                            ((InputStream)bufferedInputStream).close();
                            Session.pr("DEBUG: loaded providers in <java.home>/lib");
                        } else if (this.debug) {
                            Session.pr("DEBUG: not loading system providers in <java.home>/lib");
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (this.debug) {
                            Session.pr("DEBUG: not loading system providers in <java.home>/lib");
                        }
                    }
                    catch (IOException iOException) {
                        if (this.debug) {
                            Session.pr("DEBUG: " + iOException.getMessage());
                        }
                    }
                    catch (SecurityException securityException) {
                        if (!this.debug) break block22;
                        Session.pr("DEBUG: not loading system providers in <java.home>/lib");
                    }
                }
                object = null;
                String string = "/META-INF/javamail.providers";
                object = clazz.getResourceAsStream(string);
                if (object != null) {
                    try {
                        this.loadProvidersFromStream((InputStream)object);
                        ((InputStream)object).close();
                        if (this.debug) {
                            Session.pr("DEBUG:successfully loaded optional custom providers: " + string);
                        }
                        break block23;
                    }
                    catch (IOException iOException) {
                        if (this.debug) {
                            Session.pr("DEBUG: " + iOException.getMessage());
                        }
                        break block23;
                    }
                }
                if (this.debug) {
                    Session.pr("DEBUG: not loading optional custom providers file: " + string);
                }
            }
            InputStream inputStream = null;
            String string = "/META-INF/javamail.default.providers";
            inputStream = clazz.getResourceAsStream(string);
            if (inputStream != null) {
                try {
                    this.loadProvidersFromStream(inputStream);
                    inputStream.close();
                    if (this.debug) {
                        Session.pr("DEBUG: successfully loaded default providers");
                    }
                    break block24;
                }
                catch (IOException iOException) {
                    if (this.debug) {
                        Session.pr("DEBUG: " + iOException.getMessage());
                    }
                    break block24;
                }
            }
            if (this.debug) {
                Session.pr("DEBUG: can't load default providers file" + string);
            }
        }
        if (this.debug) {
            System.out.println("\nDEBUG: Tables of loaded providers");
            Session.pr("DEBUG: Providers Listed By Class Name: " + this.providersByClassName.toString());
            Session.pr("DEBUG: Providers Listed By Protocol: " + this.providersByProtocol.toString());
        }
    }

    private void loadProvidersFromStream(InputStream inputStream) throws IOException {
        if (inputStream != null) {
            String string;
            LineInputStream lineInputStream = new LineInputStream(inputStream);
            while ((string = lineInputStream.readLine()) != null) {
                Object object;
                if (string.startsWith("#")) continue;
                Provider.Type type = null;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                while (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken().trim();
                    int n2 = ((String)object).indexOf("=");
                    if (((String)object).startsWith("protocol=")) {
                        string2 = ((String)object).substring(n2 + 1);
                        continue;
                    }
                    if (((String)object).startsWith("type=")) {
                        String string6 = ((String)object).substring(n2 + 1);
                        if (string6.equalsIgnoreCase("store")) {
                            type = Provider.Type.STORE;
                            continue;
                        }
                        if (!string6.equalsIgnoreCase("transport")) continue;
                        type = Provider.Type.TRANSPORT;
                        continue;
                    }
                    if (((String)object).startsWith("class=")) {
                        string3 = ((String)object).substring(n2 + 1);
                        continue;
                    }
                    if (((String)object).startsWith("vendor=")) {
                        string4 = ((String)object).substring(n2 + 1);
                        continue;
                    }
                    if (!((String)object).startsWith("version=")) continue;
                    string5 = ((String)object).substring(n2 + 1);
                }
                if (type == null || string2 == null || string3 == null || string2.length() <= 0 || string3.length() <= 0) {
                    if (!this.debug) continue;
                    System.out.println("DEBUG: Bad provider entry: " + string);
                    continue;
                }
                object = new Provider(type, string2, string3, string4, string5);
                this.providers.addElement(object);
                this.providersByClassName.put(string3, object);
                if (this.providersByProtocol.containsKey(string2)) continue;
                this.providersByProtocol.put(string2, object);
            }
        }
    }

    private static void pr(String string) {
        System.out.println(string);
    }

    public PasswordAuthentication requestPasswordAuthentication(InetAddress inetAddress, int n2, String string, String string2, String string3) {
        if (this.authenticator != null) {
            return this.authenticator.requestPasswordAuthentication(inetAddress, n2, string, string2, string3);
        }
        return null;
    }

    public void setDebug(boolean bl2) {
        this.debug = bl2;
    }

    public void setPasswordAuthentication(URLName uRLName, PasswordAuthentication passwordAuthentication) {
        if (passwordAuthentication == null) {
            this.authTable.remove(uRLName);
        } else {
            this.authTable.put(uRLName, passwordAuthentication);
        }
    }

    public void setProvider(Provider provider) throws NoSuchProviderException {
        if (provider == null) {
            throw new NoSuchProviderException("Can't set null provider");
        }
        this.providersByProtocol.put(provider.getProtocol(), provider);
        ((Hashtable)this.props).put("mail." + provider.getProtocol() + ".class", provider.getClassName());
    }
}

