/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeUtility;

public class InternetAddress
extends Address {
    protected String address;
    protected String personal;
    protected String encodedPersonal;
    private static final String rfc822phrase = "()<>@,;:\\\"\t []".replace(' ', '\u0000').replace('\t', '\u0000');
    private static final String specialsNoDotNoAt = "()<>,;:\\\"[]";
    private static final String specialsNoDot = "()<>,;:\\\"[]@";

    public InternetAddress() {
    }

    public InternetAddress(String string) throws AddressException {
        InternetAddress[] internetAddressArray = InternetAddress.parse(string, true);
        if (internetAddressArray.length != 1) {
            throw new AddressException("Illegal address", string);
        }
        this.address = internetAddressArray[0].address;
        this.personal = internetAddressArray[0].personal;
        this.encodedPersonal = internetAddressArray[0].encodedPersonal;
    }

    public InternetAddress(String string, String string2) throws UnsupportedEncodingException {
        this(string, string2, null);
    }

    public InternetAddress(String string, String string2, String string3) throws UnsupportedEncodingException {
        this.address = string;
        this.setPersonal(string2, string3);
    }

    private InternetAddress(String string, boolean bl2) throws AddressException {
        this(string);
        if (bl2) {
            InternetAddress.checkAddress(this.address, true, true);
        }
    }

    private static void checkAddress(String string, boolean bl2, boolean bl3) throws AddressException {
        String string2;
        String string3;
        int n2;
        int n3 = 0;
        if (string.indexOf(34) >= 0) {
            return;
        }
        if (!bl3 || bl2) {
            n3 = 0;
            while ((n2 = InternetAddress.indexOfAny(string, ",:", n3)) >= 0) {
                if (string.charAt(n3) != '@') {
                    throw new AddressException("Illegal route-addr", string);
                }
                if (string.charAt(n2) == ':') {
                    n3 = n2 + 1;
                    break;
                }
                n3 = n2 + 1;
            }
        }
        if ((n2 = string.indexOf(64, n3)) >= 0) {
            if (n2 == n3) {
                throw new AddressException("Missing local name", string);
            }
            if (n2 == string.length() - 1) {
                throw new AddressException("Missing domain", string);
            }
            string3 = string.substring(n3, n2);
            string2 = string.substring(n2 + 1);
        } else {
            string3 = string;
            string2 = null;
        }
        if (InternetAddress.indexOfAny(string, " \t\n\r") >= 0) {
            throw new AddressException("Illegal whitespace in address", string);
        }
        if (InternetAddress.indexOfAny(string3, specialsNoDot) >= 0) {
            throw new AddressException("Illegal character in local name", string);
        }
        if (string2 != null && string2.indexOf(91) < 0 && InternetAddress.indexOfAny(string2, specialsNoDot) >= 0) {
            throw new AddressException("Illegal character in domain", string);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof InternetAddress)) {
            return false;
        }
        String string = ((InternetAddress)object).getAddress();
        if (string == this.address) {
            return true;
        }
        return this.address != null && this.address.equalsIgnoreCase(string);
    }

    public String getAddress() {
        return this.address;
    }

    public static InternetAddress getLocalAddress(Session session) {
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            if (session == null) {
                string = System.getProperty("user.name");
                string2 = InetAddress.getLocalHost().getHostName();
            } else {
                string3 = session.getProperty("mail.from");
                if (string3 == null) {
                    InetAddress inetAddress;
                    string = session.getProperty("mail.user");
                    if (string == null) {
                        string = session.getProperty("user.name");
                    }
                    if (string == null) {
                        string = System.getProperty("user.name");
                    }
                    if ((string2 = session.getProperty("mail.host")) == null && (inetAddress = InetAddress.getLocalHost()) != null) {
                        string2 = inetAddress.getHostName();
                    }
                }
            }
            if (string3 == null && string != null && string2 != null) {
                string3 = String.valueOf(string) + "@" + string2;
            }
            if (string3 != null) {
                return new InternetAddress(string3);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (AddressException addressException) {
        }
        catch (UnknownHostException unknownHostException) {}
        return null;
    }

    public String getPersonal() {
        if (this.personal != null) {
            return this.personal;
        }
        if (this.encodedPersonal != null) {
            try {
                this.personal = MimeUtility.decodeText(this.encodedPersonal);
                return this.personal;
            }
            catch (Exception exception) {
                return this.encodedPersonal;
            }
        }
        return null;
    }

    public String getType() {
        return "rfc822";
    }

    public int hashCode() {
        if (this.address == null) {
            return 0;
        }
        return this.address.toLowerCase().hashCode();
    }

    private static int indexOfAny(String string, String string2) {
        return InternetAddress.indexOfAny(string, string2, 0);
    }

    private static int indexOfAny(String string, String string2, int n2) {
        try {
            int n3 = string.length();
            int n4 = n2;
            while (n4 < n3) {
                if (string2.indexOf(string.charAt(n4)) >= 0) {
                    return n4;
                }
                ++n4;
            }
            return -1;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return -1;
        }
    }

    private boolean isGroup() {
        return this.address.endsWith(";") && this.address.indexOf(58) > 0;
    }

    private boolean isSimple() {
        return InternetAddress.indexOfAny(this.address, specialsNoDotNoAt) < 0;
    }

    private static int lengthOfFirstSegment(String string) {
        int n2 = string.indexOf("\r\n");
        if (n2 != -1) {
            return n2;
        }
        return string.length();
    }

    private static int lengthOfLastSegment(String string, int n2) {
        int n3 = string.lastIndexOf("\r\n");
        if (n3 != -1) {
            return string.length() - n3 - 2;
        }
        return string.length() + n2;
    }

    public static InternetAddress[] parse(String string) throws AddressException {
        return InternetAddress.parse(string, true);
    }

    public static InternetAddress[] parse(String string, boolean bl2) throws AddressException {
        String string2;
        Object object;
        InternetAddress internetAddress;
        Object object2;
        int n2 = -1;
        int n3 = -1;
        int n4 = string.length();
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        Vector<InternetAddress> vector = new Vector<InternetAddress>();
        int n5 = -1;
        int n6 = -1;
        int n7 = 0;
        while (n7 < n4) {
            char c10 = string.charAt(n7);
            switch (c10) {
                case '(': {
                    bl5 = true;
                    if (n6 >= 0 && n5 == -1) {
                        n5 = n7;
                    }
                    if (n2 == -1) {
                        n2 = n7 + 1;
                    }
                    ++n7;
                    int n8 = 1;
                    while (n7 < n4 && n8 > 0) {
                        c10 = string.charAt(n7);
                        switch (c10) {
                            case '\\': {
                                ++n7;
                                break;
                            }
                            case '(': {
                                ++n8;
                                break;
                            }
                            case ')': {
                                --n8;
                                break;
                            }
                        }
                        ++n7;
                    }
                    if (n8 > 0) {
                        throw new AddressException("Missing ')'", string, n7);
                    }
                    --n7;
                    if (n3 != -1) break;
                    n3 = n7;
                    break;
                }
                case ')': {
                    throw new AddressException("Missing '('", string, n7);
                }
                case '<': {
                    bl5 = true;
                    if (bl4) {
                        throw new AddressException("Extra route-addr", string, n7);
                    }
                    if (!bl3) {
                        n2 = n6;
                        n3 = n7;
                        n6 = n7 + 1;
                    }
                    ++n7;
                    block31: while (n7 < n4) {
                        c10 = string.charAt(n7);
                        switch (c10) {
                            case '\\': {
                                ++n7;
                            }
                            default: {
                                ++n7;
                                continue block31;
                            }
                            case '>': {
                                break block31;
                            }
                        }
                    }
                    if (n7 >= n4) {
                        throw new AddressException("Missing '>'", string, n7);
                    }
                    bl4 = true;
                    n5 = n7;
                    break;
                }
                case '>': {
                    throw new AddressException("Missing '<'", string, n7);
                }
                case '\"': {
                    bl5 = true;
                    if (n6 == -1) {
                        n6 = n7;
                    }
                    ++n7;
                    block32: while (n7 < n4) {
                        c10 = string.charAt(n7);
                        switch (c10) {
                            case '\\': {
                                ++n7;
                            }
                            default: {
                                ++n7;
                                continue block32;
                            }
                            case '\"': {
                                break block32;
                            }
                        }
                    }
                    if (n7 < n4) break;
                    throw new AddressException("Missing '\"'", string, n7);
                }
                case '[': {
                    bl5 = true;
                    ++n7;
                    block33: while (n7 < n4) {
                        c10 = string.charAt(n7);
                        switch (c10) {
                            case '\\': {
                                ++n7;
                            }
                            default: {
                                ++n7;
                                continue block33;
                            }
                            case ']': {
                                break block33;
                            }
                        }
                    }
                    if (n7 < n4) break;
                    throw new AddressException("Missing ']'", string, n7);
                }
                case ',': {
                    if (n6 == -1) {
                        bl4 = false;
                        bl5 = false;
                        n5 = -1;
                        n6 = -1;
                        break;
                    }
                    if (bl3) break;
                    if (n5 == -1) {
                        n5 = n7;
                    }
                    object2 = string.substring(n6, n5).trim();
                    if (bl5 || bl2) {
                        InternetAddress.checkAddress((String)object2, bl4, bl2);
                        internetAddress = new InternetAddress();
                        internetAddress.setAddress((String)object2);
                        if (n2 >= 0) {
                            object = string.substring(n2, n3).trim();
                            if (((String)object).startsWith("\"") && ((String)object).endsWith("\"")) {
                                object = ((String)object).substring(1, ((String)object).length() - 1);
                            }
                            internetAddress.encodedPersonal = object;
                            n3 = -1;
                            n2 = -1;
                        }
                        vector.addElement(internetAddress);
                    } else {
                        object = new StringTokenizer((String)object2);
                        while (((StringTokenizer)object).hasMoreTokens()) {
                            string2 = ((StringTokenizer)object).nextToken();
                            InternetAddress.checkAddress(string2, false, bl2);
                            internetAddress = new InternetAddress();
                            internetAddress.setAddress(string2);
                            vector.addElement(internetAddress);
                        }
                    }
                    bl4 = false;
                    bl5 = false;
                    n5 = -1;
                    n6 = -1;
                    break;
                }
                case ':': {
                    bl5 = true;
                    if (bl3) {
                        throw new AddressException("Nested group", string, n7);
                    }
                    bl3 = true;
                    break;
                }
                case ';': {
                    if (!bl3) {
                        throw new AddressException("Illegal semicolon, not in group", string, n7);
                    }
                    bl3 = false;
                    internetAddress = new InternetAddress();
                    n5 = n7 + 1;
                    internetAddress.setAddress(string.substring(n6, n5).trim());
                    vector.addElement(internetAddress);
                    bl4 = false;
                    n5 = -1;
                    n6 = -1;
                    break;
                }
                default: {
                    if (n6 != -1) break;
                    n6 = n7;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
            }
            ++n7;
        }
        if (n6 >= 0) {
            if (n5 == -1) {
                n5 = n7;
            }
            object2 = string.substring(n6, n5).trim();
            if (bl5 || bl2) {
                InternetAddress.checkAddress((String)object2, bl4, bl2);
                internetAddress = new InternetAddress();
                internetAddress.setAddress((String)object2);
                if (n2 >= 0) {
                    object = string.substring(n2, n3).trim();
                    if (((String)object).startsWith("\"") && ((String)object).endsWith("\"")) {
                        object = ((String)object).substring(1, ((String)object).length() - 1);
                    }
                    internetAddress.encodedPersonal = object;
                }
                vector.addElement(internetAddress);
            } else {
                object = new StringTokenizer((String)object2);
                while (((StringTokenizer)object).hasMoreTokens()) {
                    string2 = ((StringTokenizer)object).nextToken();
                    InternetAddress.checkAddress(string2, false, bl2);
                    internetAddress = new InternetAddress();
                    internetAddress.setAddress(string2);
                    vector.addElement(internetAddress);
                }
            }
        }
        object2 = new InternetAddress[vector.size()];
        vector.copyInto((Object[])object2);
        return object2;
    }

    private static String quotePhrase(String string) {
        int n2 = string.length();
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < n2) {
            char c10 = string.charAt(n3);
            if (c10 == '\"' || c10 == '\\') {
                StringBuffer stringBuffer = new StringBuffer(n2 + 3);
                stringBuffer.append('\"');
                int n4 = 0;
                while (n4 < n2) {
                    char c11 = string.charAt(n4);
                    if (c11 == '\"' || c11 == '\\') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c11);
                    ++n4;
                }
                stringBuffer.append('\"');
                return stringBuffer.toString();
            }
            if (c10 < ' ' && c10 != '\r' && c10 != '\n' && c10 != '\t' || c10 >= '\u007f' || rfc822phrase.indexOf(c10) >= 0) {
                bl2 = true;
            }
            ++n3;
        }
        if (bl2) {
            StringBuffer stringBuffer = new StringBuffer(n2 + 2);
            stringBuffer.append('\"').append(string).append('\"');
            return stringBuffer.toString();
        }
        return string;
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public void setPersonal(String string) throws UnsupportedEncodingException {
        this.personal = string;
        this.encodedPersonal = string != null ? MimeUtility.encodeWord(string) : null;
    }

    public void setPersonal(String string, String string2) throws UnsupportedEncodingException {
        this.personal = string;
        this.encodedPersonal = string != null ? MimeUtility.encodeWord(string, string2, null) : null;
    }

    public String toString() {
        if (this.encodedPersonal == null && this.personal != null) {
            try {
                this.encodedPersonal = MimeUtility.encodeWord(this.personal);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        if (this.encodedPersonal != null) {
            return String.valueOf(InternetAddress.quotePhrase(this.encodedPersonal)) + " <" + this.address + ">";
        }
        if (this.isGroup() || this.isSimple()) {
            return this.address;
        }
        return "<" + this.address + ">";
    }

    public static String toString(Address[] addressArray) {
        return InternetAddress.toString(addressArray, 0);
    }

    public static String toString(Address[] addressArray, int n2) {
        if (addressArray == null || addressArray.length == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < addressArray.length) {
            String string;
            int n4;
            if (n3 != 0) {
                stringBuffer.append(", ");
                n2 += 2;
            }
            if (n2 + (n4 = InternetAddress.lengthOfFirstSegment(string = addressArray[n3].toString())) > 76) {
                stringBuffer.append("\r\n ");
                n2 = 1;
            }
            stringBuffer.append(string);
            n2 = InternetAddress.lengthOfLastSegment(string, n2);
            ++n3;
        }
        return stringBuffer.toString();
    }
}

