/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.LineOutputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ContentType;
import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class MimeBodyPart
extends BodyPart
implements MimePart {
    protected DataHandler dh;
    protected byte[] content;
    protected InternetHeaders headers;

    public MimeBodyPart() {
        this.headers = new InternetHeaders();
    }

    public MimeBodyPart(InputStream inputStream) throws MessagingException {
        if (!(inputStream instanceof ByteArrayInputStream) && !(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        this.headers = new InternetHeaders(inputStream);
        try {
            this.content = ASCIIUtility.getBytes(inputStream);
        }
        catch (IOException iOException) {
            throw new MessagingException("Error reading input stream", iOException);
        }
    }

    public MimeBodyPart(InternetHeaders internetHeaders, byte[] byArray) throws MessagingException {
        this.headers = internetHeaders;
        this.content = byArray;
    }

    public void addHeader(String string, String string2) throws MessagingException {
        this.headers.addHeader(string, string2);
    }

    public void addHeaderLine(String string) throws MessagingException {
        this.headers.addHeaderLine(string);
    }

    public Enumeration getAllHeaderLines() throws MessagingException {
        return this.headers.getAllHeaderLines();
    }

    public Enumeration getAllHeaders() throws MessagingException {
        return this.headers.getAllHeaders();
    }

    public Object getContent() throws IOException, MessagingException {
        return this.getDataHandler().getContent();
    }

    public String getContentID() throws MessagingException {
        return this.getHeader("Content-Id", null);
    }

    public String[] getContentLanguage() throws MessagingException {
        return MimeBodyPart.getContentLanguage(this);
    }

    static String[] getContentLanguage(MimePart mimePart) throws MessagingException {
        HeaderTokenizer.Token token;
        int n2;
        String string = mimePart.getHeader("Content-Language", null);
        if (string == null) {
            return null;
        }
        HeaderTokenizer headerTokenizer = new HeaderTokenizer(string, "()<>@,;:\\\"\t []/?=");
        Vector<String> vector = new Vector<String>();
        while ((n2 = (token = headerTokenizer.next()).getType()) != -4) {
            if (n2 != -1) continue;
            vector.addElement(token.getValue());
        }
        if (vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String getContentMD5() throws MessagingException {
        return this.getHeader("Content-MD5", null);
    }

    protected InputStream getContentStream() throws MessagingException {
        if (this.content != null) {
            return new ByteArrayInputStream(this.content);
        }
        throw new MessagingException("No content");
    }

    public String getContentType() throws MessagingException {
        String string = this.getHeader("Content-Type", null);
        if (string == null) {
            string = "text/plain";
        }
        return string;
    }

    public DataHandler getDataHandler() throws MessagingException {
        if (this.dh == null) {
            this.dh = new DataHandler(new MimePartDataSource(this));
        }
        return this.dh;
    }

    public String getDescription() throws MessagingException {
        return MimeBodyPart.getDescription(this);
    }

    static String getDescription(MimePart mimePart) throws MessagingException {
        String string = mimePart.getHeader("Content-Description", null);
        if (string == null) {
            return null;
        }
        try {
            return MimeUtility.decodeText(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public String getDisposition() throws MessagingException {
        return MimeBodyPart.getDisposition(this);
    }

    static String getDisposition(MimePart mimePart) throws MessagingException {
        String string = mimePart.getHeader("Content-Disposition", null);
        if (string == null) {
            return null;
        }
        ContentDisposition contentDisposition = new ContentDisposition(string);
        return contentDisposition.getDisposition();
    }

    public String getEncoding() throws MessagingException {
        return this.getHeader("Content-Transfer-Encoding", null);
    }

    public String getFileName() throws MessagingException {
        return MimeBodyPart.getFileName(this);
    }

    static String getFileName(MimePart mimePart) throws MessagingException {
        Object object;
        String string = null;
        String string2 = mimePart.getHeader("Content-Disposition", null);
        if (string2 != null) {
            object = new ContentDisposition(string2);
            string = ((ContentDisposition)object).getParameter("filename");
        }
        if (string == null && (string2 = mimePart.getHeader("Content-Type", null)) != null) {
            object = new ContentType(string2);
            string = ((ContentType)object).getParameter("name");
        }
        return string;
    }

    public String[] getHeader(String string) throws MessagingException {
        return this.headers.getHeader(string);
    }

    public String getHeader(String string, String string2) throws MessagingException {
        return this.headers.getHeader(string, string2);
    }

    public InputStream getInputStream() throws IOException, MessagingException {
        return this.getDataHandler().getInputStream();
    }

    public int getLineCount() throws MessagingException {
        return -1;
    }

    public Enumeration getMatchingHeaderLines(String[] stringArray) throws MessagingException {
        return this.headers.getMatchingHeaderLines(stringArray);
    }

    public Enumeration getMatchingHeaders(String[] stringArray) throws MessagingException {
        return this.headers.getMatchingHeaders(stringArray);
    }

    public Enumeration getNonMatchingHeaderLines(String[] stringArray) throws MessagingException {
        return this.headers.getNonMatchingHeaderLines(stringArray);
    }

    public Enumeration getNonMatchingHeaders(String[] stringArray) throws MessagingException {
        return this.headers.getNonMatchingHeaders(stringArray);
    }

    public int getSize() throws MessagingException {
        return -1;
    }

    static void invalidateContentHeaders(MimePart mimePart) throws MessagingException {
        mimePart.removeHeader("Content-Type");
        mimePart.removeHeader("Content-Transfer-Encoding");
    }

    public boolean isMimeType(String string) throws MessagingException {
        return MimeBodyPart.isMimeType(this, string);
    }

    static boolean isMimeType(MimePart mimePart, String string) throws MessagingException {
        try {
            ContentType contentType = new ContentType(mimePart.getContentType());
            return contentType.match(string);
        }
        catch (ParseException parseException) {
            return mimePart.getContentType().equalsIgnoreCase(string);
        }
    }

    public void removeHeader(String string) throws MessagingException {
        this.headers.removeHeader(string);
    }

    public void setContent(Object object, String string) throws MessagingException {
        if (object instanceof Multipart) {
            this.setContent((Multipart)object);
        } else {
            this.setDataHandler(new DataHandler(object, string));
        }
    }

    public void setContent(Multipart multipart) throws MessagingException {
        this.setDataHandler(new DataHandler(multipart, multipart.getContentType()));
        multipart.setParent(this);
    }

    static void setContentLanguage(MimePart mimePart, String[] stringArray) throws MessagingException {
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        int n2 = 1;
        while (n2 < stringArray.length) {
            stringBuffer.append(',').append(stringArray[n2]);
            ++n2;
        }
        mimePart.setHeader("Content-Language", stringBuffer.toString());
    }

    public void setContentLanguage(String[] stringArray) throws MessagingException {
        MimeBodyPart.setContentLanguage(this, stringArray);
    }

    public void setContentMD5(String string) throws MessagingException {
        this.setHeader("Content-MD5", string);
    }

    public void setDataHandler(DataHandler dataHandler) throws MessagingException {
        this.dh = dataHandler;
        MimeBodyPart.invalidateContentHeaders(this);
    }

    public void setDescription(String string) throws MessagingException {
        this.setDescription(string, null);
    }

    public void setDescription(String string, String string2) throws MessagingException {
        MimeBodyPart.setDescription(this, string, string2);
    }

    static void setDescription(MimePart mimePart, String string, String string2) throws MessagingException {
        if (string == null) {
            mimePart.removeHeader("Content-Description");
            return;
        }
        try {
            mimePart.setHeader("Content-Description", MimeUtility.encodeText(string, string2, null));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MessagingException("Encoding error", unsupportedEncodingException);
        }
    }

    public void setDisposition(String string) throws MessagingException {
        MimeBodyPart.setDisposition(this, string);
    }

    static void setDisposition(MimePart mimePart, String string) throws MessagingException {
        if (string == null) {
            mimePart.removeHeader("Content-Disposition");
        } else {
            String string2 = mimePart.getHeader("Content-Disposition", null);
            if (string2 != null) {
                ContentDisposition contentDisposition = new ContentDisposition(string2);
                contentDisposition.setDisposition(string);
                string = contentDisposition.toString();
            }
            mimePart.setHeader("Content-Disposition", string);
        }
    }

    public void setFileName(String string) throws MessagingException {
        MimeBodyPart.setFileName(this, string);
    }

    static void setFileName(MimePart mimePart, String string) throws MessagingException {
        String string2 = mimePart.getHeader("Content-Disposition", null);
        ContentDisposition contentDisposition = new ContentDisposition(string2 == null ? "attachment" : string2);
        contentDisposition.setParameter("filename", string);
        mimePart.setHeader("Content-Disposition", contentDisposition.toString());
        string2 = mimePart.getHeader("Content-Type", null);
        if (string2 != null) {
            ContentType contentType = new ContentType(string2);
            contentType.setParameter("name", string);
            mimePart.setHeader("Content-Type", contentType.toString());
        }
    }

    public void setHeader(String string, String string2) throws MessagingException {
        this.headers.setHeader(string, string2);
    }

    public void setText(String string) throws MessagingException {
        this.setText(string, null);
    }

    public void setText(String string, String string2) throws MessagingException {
        MimeBodyPart.setText(this, string, string2);
    }

    static void setText(MimePart mimePart, String string, String string2) throws MessagingException {
        if (string2 == null) {
            string2 = MimeUtility.checkAscii(string) != 1 ? MimeUtility.getDefaultMIMECharset() : "us-ascii";
        }
        mimePart.setContent(string, "text/plain; charset=" + MimeUtility.quote(string2, "()<>@,;:\\\"\t []/?="));
    }

    protected void updateHeaders() throws MessagingException {
        MimeBodyPart.updateHeaders(this);
    }

    static void updateHeaders(MimePart mimePart) throws MessagingException {
        DataHandler dataHandler = mimePart.getDataHandler();
        if (dataHandler == null) {
            return;
        }
        try {
            Object object;
            String string = dataHandler.getContentType();
            boolean bl2 = false;
            ContentType contentType = new ContentType(string);
            if (contentType.match("multipart/*")) {
                bl2 = true;
                object = dataHandler.getContent();
                ((MimeMultipart)object).updateHeaders();
            } else if (contentType.match("message/rfc822")) {
                bl2 = true;
            }
            if (mimePart.getHeader("Content-Type") == null) {
                ContentDisposition contentDisposition;
                String string2;
                object = mimePart.getHeader("Content-Disposition", null);
                if (object != null && (string2 = (contentDisposition = new ContentDisposition((String)object)).getParameter("filename")) != null) {
                    contentType.setParameter("name", string2);
                    string = contentType.toString();
                }
                mimePart.setHeader("Content-Type", string);
            }
            if (!bl2 && mimePart.getHeader("Content-Transfer-Encoding") == null) {
                mimePart.setHeader("Content-Transfer-Encoding", MimeUtility.getEncoding(dataHandler.getDataSource()));
            }
        }
        catch (IOException iOException) {
            throw new MessagingException("IOException updating headers", iOException);
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException, MessagingException {
        MimeBodyPart.writeTo(this, outputStream, null);
    }

    static void writeTo(MimePart mimePart, OutputStream outputStream, String[] stringArray) throws IOException, MessagingException {
        LineOutputStream lineOutputStream = null;
        lineOutputStream = outputStream instanceof LineOutputStream ? (LineOutputStream)outputStream : new LineOutputStream(outputStream);
        Enumeration enumeration = mimePart.getNonMatchingHeaderLines(stringArray);
        while (enumeration.hasMoreElements()) {
            lineOutputStream.writeln((String)enumeration.nextElement());
        }
        lineOutputStream.writeln();
        outputStream = MimeUtility.encode(outputStream, mimePart.getEncoding());
        mimePart.getDataHandler().writeTo(outputStream);
        outputStream.flush();
    }
}

