/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.ConstantPool;

public class ClassName {
    public static String getClassName(String classFile) throws JasperException {
        try {
            FileInputStream fin = new FileInputStream(classFile);
            return ClassName.processClassData(fin);
        }
        catch (IOException ex2) {
            throw new JasperException(Constants.getString("jsp.error.classname"), ex2);
        }
    }

    public static void main(String[] args) {
        try {
            int i2 = 0;
            while (i2 < args.length) {
                System.out.println("Filename: " + args[i2] + " Classname: " + ClassName.getClassName(args[i2]));
                ++i2;
            }
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    private static String printClassName(String s2) {
        if (s2.charAt(0) == '[') {
            return ClassName.typeString(s2, "");
        }
        StringBuffer x2 = new StringBuffer();
        int j2 = 0;
        while (j2 < s2.length()) {
            if (s2.charAt(j2) == '/') {
                x2.append('.');
            } else {
                x2.append(s2.charAt(j2));
            }
            ++j2;
        }
        return x2.toString();
    }

    static String processClassData(InputStream in) throws JasperException, IOException {
        DataInputStream din = new DataInputStream(in);
        din.readInt();
        din.readShort();
        din.readShort();
        short count = din.readShort();
        ConstantPool[] constantPool = new ConstantPool[count];
        constantPool[0] = new ConstantPool();
        int i2 = 1;
        while (i2 < constantPool.length) {
            constantPool[i2] = new ConstantPool();
            if (!constantPool[i2].read(din)) {
                throw new JasperException(Constants.getString("jsp.error.classname"));
            }
            if (constantPool[i2].type == 5 || constantPool[i2].type == 6) {
                ++i2;
            }
            ++i2;
        }
        int i3 = 1;
        while (i3 < constantPool.length) {
            if (constantPool[i3] != null) {
                if (constantPool[i3].index1 > 0) {
                    constantPool[i3].arg1 = constantPool[constantPool[i3].index1];
                }
                if (constantPool[i3].index2 > 0) {
                    constantPool[i3].arg2 = constantPool[constantPool[i3].index2];
                }
            }
            ++i3;
        }
        short accessFlags = din.readShort();
        ConstantPool thisClass = constantPool[din.readShort()];
        din.close();
        return ClassName.printClassName(thisClass.arg1.strValue);
    }

    private static String typeString(String typeString, String varName) {
        int isArray = 0;
        int ndx = 0;
        StringBuffer x2 = new StringBuffer();
        while (typeString.charAt(ndx) == '[') {
            ++isArray;
            ++ndx;
        }
        switch (typeString.charAt(ndx)) {
            case 'B': {
                x2.append("byte ");
                break;
            }
            case 'C': {
                x2.append("char ");
                break;
            }
            case 'D': {
                x2.append("double ");
                break;
            }
            case 'F': {
                x2.append("float ");
                break;
            }
            case 'I': {
                x2.append("int ");
                break;
            }
            case 'J': {
                x2.append("long ");
                break;
            }
            case 'L': {
                int i2 = ndx + 1;
                while (i2 < typeString.indexOf(59)) {
                    if (typeString.charAt(i2) != '/') {
                        x2.append(typeString.charAt(i2));
                    } else {
                        x2.append('.');
                    }
                    ++i2;
                }
                x2.append(" ");
                break;
            }
            case 'V': {
                x2.append("void ");
                break;
            }
            case 'S': {
                x2.append("short ");
                break;
            }
            case 'Z': {
                x2.append("boolean ");
                break;
            }
        }
        x2.append(varName);
        while (isArray > 0) {
            x2.append("[]");
            --isArray;
        }
        return x2.toString();
    }
}

