/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspEngineContext;
import org.apache.jasper.compiler.EscapeUnicodeWriter;
import org.apache.jasper.compiler.JavaCompiler;
import org.apache.jasper.compiler.JspParseEventListener;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.Mangler;
import org.apache.jasper.compiler.Parser;
import org.apache.jasper.compiler.ServletWriter;

public abstract class Compiler {
    protected JavaCompiler javac;
    protected Mangler mangler;
    protected JspEngineContext ctxt;

    protected Compiler(JspEngineContext ctxt) {
        this.ctxt = ctxt;
    }

    public boolean compile() throws FileNotFoundException, JasperException, Exception {
        if (!this.isOutDated()) {
            return false;
        }
        String pkgName = this.mangler.getPackageName();
        String className = this.mangler.getClassName();
        String javaFileName = this.mangler.getJavaFileName();
        String classFileName = this.mangler.getClassFileName();
        Constants.message("jsp.message.package_name_is", new Object[]{pkgName}, 2);
        Constants.message("jsp.message.class_name_is", new Object[]{className}, 2);
        Constants.message("jsp.message.java_file_name_is", new Object[]{javaFileName}, 2);
        Constants.message("jsp.message.class_file_name_is", new Object[]{classFileName}, 2);
        JspReader reader = JspReader.createJspReader(this.ctxt.getJspFile(), this.ctxt.getServletContext());
        ServletWriter writer = new ServletWriter(new PrintWriter(new EscapeUnicodeWriter(new FileOutputStream(javaFileName))));
        this.ctxt.setReader(reader);
        this.ctxt.setWriter(writer);
        this.ctxt.setServletClassName(className);
        this.ctxt.setServletPackageName(pkgName);
        this.ctxt.setServletJavaFileName(javaFileName);
        JspParseEventListener listener = new JspParseEventListener(this.ctxt);
        Parser p2 = new Parser(reader, listener);
        listener.beginPageProcessing();
        p2.parse();
        listener.endPageProcessing();
        writer.close();
        String encoding = this.ctxt.getContentType();
        String classpath = this.ctxt.getClassPath();
        if (encoding != null) {
            int semi = encoding.indexOf(";");
            if (semi == -1) {
                encoding = null;
            } else {
                String afterSemi = encoding.substring(semi + 1);
                int charsetLocation = afterSemi.indexOf("charset=");
                if (charsetLocation == -1) {
                    encoding = null;
                } else {
                    String afterCharset = afterSemi.substring(charsetLocation + 8);
                    encoding = afterCharset.trim();
                }
            }
        }
        String sep = System.getProperty("path.separator");
        String[] argv = new String[]{"-classpath", String.valueOf(System.getProperty("java.class.path")) + sep + classpath + sep + this.ctxt.getOutputDir(), "-d", this.ctxt.getOutputDir(), javaFileName};
        if (encoding != null && !encoding.equals("")) {
            String[] args = new String[argv.length + 2];
            args[0] = "-encoding";
            args[1] = encoding;
            int i2 = 0;
            while (i2 < argv.length) {
                args[i2 + 2] = argv[i2];
                ++i2;
            }
            argv = args;
        }
        StringBuffer b10 = new StringBuffer();
        int i3 = 0;
        while (i3 < argv.length) {
            b10.append(argv[i3]);
            b10.append(" ");
            ++i3;
        }
        Constants.message("jsp.message.compiling_with", new Object[]{b10.toString()}, 2);
        ByteArrayOutputStream out = new ByteArrayOutputStream(256);
        this.javac.setOut(out);
        boolean status = this.javac.compile(argv);
        if (!this.ctxt.keepGenerated()) {
            File javaFile = new File(javaFileName);
            javaFile.delete();
        }
        if (!status) {
            String msg = out.toString();
            throw new JasperException(String.valueOf(Constants.getString("jsp.error.unable.compile")) + msg);
        }
        String classFile = String.valueOf(this.ctxt.getOutputDir()) + File.separatorChar;
        if (pkgName != null && !pkgName.equals("")) {
            classFile = String.valueOf(classFile) + pkgName.replace('.', File.separatorChar) + File.separatorChar;
        }
        if (!(classFile = String.valueOf(classFile) + className + ".class").equals(classFileName)) {
            File classFileObject = new File(classFile);
            File myClassFileObject = new File(classFileName);
            if (myClassFileObject.exists()) {
                myClassFileObject.delete();
            }
            if (!classFileObject.renameTo(myClassFileObject)) {
                throw new JasperException(Constants.getString("jsp.error.unable.rename", new Object[]{classFileObject, myClassFileObject}));
            }
        }
        return true;
    }

    protected abstract boolean isOutDated();

    public void setJavaCompiler(JavaCompiler javac) {
        this.javac = javac;
    }

    public void setMangler(Mangler mangler) {
        this.mangler = mangler;
    }
}

