/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.jasper.Constants;

class ConstantPool {
    int type = -1;
    String name;
    ConstantPool arg1 = null;
    ConstantPool arg2 = null;
    short index1 = (short)-1;
    short index2 = (short)-1;
    String strValue;
    int intValue;
    long longValue;
    float floatValue;
    double doubleValue;
    public static final int CLASS = 7;
    public static final int FIELDREF = 9;
    public static final int METHODREF = 10;
    public static final int STRING = 8;
    public static final int INTEGER = 3;
    public static final int FLOAT = 4;
    public static final int LONG = 5;
    public static final int DOUBLE = 6;
    public static final int INTERFACE = 11;
    public static final int NAMEANDTYPE = 12;
    public static final int ASCIZ = 1;
    public static final int UNICODE = 2;

    public boolean read(DataInputStream din) throws IOException {
        this.type = din.readByte();
        switch (this.type) {
            case 7: {
                this.name = "Class";
                this.index1 = din.readShort();
                this.index2 = (short)-1;
                break;
            }
            case 9: {
                this.name = "Field Reference";
                this.index1 = din.readShort();
                this.index2 = din.readShort();
                break;
            }
            case 10: {
                this.name = "Method Reference";
                this.index1 = din.readShort();
                this.index2 = din.readShort();
                break;
            }
            case 11: {
                this.name = "Interface Method Reference";
                this.index1 = din.readShort();
                this.index2 = din.readShort();
                break;
            }
            case 12: {
                this.name = "Name and Type";
                this.index1 = din.readShort();
                this.index2 = din.readShort();
                break;
            }
            case 8: {
                this.name = "String";
                this.index1 = din.readShort();
                this.index2 = (short)-1;
                break;
            }
            case 3: {
                this.name = "Integer";
                this.intValue = din.readInt();
                break;
            }
            case 4: {
                this.name = "Float";
                this.floatValue = din.readFloat();
                break;
            }
            case 5: {
                this.name = "Long";
                this.longValue = din.readLong();
                break;
            }
            case 6: {
                this.name = "Double";
                this.doubleValue = din.readDouble();
                break;
            }
            case 1: 
            case 2: {
                this.name = this.type == 1 ? "ASCIZ" : "UNICODE";
                StringBuffer xxBuf = new StringBuffer();
                int len = din.readShort();
                while (len > 0) {
                    char c10 = (char)din.readByte();
                    xxBuf.append(c10);
                    --len;
                }
                this.strValue = xxBuf.toString();
                break;
            }
            default: {
                System.err.println(Constants.getString("jsp.warning.bad.type"));
            }
        }
        return true;
    }
}

