/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.jasper.Constants;

public class EscapeUnicodeWriter
extends Writer {
    private OutputStream out = null;
    private byte[] bytes = new byte[6];

    public EscapeUnicodeWriter(OutputStream out) {
        this.out = out;
    }

    public void close() throws IOException {
        if (this.out == null) {
            return;
        }
        this.out.close();
        this.out = null;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void write(char[] buf, int off, int len) throws IOException {
        if (this.out == null) {
            throw new IOException(Constants.getString("jsp.error.stream.closed"));
        }
        int ci2 = off;
        int end = off + len;
        while (--len >= 0) {
            int ch2;
            if (((ch2 = buf[off++] & 0xFF) < 32 || ch2 > 126) && ch2 != 10 && ch2 != 13 && ch2 != 9) {
                this.bytes[0] = 92;
                this.bytes[1] = 117;
                this.bytes[2] = (byte)Character.forDigit((ch2 & 0xF000) >> 12, 16);
                this.bytes[3] = (byte)Character.forDigit((ch2 & 0xF00) >> 8, 16);
                this.bytes[4] = (byte)Character.forDigit((ch2 & 0xF0) >> 4, 16);
                this.bytes[5] = (byte)Character.forDigit(ch2 & 0xF, 16);
                this.out.write(this.bytes);
                continue;
            }
            this.out.write((byte)ch2);
        }
    }
}

