/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Hashtable;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.BeanRepository;
import org.apache.jasper.compiler.GeneratorBase;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ServiceMethodPhase;
import org.apache.jasper.compiler.ServletWriter;

public class GetPropertyGenerator
extends GeneratorBase
implements ServiceMethodPhase {
    Hashtable attrs;
    BeanRepository beanInfo;

    public GetPropertyGenerator(Mark start, Mark stop, Hashtable attrs, BeanRepository beanInfo) {
        this.attrs = attrs;
        this.beanInfo = beanInfo;
    }

    public void generate(ServletWriter writer, Class phase) throws JasperException {
        String name = this.getAttribute("name");
        String property = this.getAttribute("property");
        Method method = null;
        if (name.equals("request")) {
            String methodName = "request.get" + property.substring(0, 1).toUpperCase() + property.substring(1);
            writer.println("out.print (JspRuntimeLibrary.toString(" + methodName + "()));");
        } else {
            block8: {
                if (!this.beanInfo.checkVariable(name)) {
                    String m2 = Constants.getString("jsp.error.getproperty.beanNotFound", new Object[]{name});
                    throw new JasperException(m2);
                }
                Class cls = this.beanInfo.getBeanType(name);
                try {
                    BeanInfo info = Introspector.getBeanInfo(cls);
                    if (info == null) break block8;
                    PropertyDescriptor[] pd = info.getPropertyDescriptors();
                    int i2 = 0;
                    while (i2 < pd.length) {
                        if (pd[i2].getName().equalsIgnoreCase(property)) {
                            method = pd[i2].getReadMethod();
                            break;
                        }
                        ++i2;
                    }
                }
                catch (IntrospectionException ex2) {
                    throw new JasperException(Constants.getString("jsp.error.beans.introspection", new Object[]{name, property}), ex2);
                }
            }
            if (method == null) {
                throw new JasperException(Constants.getString("jsp.error.beans.noMethod", new Object[]{name, property}));
            }
            writer.println("out.print(JspRuntimeLibrary.toString(" + name + "." + method.getName() + "()));");
        }
    }

    public String getAttribute(String name) {
        return this.attrs != null ? (String)this.attrs.get(name) : null;
    }
}

