/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.jsp.tagext.TagInfo;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspEngineContext;
import org.apache.jasper.compiler.BaseJspListener;
import org.apache.jasper.compiler.BeanEndGenerator;
import org.apache.jasper.compiler.BeanGenerator;
import org.apache.jasper.compiler.BeanRepository;
import org.apache.jasper.compiler.CharDataGenerator;
import org.apache.jasper.compiler.ClassDeclarationPhase;
import org.apache.jasper.compiler.DeclarationGenerator;
import org.apache.jasper.compiler.ExpressionGenerator;
import org.apache.jasper.compiler.FileDeclarationPhase;
import org.apache.jasper.compiler.ForwardGenerator;
import org.apache.jasper.compiler.Generator;
import org.apache.jasper.compiler.GeneratorBase;
import org.apache.jasper.compiler.GetPropertyGenerator;
import org.apache.jasper.compiler.IncludeGenerator;
import org.apache.jasper.compiler.InfoGenerator;
import org.apache.jasper.compiler.InitMethodPhase;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.PluginGenerator;
import org.apache.jasper.compiler.ScriptletGenerator;
import org.apache.jasper.compiler.ServiceMethodPhase;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.compiler.SetPropertyGenerator;
import org.apache.jasper.compiler.StaticInitializerPhase;
import org.apache.jasper.compiler.StoredCharDataGenerator;
import org.apache.jasper.compiler.TagBeginGenerator;
import org.apache.jasper.compiler.TagEndGenerator;
import org.apache.jasper.compiler.TagLibraries;
import org.apache.jasper.compiler.TagLibraryInfoImpl;

public class JspParseEventListener
extends BaseJspListener {
    JspEngineContext ctxt;
    String jspServletBase = "HttpJspBase";
    String serviceMethodName = "_jspService";
    String servletContentType = "text/html";
    String extendsClass = "";
    Vector interfaces = new Vector();
    Vector imports = new Vector();
    String error = "";
    boolean genSessionVariable = true;
    boolean singleThreaded = false;
    boolean autoFlush = true;
    Vector generators = new Vector();
    BeanRepository beanInfo;
    int bufferSize = 8192;
    boolean languageDir = false;
    boolean extendsDir = false;
    boolean sessionDir = false;
    boolean bufferDir = false;
    boolean threadsafeDir = false;
    boolean errorpageDir = false;
    boolean iserrorpageDir = false;
    boolean infoDir = false;
    boolean autoFlushDir = false;
    boolean contentTypeDir = false;
    int stringId = 0;
    Vector vector = new Vector();
    String dataFile;
    TagLibraries libraries;
    static final String languageStr = "language";
    static final String extendsStr = "extends";
    static final String importStr = "import";
    static final String sessionStr = "session";
    static final String bufferStr = "buffer";
    static final String autoFlushStr = "autoFlush";
    static final String isThreadSafeStr = "isThreadSafe";
    static final String infoStr = "info";
    static final String errorPageStr = "errorPage";
    static final String isErrorPageStr = "isErrorPage";
    static final String contentTypeStr = "contentType";
    PageDirectiveHandlerInfo[] pdhis = new PageDirectiveHandlerInfo[]{new PageDirectiveHandlerInfo("language", new LanguageHandler()), new PageDirectiveHandlerInfo("extends", new ExtendsHandler()), new PageDirectiveHandlerInfo("import", new ImportsHandler()), new PageDirectiveHandlerInfo("session", new SessionHandler()), new PageDirectiveHandlerInfo("buffer", new BufferHandler()), new PageDirectiveHandlerInfo("autoFlush", new AutoFlushHandler()), new PageDirectiveHandlerInfo("isThreadSafe", new IsThreadSafeHandler()), new PageDirectiveHandlerInfo("info", new InfoHandler()), new PageDirectiveHandlerInfo("isErrorPage", new IsErrorPageHandler()), new PageDirectiveHandlerInfo("contentType", new ContentTypeHandler()), new PageDirectiveHandlerInfo("errorPage", new ErrorPageHandler())};
    static /* synthetic */ Class class$org$apache$jasper$compiler$ServiceMethodPhase;
    static /* synthetic */ Class class$org$apache$jasper$compiler$FileDeclarationPhase;
    static /* synthetic */ Class class$org$apache$jasper$compiler$ClassDeclarationPhase;
    static /* synthetic */ Class class$org$apache$jasper$compiler$StaticInitializerPhase;
    static /* synthetic */ Class class$org$apache$jasper$compiler$InitMethodPhase;

    JspParseEventListener(JspEngineContext ctxt) {
        super(ctxt.getReader(), ctxt.getWriter());
        this.ctxt = ctxt;
        this.beanInfo = new BeanRepository(ctxt.getClassLoader());
        this.libraries = new TagLibraries(ctxt.getClassLoader());
        if (ctxt.getOptions().largeFile()) {
            this.dataFile = String.valueOf(ctxt.getOutputDir()) + File.separatorChar + ctxt.getServletPackageName() + "_" + ctxt.getServletClassName() + ".dat";
        }
    }

    final void addGenerator(Generator gen) throws JasperException {
        gen.init(this.ctxt);
        this.generators.addElement(gen);
    }

    public void beginPageProcessing() throws JasperException {
        int i2 = 0;
        while (i2 < Constants.STANDARD_IMPORTS.length) {
            this.imports.addElement(Constants.STANDARD_IMPORTS[i2]);
            ++i2;
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void endPageProcessing() throws JasperException {
        this.generateHeader();
        this.writer.println();
        this.generateAll(class$org$apache$jasper$compiler$ServiceMethodPhase != null ? class$org$apache$jasper$compiler$ServiceMethodPhase : (class$org$apache$jasper$compiler$ServiceMethodPhase = JspParseEventListener.class$("org.apache.jasper.compiler.ServiceMethodPhase")));
        this.writer.println();
        this.generateFooter();
        if (this.ctxt.getOptions().largeFile()) {
            try {
                ObjectOutputStream o2 = new ObjectOutputStream(new FileOutputStream(this.dataFile));
                char[][] tempCharArray = new char[this.vector.size()][];
                this.vector.copyInto((Object[])tempCharArray);
                o2.writeObject(tempCharArray);
                o2.close();
                this.writer.close();
            }
            catch (IOException ex2) {
                throw new JasperException(Constants.getString("jsp.error.data.file.write"), ex2);
            }
        }
        this.ctxt.setContentType(this.servletContentType);
    }

    private void generateAll(Class phase) throws JasperException {
        int i2 = 0;
        while (i2 < this.generators.size()) {
            Generator gen = (Generator)this.generators.elementAt(i2);
            if (phase.isInstance(gen)) {
                gen.generate(this.writer, phase);
            }
            ++i2;
        }
    }

    private void generateFooter() throws JasperException {
        this.writer.popIndent();
        this.writer.println("} catch (Exception ex) {");
        this.writer.pushIndent();
        this.writer.println("if (out.getBufferSize() != 0)");
        this.writer.pushIndent();
        this.writer.println("out.clear();");
        this.writer.popIndent();
        this.writer.println("pageContext.handlePageException(ex);");
        this.writer.popIndent();
        this.writer.println("} finally {");
        this.writer.pushIndent();
        this.writer.println("out.flush();");
        this.writer.println("_jspxFactory.releasePageContext(pageContext);");
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.popIndent();
        this.writer.println("}");
    }

    private void generateHeader() throws JasperException {
        String servletPackageName = this.ctxt.getServletPackageName();
        String servletClassName = this.ctxt.getServletClassName();
        if (!"".equals(servletPackageName) && servletPackageName != null) {
            this.writer.println("package " + servletPackageName + ";");
            this.writer.println();
        }
        Enumeration e10 = this.imports.elements();
        while (e10.hasMoreElements()) {
            this.writer.println("import " + (String)e10.nextElement() + ";");
        }
        this.writer.println();
        this.generateAll(class$org$apache$jasper$compiler$FileDeclarationPhase != null ? class$org$apache$jasper$compiler$FileDeclarationPhase : (class$org$apache$jasper$compiler$FileDeclarationPhase = JspParseEventListener.class$("org.apache.jasper.compiler.FileDeclarationPhase")));
        this.writer.println();
        this.writer.print("public class " + servletClassName + " extends ");
        this.writer.print(this.extendsClass.equals("") ? this.jspServletBase : this.extendsClass);
        if (this.singleThreaded) {
            this.interfaces.addElement("SingleThreadModel");
        }
        if (this.interfaces.size() != 0) {
            this.writer.println();
            this.writer.println("     implements ");
            int i2 = 0;
            while (i2 < this.interfaces.size() - 1) {
                this.writer.println(" " + this.interfaces.elementAt(i2) + ",");
                ++i2;
            }
            this.writer.println(" " + this.interfaces.elementAt(this.interfaces.size() - 1));
        }
        this.writer.println(" {");
        this.writer.pushIndent();
        this.writer.println();
        this.generateAll(class$org$apache$jasper$compiler$ClassDeclarationPhase != null ? class$org$apache$jasper$compiler$ClassDeclarationPhase : (class$org$apache$jasper$compiler$ClassDeclarationPhase = JspParseEventListener.class$("org.apache.jasper.compiler.ClassDeclarationPhase")));
        this.writer.println();
        this.writer.println("static {");
        this.writer.pushIndent();
        this.generateAll(class$org$apache$jasper$compiler$StaticInitializerPhase != null ? class$org$apache$jasper$compiler$StaticInitializerPhase : (class$org$apache$jasper$compiler$StaticInitializerPhase = JspParseEventListener.class$("org.apache.jasper.compiler.StaticInitializerPhase")));
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.println("public " + servletClassName + "( ) {");
        this.writer.println("}");
        this.writer.println();
        this.writer.println("private static boolean _jspx_inited = false;");
        this.writer.println();
        this.writer.println("public final void _jspx_init() throws JasperException {");
        this.writer.pushIndent();
        this.generateAll(class$org$apache$jasper$compiler$InitMethodPhase != null ? class$org$apache$jasper$compiler$InitMethodPhase : (class$org$apache$jasper$compiler$InitMethodPhase = JspParseEventListener.class$("org.apache.jasper.compiler.InitMethodPhase")));
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.println();
        this.writer.println("public void " + this.serviceMethodName + "(" + "HttpServletRequest request, " + "HttpServletResponse  response)");
        this.writer.println("    throws IOException, ServletException {");
        this.writer.pushIndent();
        this.writer.println();
        this.writer.println("JspFactory _jspxFactory = null;");
        this.writer.println("PageContext pageContext = null;");
        if (this.genSessionVariable) {
            this.writer.println("HttpSession session = null;");
        }
        if (this.ctxt.isErrorPage()) {
            this.writer.println("Throwable exception = (Throwable) request.getAttribute(\"javax.servlet.jsp.jspException\");");
        }
        this.writer.println("ServletContext application = null;");
        this.writer.println("ServletConfig config = null;");
        this.writer.println("JspWriter out = null;");
        this.writer.println("Object page = this;");
        this.writer.println("String  _value = null;");
        this.writer.println("try {");
        this.writer.pushIndent();
        this.writer.println();
        this.writer.println("if (_jspx_inited == false) {");
        this.writer.pushIndent();
        this.writer.println("_jspx_init();");
        this.writer.println("_jspx_inited = true;");
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.println("_jspxFactory = JspFactory.getDefaultFactory();");
        this.writer.println("response.setContentType(" + this.writer.quoteString(this.servletContentType) + ");");
        this.writer.println("pageContext = _jspxFactory.getPageContext(this, request, response,\n\t\t\t" + this.writer.quoteString(this.error) + ", " + this.genSessionVariable + ", " + this.bufferSize + ", " + this.autoFlush + ");");
        this.writer.println();
        this.writer.println("application = pageContext.getServletContext();");
        this.writer.println("config = pageContext.getServletConfig();");
        if (this.genSessionVariable) {
            this.writer.println("session = pageContext.getSession();");
        }
        this.writer.println("out = pageContext.getOut();");
    }

    public TagLibraries getTagLibraries() {
        return this.libraries;
    }

    public void handleBean(Mark start, Mark stop, Hashtable attrs) throws JasperException {
        GeneratorWrapper gen = new GeneratorWrapper(new BeanGenerator(start, attrs, this.beanInfo, this.genSessionVariable), start, stop);
        this.addGenerator(gen);
    }

    public void handleBeanEnd(Mark start, Mark stop, Hashtable attrs) throws JasperException {
        GeneratorWrapper gen = new GeneratorWrapper(new BeanEndGenerator(), start, stop);
        this.addGenerator(gen);
    }

    public void handleCharData(char[] chars) throws JasperException {
        GeneratorBase cdg = this.ctxt.getOptions().largeFile() ? new StoredCharDataGenerator(this.vector, this.dataFile, this.stringId++, chars) : new CharDataGenerator(chars);
        GeneratorWrapper gen = new GeneratorWrapper(cdg, null, null);
        this.addGenerator(gen);
    }

    public void handleComment(Mark start, Mark stop) throws JasperException {
        Constants.message("jsp.message.htmlcomment", new Object[]{this.reader.getChars(start, stop)}, 3);
    }

    public void handleDeclaration(Mark start, Mark stop) throws JasperException {
        GeneratorWrapper gen = new GeneratorWrapper(new DeclarationGenerator(this.reader.getChars(start, stop)), start, stop);
        this.addGenerator(gen);
    }

    public void handleDirective(String directive, Mark start, Mark stop, Hashtable attrs) throws JasperException {
        Constants.message("jsp.message.handling_directive", new Object[]{directive, attrs}, 3);
        if (directive.equals("page")) {
            Enumeration e10 = attrs.keys();
            while (e10.hasMoreElements()) {
                String attr = (String)e10.nextElement();
                int i2 = 0;
                while (i2 < this.pdhis.length) {
                    PageDirectiveHandlerInfo pdhi = this.pdhis[i2];
                    if (attr.equals(pdhi.attribute)) {
                        String value = (String)attrs.get(pdhi.attribute);
                        pdhi.handler.handlePageDirectiveAttribute(this, value, start, stop);
                    }
                    ++i2;
                }
            }
        }
        if (this.bufferSize == 0 && !this.autoFlush) {
            throw new JasperException(Constants.getString("jsp.error.page.bad_b_and_a_combo"));
        }
        if (directive.equals("taglib")) {
            String uri = (String)attrs.get("uri");
            String prefix = (String)attrs.get("prefix");
            try {
                TagLibraryInfoImpl tl = new TagLibraryInfoImpl(this.ctxt, prefix, uri);
                this.libraries.addTagLibrary(prefix, tl);
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
                Object[] args = new Object[]{uri, ex2.getMessage()};
                throw new JasperException(Constants.getString("jsp.error.badtaglib", args));
            }
        }
        if (directive.equals("include")) {
            String file = (String)attrs.get("file");
            String encoding = (String)attrs.get("encoding");
            if (file == null) {
                throw new JasperException(Constants.getString("jsp.error.include.missing.file"));
            }
            try {
                this.reader.pushFile(file, encoding);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new JasperException(Constants.getString("jsp.error.include.bad.file"));
            }
        }
    }

    public void handleExpression(Mark start, Mark stop) throws JasperException {
        GeneratorWrapper gen = new GeneratorWrapper(new ExpressionGenerator(this.reader.getChars(start, stop)), start, stop);
        this.addGenerator(gen);
    }

    public void handleForward(Mark start, Mark stop, Hashtable attrs, Hashtable param) throws JasperException {
        GeneratorWrapper gen = new GeneratorWrapper(new ForwardGenerator(attrs, param), start, stop);
        this.addGenerator(gen);
    }

    public void handleGetProperty(Mark start, Mark stop, Hashtable attrs) throws JasperException {
        GeneratorWrapper gen = new GeneratorWrapper(new GetPropertyGenerator(start, stop, attrs, this.beanInfo), start, stop);
        this.addGenerator(gen);
    }

    public void handleInclude(Mark start, Mark stop, Hashtable attrs, Hashtable param) throws JasperException {
        GeneratorWrapper gen = new GeneratorWrapper(new IncludeGenerator(attrs, param), start, stop);
        this.addGenerator(gen);
    }

    public void handlePlugin(Mark start, Mark stop, Hashtable attrs, Hashtable param, String fallback) throws JasperException {
        Constants.message("jsp.message.handling_plugin", new Object[]{attrs}, 3);
        GeneratorWrapper gen = new GeneratorWrapper(new PluginGenerator(attrs, param, fallback), start, stop);
        this.addGenerator(gen);
    }

    public void handleScriptlet(Mark start, Mark stop) throws JasperException {
        GeneratorWrapper gen = new GeneratorWrapper(new ScriptletGenerator(this.reader.getChars(start, stop)), start, stop);
        this.addGenerator(gen);
    }

    public void handleSetProperty(Mark start, Mark stop, Hashtable attrs) throws JasperException {
        GeneratorWrapper gen = new GeneratorWrapper(new SetPropertyGenerator(start, stop, attrs, this.beanInfo), start, stop);
        this.addGenerator(gen);
    }

    public void handleTagBegin(Mark start, Hashtable attrs, String prefix, String shortTagName, TagLibraryInfoImpl tli, TagInfo ti) throws JasperException {
        GeneratorWrapper gen = new GeneratorWrapper(new TagBeginGenerator(prefix, shortTagName, attrs, tli, ti), null, null);
        this.addGenerator(gen);
    }

    public void handleTagEnd(Mark start, Mark stop, String prefix, String shortTagName, Hashtable attrs, TagLibraryInfoImpl tli, TagInfo ti) throws JasperException {
        GeneratorWrapper gen = new GeneratorWrapper(new TagEndGenerator(prefix, shortTagName, attrs, tli, ti), null, null);
        this.addGenerator(gen);
    }

    static interface PageDirectiveHandler {
        public void handlePageDirectiveAttribute(JspParseEventListener var1, String var2, Mark var3, Mark var4) throws JasperException;
    }

    static final class PageDirectiveHandlerInfo {
        String attribute;
        PageDirectiveHandler handler;

        PageDirectiveHandlerInfo(String attribute, PageDirectiveHandler handler) {
            this.attribute = attribute;
            this.handler = handler;
        }
    }

    static final class ContentTypeHandler
    implements PageDirectiveHandler {
        ContentTypeHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String contentType, Mark start, Mark stop) throws JasperException {
            if (listener.contentTypeDir) {
                throw new JasperException(Constants.getString("jsp.error.page.multiple.contenttypes"));
            }
            listener.contentTypeDir = true;
            if (contentType == null) {
                throw new JasperException(Constants.getString("jsp.error.page.invalid.contenttype"));
            }
            listener.servletContentType = contentType;
        }
    }

    static final class SessionHandler
    implements PageDirectiveHandler {
        SessionHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String session, Mark start, Mark stop) throws JasperException {
            if (listener.sessionDir) {
                throw new JasperException(Constants.getString("jsp.error.page.multiple.session"));
            }
            listener.sessionDir = true;
            if (session == null) {
                throw new JasperException(Constants.getString("jsp.error.page.invalid.session"));
            }
            if (session.equalsIgnoreCase("true")) {
                listener.genSessionVariable = true;
            } else if (session.equalsIgnoreCase("false")) {
                listener.genSessionVariable = false;
            } else {
                throw new JasperException("Invalid value for session");
            }
        }
    }

    static final class BufferHandler
    implements PageDirectiveHandler {
        BufferHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String buffer, Mark start, Mark stop) throws JasperException {
            if (listener.bufferDir) {
                throw new JasperException(Constants.getString("jsp.error.page.multiple.buffer"));
            }
            listener.bufferDir = true;
            if (buffer != null) {
                if (buffer.equalsIgnoreCase("none")) {
                    listener.bufferSize = 0;
                } else {
                    Integer i2 = null;
                    try {
                        int ind = buffer.indexOf("k");
                        String num = ind == -1 ? buffer : buffer.substring(0, ind);
                        i2 = new Integer(num);
                    }
                    catch (NumberFormatException n2) {
                        throw new JasperException(Constants.getString("jsp.error.page.invalid.buffer"), n2);
                    }
                    listener.bufferSize = i2 * 1024;
                }
            } else {
                throw new JasperException(Constants.getString("jsp.error.page.invalid.buffer"));
            }
        }
    }

    static final class AutoFlushHandler
    implements PageDirectiveHandler {
        AutoFlushHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String autoflush, Mark start, Mark stop) throws JasperException {
            if (listener.autoFlushDir) {
                throw new JasperException(Constants.getString("jsp.error.page.multiple.autoflush"));
            }
            listener.autoFlushDir = true;
            if (autoflush == null) {
                throw new JasperException(Constants.getString("jsp.error.page.invalid.autoflush"));
            }
            if (autoflush.equalsIgnoreCase("true")) {
                listener.autoFlush = true;
            } else if (autoflush.equalsIgnoreCase("false")) {
                listener.autoFlush = false;
            } else {
                throw new JasperException(Constants.getString("jsp.error.page.invalid.autoflush"));
            }
        }
    }

    static final class IsThreadSafeHandler
    implements PageDirectiveHandler {
        IsThreadSafeHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String threadsafe, Mark start, Mark stop) throws JasperException {
            if (listener.threadsafeDir) {
                throw new JasperException(Constants.getString("jsp.error.page.multiple.threadsafe"));
            }
            listener.threadsafeDir = true;
            if (threadsafe == null) {
                throw new JasperException(Constants.getString("jsp.error.page.invalid.threadsafe"));
            }
            if (threadsafe.equalsIgnoreCase("true")) {
                listener.singleThreaded = false;
            } else if (threadsafe.equalsIgnoreCase("false")) {
                listener.singleThreaded = true;
            } else {
                throw new JasperException(Constants.getString("jsp.error.page.invalid.threadsafe"));
            }
        }
    }

    static final class InfoHandler
    implements PageDirectiveHandler {
        InfoHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String info, Mark start, Mark stop) throws JasperException {
            if (listener.infoDir) {
                throw new JasperException(Constants.getString("jsp.error.page.multiple.info"));
            }
            listener.infoDir = true;
            if (info == null) {
                throw new JasperException(Constants.getString("jsp.error.page.invalid.info"));
            }
            JspParseEventListener jspParseEventListener = listener;
            jspParseEventListener.getClass();
            GeneratorWrapper gen = jspParseEventListener.new GeneratorWrapper(new InfoGenerator(info), start, stop);
            listener.addGenerator(gen);
        }
    }

    static final class IsErrorPageHandler
    implements PageDirectiveHandler {
        IsErrorPageHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String iserrorpage, Mark start, Mark stop) throws JasperException {
            if (listener.iserrorpageDir) {
                throw new JasperException(Constants.getString("jsp.error.page.multiple.iserrorpage"));
            }
            listener.iserrorpageDir = true;
            if (iserrorpage == null) {
                throw new JasperException(Constants.getString("jsp.error.page.invalid.iserrorpage"));
            }
            if (iserrorpage.equalsIgnoreCase("true")) {
                listener.ctxt.setErrorPage(true);
            } else if (iserrorpage.equalsIgnoreCase("false")) {
                listener.ctxt.setErrorPage(false);
            } else {
                throw new JasperException(Constants.getString("jsp.error.page.invalid.iserrorpage"));
            }
        }
    }

    static final class ErrorPageHandler
    implements PageDirectiveHandler {
        ErrorPageHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String errorpage, Mark start, Mark stop) throws JasperException {
            if (listener.errorpageDir) {
                throw new JasperException(Constants.getString("jsp.error.page.multiple.errorpage"));
            }
            listener.errorpageDir = true;
            if (errorpage != null) {
                listener.error = errorpage;
            }
        }
    }

    static final class LanguageHandler
    implements PageDirectiveHandler {
        LanguageHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String language, Mark start, Mark stop) throws JasperException {
            if (listener.languageDir) {
                throw new JasperException(Constants.getString("jsp.error.page.multiple.language"));
            }
            listener.languageDir = true;
            if (language != null && !language.equalsIgnoreCase("java")) {
                throw new JasperException(String.valueOf(Constants.getString("jsp.error.page.nomapping.language")) + language);
            }
        }
    }

    static final class ImportsHandler
    implements PageDirectiveHandler {
        ImportsHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String importPkgs, Mark start, Mark stop) throws JasperException {
            if (importPkgs != null) {
                StringTokenizer tokenizer = new StringTokenizer(importPkgs, ",");
                while (tokenizer.hasMoreTokens()) {
                    listener.imports.addElement(tokenizer.nextToken());
                }
            }
        }
    }

    static final class ExtendsHandler
    implements PageDirectiveHandler {
        ExtendsHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String extendsClzz, Mark start, Mark stop) throws JasperException {
            if (listener.extendsDir) {
                throw new JasperException(Constants.getString("jsp.error.page.multiple.extends"));
            }
            listener.extendsDir = true;
            if (extendsClzz != null) {
                listener.extendsClass = extendsClzz;
                if (extendsClzz.indexOf(".") == -1) {
                    listener.imports.addElement(extendsClzz);
                }
            }
        }
    }

    class GeneratorWrapper
    implements Generator,
    ClassDeclarationPhase,
    FileDeclarationPhase,
    ServiceMethodPhase,
    InitMethodPhase,
    StaticInitializerPhase {
        Generator generator;
        Mark start;
        Mark stop;

        GeneratorWrapper(Generator generator, Mark start, Mark stop) {
            this.generator = generator;
            this.start = start;
            this.stop = stop;
        }

        public void generate(ServletWriter out, Class phase) throws JasperException {
            if (phase.isInstance(this.generator)) {
                boolean genCoords = this.generator.generateCoordinates(phase);
                if (genCoords) {
                    if (this.start != null && this.stop != null) {
                        if (this.start.fileid == this.stop.fileid) {
                            String fileName = out.quoteString(this.start.getFile());
                            out.println("// begin [file=" + fileName + ";from=" + this.start.toShortString() + ";to=" + this.stop.toShortString() + "]");
                        } else {
                            out.println("// begin [from=" + this.start + ";to=" + this.stop + "]");
                        }
                    } else {
                        out.println("// begin");
                    }
                    out.pushIndent();
                }
                this.generator.generate(out, phase);
                if (genCoords) {
                    out.popIndent();
                    out.println("// end");
                }
            }
        }

        public boolean generateCoordinates(Class phase) {
            return this.generator.generateCoordinates(phase);
        }

        public void init(JspEngineContext ctxt) throws JasperException {
            this.generator.init(ctxt);
        }
    }
}

