/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.servlet.ServletContext;
import org.apache.jasper.Constants;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ParseException;

public class JspReader {
    protected char[] stream = null;
    protected Mark current = null;
    File master = null;
    Vector sourceFiles = new Vector();
    Stack includeStack;
    int size = 0;
    private ServletContext context;

    protected JspReader(String file, ServletContext ctx) throws ParseException, FileNotFoundException {
        this.context = ctx;
        this.pushFile(file, null);
    }

    public void advance(int n2) {
        while (--n2 >= 0) {
            this.nextChar();
        }
    }

    public static JspReader createJspReader(String file, ServletContext ctx) throws ParseException, FileNotFoundException {
        return new JspReader(file, ctx);
    }

    char[] getChars(Mark start, Mark stop) {
        Mark oldstart = this.mark();
        this.reset(start);
        CharArrayWriter caw = new CharArrayWriter();
        while (!stop.equals(this.mark())) {
            caw.write(this.nextChar());
        }
        caw.close();
        this.reset(oldstart);
        return caw.toCharArray();
    }

    public String getFile(int fileid) {
        return (String)this.sourceFiles.elementAt(fileid);
    }

    public boolean hasMoreInput() {
        if (this.current.cursor >= this.stream.length) {
            return this.popFile();
        }
        return true;
    }

    private boolean isDelimiter() {
        if (!this.isSpace()) {
            int ch2 = this.peekChar();
            if (ch2 == 61 || ch2 == 62 || ch2 == 34 || ch2 == 39 || ch2 == 47) {
                return true;
            }
            if (ch2 == 45) {
                Mark mark = this.mark();
                ch2 = this.nextChar();
                if (ch2 == 62 || ch2 == 45 && this.nextChar() == 62) {
                    this.reset(mark);
                    return true;
                }
                this.reset(mark);
                return false;
            }
            return false;
        }
        return true;
    }

    final boolean isSpace() {
        return this.peekChar() <= 32;
    }

    public Mark mark() {
        return new Mark(this.current);
    }

    public boolean matches(String string) {
        Mark mark = this.mark();
        int ch2 = this.nextChar();
        int i2 = 0;
        do {
            if ((char)ch2 != string.charAt(i2++)) {
                this.reset(mark);
                return false;
            }
            ch2 = this.nextChar();
        } while (i2 < string.length());
        this.reset(mark);
        return true;
    }

    public boolean matchesIgnoreCase(String string) {
        Mark mark = this.mark();
        int ch2 = this.nextChar();
        int i2 = 0;
        do {
            if (Character.toLowerCase((char)ch2) != string.charAt(i2++)) {
                this.reset(mark);
                return false;
            }
            ch2 = this.nextChar();
        } while (i2 < string.length());
        this.reset(mark);
        return true;
    }

    public int nextChar() {
        if (!this.hasMoreInput()) {
            return -1;
        }
        char ch2 = this.stream[this.current.cursor];
        ++this.current.cursor;
        if (ch2 == '\n') {
            ++this.current.line;
            this.current.col = 0;
        } else {
            ++this.current.col;
        }
        return ch2;
    }

    private void parseAttributeValue(Hashtable into) throws ParseException {
        this.skipSpaces();
        String name = this.parseToken(false);
        this.skipSpaces();
        if (this.peekChar() != 61) {
            throw new ParseException(this.mark(), Constants.getString("jsp.error.attr.novalue", new Object[]{name}));
        }
        char ch2 = (char)this.nextChar();
        this.skipSpaces();
        String value = this.parseToken(true);
        this.skipSpaces();
        into.put(name, value);
    }

    public void parseParamTag(Hashtable into) throws ParseException {
        if (this.matches("param")) {
            this.advance(6);
            this.parseParams(into);
        }
    }

    private void parseParams(Hashtable into) throws ParseException {
        Hashtable attrs = this.parseTagAttributes();
        String name = (String)attrs.get("name");
        String value = (String)attrs.get("value");
        if (name == null) {
            throw new ParseException(this.mark(), Constants.getString("jsp.error.param.noname"));
        }
        if (value == null) {
            throw new ParseException(this.mark(), Constants.getString("jsp.error.param.novalue"));
        }
        String[] oldval = (String[])into.get(name);
        if (oldval == null) {
            String[] newval = new String[]{value};
            into.put(name, newval);
        } else {
            String[] newval = new String[oldval.length + 1];
            System.arraycopy(oldval, 0, newval, 0, oldval.length);
            newval[oldval.length] = value;
            into.put(name, newval);
        }
    }

    public void parsePluginParamTag(Hashtable into) throws ParseException {
        if (this.matches("<jsp:param")) {
            this.advance(11);
            this.parseParams(into);
        }
    }

    public Hashtable parseTagAttributes() throws ParseException {
        Hashtable values = new Hashtable(11);
        while (true) {
            Object var6_4;
            Mark mark;
            this.skipSpaces();
            int ch2 = this.peekChar();
            if (ch2 == 62) {
                return values;
            }
            if (ch2 == 45) {
                mark = this.mark();
                this.nextChar();
                try {
                    if (this.nextChar() == 45 && this.nextChar() == 62) {
                        Hashtable hashtable = values;
                        var6_4 = null;
                        this.reset(mark);
                        return hashtable;
                    }
                    var6_4 = null;
                    this.reset(mark);
                }
                catch (Throwable throwable) {
                    var6_4 = null;
                    this.reset(mark);
                    throw throwable;
                }
            }
            if (ch2 == 37) {
                mark = this.mark();
                this.nextChar();
                try {
                    if (this.nextChar() == 62) {
                        Hashtable hashtable = values;
                        var6_4 = null;
                        this.reset(mark);
                        return hashtable;
                    }
                    var6_4 = null;
                    this.reset(mark);
                }
                catch (Throwable throwable) {
                    var6_4 = null;
                    this.reset(mark);
                    throw throwable;
                }
            }
            if (ch2 == 47) {
                mark = this.mark();
                this.nextChar();
                try {
                    if (this.nextChar() == 62) {
                        Hashtable hashtable = values;
                        var6_4 = null;
                        this.reset(mark);
                        return hashtable;
                    }
                    var6_4 = null;
                    this.reset(mark);
                }
                catch (Throwable throwable) {
                    var6_4 = null;
                    this.reset(mark);
                    throw throwable;
                }
            }
            if (ch2 == -1) break;
            this.parseAttributeValue(values);
        }
        throw new ParseException(this.mark(), Constants.getString("jsp.error.tag.attr.unterminated"));
    }

    public Hashtable parseTagAttributesBean() throws ParseException {
        Hashtable values = new Hashtable(11);
        while (true) {
            this.skipSpaces();
            int ch2 = this.peekChar();
            if (ch2 == 62) {
                return values;
            }
            if (ch2 == 47) {
                Object var6_4;
                Mark mark = this.mark();
                this.nextChar();
                try {
                    if (this.nextChar() == 62) {
                        Hashtable hashtable = values;
                        var6_4 = null;
                        this.reset(mark);
                        return hashtable;
                    }
                    var6_4 = null;
                    this.reset(mark);
                }
                catch (Throwable throwable) {
                    var6_4 = null;
                    this.reset(mark);
                    throw throwable;
                }
            }
            if (ch2 == -1) break;
            this.parseAttributeValue(values);
        }
        throw new ParseException(this.mark(), Constants.getString("jsp.error.tag.attr.unterminated"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String parseToken(boolean quoted) throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        this.skipSpaces();
        stringBuffer.setLength(0);
        int ch2 = this.peekChar();
        if (quoted) {
            if (ch2 != 34 && ch2 != 39) throw new ParseException(this.mark(), Constants.getString("jsp.error.attr.quoted"));
            int endQuote = ch2 == 34 ? 34 : 39;
            ch2 = this.nextChar();
            ch2 = this.nextChar();
            while (ch2 != -1 && ch2 != endQuote) {
                if (ch2 == 92) {
                    ch2 = this.nextChar();
                }
                stringBuffer.append((char)ch2);
                ch2 = this.nextChar();
            }
            if (ch2 != -1) return stringBuffer.toString();
            throw new ParseException(this.mark(), Constants.getString("jsp.error.quotes.unterminated"));
        }
        if (this.isDelimiter()) return stringBuffer.toString();
        do {
            if ((ch2 = this.nextChar()) == 92 && (this.peekChar() == 34 || this.peekChar() == 39 || this.peekChar() == 62 || this.peekChar() == 37)) {
                ch2 = this.nextChar();
            }
            stringBuffer.append((char)ch2);
        } while (!this.isDelimiter());
        return stringBuffer.toString();
    }

    public int peekChar() {
        return this.stream[this.current.cursor];
    }

    public boolean popFile() {
        if (this.includeStack == null) {
            return false;
        }
        if (this.includeStack.size() == 0) {
            return false;
        }
        --this.size;
        IncludeState state = (IncludeState)this.includeStack.pop();
        state.restore();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void pushFile(File file, String encoding) throws ParseException, FileNotFoundException {
        if (encoding == null) {
            encoding = System.getProperty("file.encoding", "8859_1");
        }
        int fileid = this.registerSourceFile(file.getAbsolutePath());
        Reader reader = null;
        try {
            try {
                if (this.context == null) {
                    reader = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
                } else {
                    InputStream in;
                    String fileName = file.toString();
                    if (File.separatorChar == '\\') {
                        fileName = fileName.replace(File.separatorChar, '/');
                    }
                    if ((in = this.context.getResourceAsStream(fileName)) == null) {
                        throw new FileNotFoundException(fileName);
                    }
                    try {
                        reader = new InputStreamReader(in);
                    }
                    catch (Exception ex2) {
                        throw new FileNotFoundException(String.valueOf(fileName) + ": " + ex2.getMessage());
                    }
                }
                CharArrayWriter caw = new CharArrayWriter();
                char[] buf = new char[1024];
                int i2 = 0;
                while ((i2 = reader.read(buf)) != -1) {
                    caw.write(buf, 0, i2);
                }
                caw.close();
                IncludeState state = new IncludeState();
                this.stream = caw.toCharArray();
                this.current = new Mark(this, fileid);
                if (this.includeStack == null) {
                    this.includeStack = new Stack();
                } else {
                    this.includeStack.push(state);
                }
            }
            catch (FileNotFoundException fnfe) {
                throw fnfe;
            }
            catch (Throwable ex3) {
                System.err.println("STACK TRACE: ");
                ex3.printStackTrace();
                this.popFile();
                throw new ParseException(Constants.getString("jsp.error.file.cannot.read", new Object[]{file}));
            }
            Object var6_12 = null;
            if (reader == null) return;
        }
        catch (Throwable throwable) {
            Object var6_13 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            reader.close();
            return;
        }
        catch (Exception exception) {}
    }

    public void pushFile(String name, String encoding) throws ParseException, FileNotFoundException {
        boolean isAbsolute;
        String parent = this.master == null ? null : this.master.getParent();
        File tmp = new File(name);
        boolean bl2 = isAbsolute = name.startsWith("/") || name.startsWith("\\");
        if (parent == null || isAbsolute) {
            this.pushFile(new File(name), encoding);
        } else {
            this.pushFile(new File(parent, name), encoding);
        }
        if (this.master == null) {
            this.master = new File(name);
        }
    }

    protected int registerSourceFile(String file) {
        this.sourceFiles.addElement(file);
        ++this.size;
        return this.sourceFiles.size() - 1;
    }

    public void reset(Mark mark) {
        this.current = new Mark(mark);
    }

    public int skipSpaces() {
        int i2 = 0;
        while (this.isSpace()) {
            ++i2;
            this.nextChar();
        }
        return i2;
    }

    public Mark skipUntil(String limit) {
        Mark ret = null;
        int limlen = limit.length();
        ret = this.mark();
        int ch2 = this.nextChar();
        while (ch2 != -1) {
            block4: {
                if (ch2 == limit.charAt(0)) {
                    int i2 = 1;
                    while (i2 < limlen) {
                        if (Character.toLowerCase((char)this.nextChar()) == limit.charAt(i2)) {
                            ++i2;
                            continue;
                        }
                        break block4;
                    }
                    return ret;
                }
            }
            ret = this.mark();
            ch2 = this.nextChar();
        }
        return null;
    }

    class IncludeState {
        Mark current;
        char[] stream = null;

        IncludeState() {
            this.current = JspReader.this.current;
            this.stream = JspReader.this.stream;
        }

        void restore() {
            JspReader.this.current = this.current;
            JspReader.this.stream = this.stream;
        }
    }
}

