/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import com.sun.xml.parser.Resolver;
import com.sun.xml.parser.ValidatingParser;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlDocumentBuilder;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JspUtil {
    private static final String OPEN_EXPR = "<%=";
    private static final String CLOSE_EXPR = "%>";
    private static final String OPEN_EXPR_2 = "<jsp:expr";
    private static final String CLOSE_EXPR_2 = "/>";

    public static String getExpr(String expression) {
        String returnString = "";
        if (expression.startsWith(OPEN_EXPR)) {
            returnString = expression.substring(OPEN_EXPR.length());
        } else if (expression.startsWith(OPEN_EXPR_2)) {
            returnString = expression.substring(OPEN_EXPR_2.length());
        }
        int length = returnString.length();
        if (expression.endsWith(CLOSE_EXPR)) {
            returnString = returnString.substring(0, length - CLOSE_EXPR.length());
        } else if (expression.endsWith(CLOSE_EXPR_2)) {
            returnString = returnString.substring(0, length - CLOSE_EXPR_2.length());
        }
        return returnString;
    }

    public static boolean isExpression(String token) {
        return !(!token.startsWith(OPEN_EXPR) && !token.startsWith(OPEN_EXPR_2) || !token.endsWith(CLOSE_EXPR) && !token.endsWith(CLOSE_EXPR_2));
    }

    public static XmlDocument parseXMLDoc(InputStream in, URL dtdURL, String dtdId) throws JasperException {
        XmlDocumentBuilder builder = new XmlDocumentBuilder();
        ValidatingParser parser = new ValidatingParser();
        Resolver resolver = new Resolver();
        resolver.registerCatalogEntry(dtdId, dtdURL.toString());
        try {
            parser.setEntityResolver(resolver);
            builder.setParser(parser);
            builder.setDisableNamespaces(false);
            parser.parse(new InputSource(in));
        }
        catch (SAXException sx) {
            throw new JasperException(Constants.getString("jsp.error.parse.error.in.TLD", new Object[]{sx.getMessage()}));
        }
        catch (IOException io) {
            throw new JasperException(Constants.getString("jsp.error.unable.to.open.TLD", new Object[]{io.getMessage()}));
        }
        XmlDocument tld = builder.getDocument();
        return tld;
    }

    public static char[] removeQuotes(char[] chars) {
        CharArrayWriter caw = new CharArrayWriter();
        int i2 = 0;
        while (i2 < chars.length) {
            if (chars[i2] == '%' && chars[i2 + 1] == '\\' && chars[i2 + 2] == '\\' && chars[i2 + 3] == '>') {
                caw.write(37);
                caw.write(62);
                i2 += 3;
            } else {
                caw.write(chars[i2]);
            }
            ++i2;
        }
        return caw.toCharArray();
    }
}

