/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.jsp.tagext.TagInfo;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.CoreElement;
import org.apache.jasper.compiler.DelegatingListener;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ParseEventListener;
import org.apache.jasper.compiler.ParseException;
import org.apache.jasper.compiler.TagLibraries;
import org.apache.jasper.compiler.TagLibraryInfoImpl;

public class Parser {
    private JspReader reader;
    private ParseEventListener listener;
    CharArrayWriter caw;
    static final Vector coreElements = new Vector();

    static {
        coreElements.addElement(new Directive());
        coreElements.addElement(new Include());
        coreElements.addElement(new Forward());
        coreElements.addElement(new Comment());
        coreElements.addElement(new Declaration());
        coreElements.addElement(new Expression());
        coreElements.addElement(new Scriptlet());
        coreElements.addElement(new Bean());
        coreElements.addElement(new GetProperty());
        coreElements.addElement(new SetProperty());
        coreElements.addElement(new Tag());
        coreElements.addElement(new Plugin());
        coreElements.addElement(new QuoteEscape());
    }

    public Parser(JspReader reader, ParseEventListener lnr) {
        this.reader = reader;
        this.listener = new DelegatingListener(lnr, new Action(){

            public void execute() throws JasperException {
                Parser.this.flushCharData();
            }
        });
        this.caw = new CharArrayWriter();
    }

    public static void checkAttributes(String typeOfTag, Enumeration enumeration, String[] validAttributes) throws JasperException {
        String attribute = null;
        while (enumeration.hasMoreElements()) {
            boolean valid = false;
            attribute = (String)enumeration.nextElement();
            int i2 = 0;
            while (i2 < validAttributes.length) {
                if (attribute.equals(validAttributes[i2])) {
                    valid = true;
                    break;
                }
                ++i2;
            }
            if (valid) continue;
            throw new JasperException(Constants.getString("jsp.error.invalid.attribute", new Object[]{typeOfTag, attribute}));
        }
    }

    void flushCharData() throws JasperException {
        char[] array = this.caw.toCharArray();
        if (array.length != 0) {
            this.listener.handleCharData(this.caw.toCharArray());
        }
        this.caw = new CharArrayWriter();
    }

    public void parse() throws JasperException {
        this.parse(null);
    }

    public void parse(String until) throws JasperException {
        this.parse(until, null);
    }

    public void parse(String until, Class[] accept) throws JasperException {
        while (this.reader.hasMoreInput()) {
            CoreElement c10;
            if (until != null && this.reader.matches(until)) {
                return;
            }
            Enumeration e10 = coreElements.elements();
            if (accept != null) {
                Vector<CoreElement> v2 = new Vector<CoreElement>();
                while (e10.hasMoreElements()) {
                    c10 = (CoreElement)e10.nextElement();
                    int i2 = 0;
                    while (i2 < accept.length) {
                        if (c10.getClass().equals(accept[i2])) {
                            v2.addElement(c10);
                        }
                        ++i2;
                    }
                }
                e10 = v2.elements();
            }
            boolean accepted = false;
            while (e10.hasMoreElements()) {
                c10 = (CoreElement)e10.nextElement();
                Mark m2 = this.reader.mark();
                if (!c10.accept(this.listener, this.reader, this)) continue;
                Constants.message("jsp.message.accepted", new Object[]{c10.getClass().getName(), m2}, 3);
                accepted = true;
                break;
            }
            if (accepted) continue;
            this.caw.write((char)this.reader.nextChar());
        }
        this.flushCharData();
    }

    public static interface Action {
        public void execute() throws JasperException;
    }

    static final class Directive
    implements CoreElement {
        private static final String OPEN_DIRECTIVE = "<%@";
        private static final String CLOSE_DIRECTIVE = "%>";
        private static final String OPEN_DIRECTIVE_2 = "<jsp:directive.";
        private static final String CLOSE_DIRECTIVE_2 = "/>";
        static final String[] directives = new String[]{"page", "include", "taglib"};
        private static final String[] validAttributes = new String[]{"language", "extends", "import", "session", "buffer", "autoFlush", "isThreadSafe", "info", "errorPage", "isErrorPage", "contentType", "file", "uri", "prefix"};

        Directive() {
        }

        public boolean accept(ParseEventListener listener, JspReader reader, Parser parser) throws JasperException {
            String close;
            String open;
            if (reader.matches(OPEN_DIRECTIVE)) {
                open = OPEN_DIRECTIVE;
                close = CLOSE_DIRECTIVE;
            } else if (reader.matches(OPEN_DIRECTIVE_2)) {
                open = OPEN_DIRECTIVE_2;
                close = CLOSE_DIRECTIVE_2;
            } else {
                return false;
            }
            Mark start = reader.mark();
            reader.advance(open.length());
            reader.skipSpaces();
            String match = null;
            int i2 = 0;
            while (i2 < directives.length) {
                if (reader.matches(directives[i2])) {
                    match = directives[i2];
                    break;
                }
                ++i2;
            }
            if (match == null) {
                throw new ParseException(reader.mark(), Constants.getString("jsp.error.invalid.directive"));
            }
            reader.advance(match.length());
            Hashtable attrs = reader.parseTagAttributes();
            Parser.checkAttributes("Directive", attrs.keys(), validAttributes);
            reader.skipSpaces();
            if (!reader.matches(close)) {
                throw new ParseException(reader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{open}));
            }
            reader.advance(close.length());
            Mark stop = reader.mark();
            listener.handleDirective(match, start, stop, attrs);
            return true;
        }
    }

    static final class Include
    implements CoreElement {
        private static final String OPEN_INCLUDE = "<jsp:include";
        private static final String CLOSE_INCLUDE_NO_BODY = "/>";
        private static final String CLOSE_INCLUDE_BODY = ">";
        private static final String CLOSE_INCLUDE = "</jsp:include>";
        private static final String OPEN_INDIVIDUAL_PARAM = "<jsp:param";
        private static final String CLOSE_INDIVIDUAL_PARAM = "/>";
        private static final String[] validAttributes = new String[]{"page", "flush"};

        Include() {
        }

        /*
         * Unable to fully structure code
         */
        public boolean accept(ParseEventListener listener, JspReader reader, Parser parser) throws JasperException {
            block4: {
                block7: {
                    block5: {
                        block6: {
                            if (!reader.matches("<jsp:include")) break block4;
                            param = new Hashtable<K, V>();
                            start = reader.mark();
                            reader.advance("<jsp:include".length());
                            attrs = reader.parseTagAttributes();
                            Parser.checkAttributes("Include", attrs.keys(), Include.validAttributes);
                            reader.skipSpaces();
                            if (reader.matches("/>")) break block5;
                            if (!reader.matches(">")) {
                                throw new ParseException(reader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{"<jsp:include"}));
                            }
                            reader.advance(">".length());
                            reader.skipSpaces();
                            if (reader.matches("</jsp:include>")) break block6;
                            reader.skipSpaces();
                            if (reader.matches("<jsp:param")) ** GOTO lbl28
                            throw new ParseException(reader.mark(), Constants.getString("jsp.error.paramexpected"));
lbl-1000:
                            // 1 sources

                            {
                                reader.parsePluginParamTag(param);
                                reader.skipSpaces();
                                if (!reader.matches("/>")) {
                                    throw new ParseException(reader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{"<jsp:param"}));
                                }
                                reader.advance("/>".length());
                                reader.skipSpaces();
lbl28:
                                // 2 sources

                                ** while (reader.matches((String)"<jsp:param"))
                            }
                        }
                        if (!reader.matches("</jsp:include>")) {
                            throw new ParseException(reader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{"<jsp:include"}));
                        }
                        reader.advance("</jsp:include>".length());
                        break block7;
                    }
                    reader.advance("/>".length());
                }
                stop = reader.mark();
                listener.handleInclude(start, stop, attrs, param);
                return true;
            }
            return false;
        }
    }

    static final class Forward
    implements CoreElement {
        private static final String OPEN_FORWARD = "<jsp:forward";
        private static final String CLOSE_FORWARD_NO_BODY = "/>";
        private static final String CLOSE_FORWARD_BODY = ">";
        private static final String CLOSE_FORWARD = "</jsp:forward>";
        private static final String OPEN_INDIVIDUAL_PARAM = "<jsp:param";
        private static final String CLOSE_INDIVIDUAL_PARAM = "/>";
        private static final String[] validAttributes = new String[]{"page"};

        Forward() {
        }

        /*
         * Unable to fully structure code
         */
        public boolean accept(ParseEventListener listener, JspReader reader, Parser parser) throws JasperException {
            block4: {
                block7: {
                    block5: {
                        block6: {
                            if (!reader.matches("<jsp:forward")) break block4;
                            start = reader.mark();
                            reader.advance("<jsp:forward".length());
                            attrs = reader.parseTagAttributes();
                            param = new Hashtable<K, V>();
                            Parser.checkAttributes("Forward", attrs.keys(), Forward.validAttributes);
                            reader.skipSpaces();
                            if (reader.matches("/>")) break block5;
                            if (!reader.matches(">")) {
                                throw new ParseException(reader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{"<jsp:forward"}));
                            }
                            reader.advance(">".length());
                            reader.skipSpaces();
                            if (reader.matches("</jsp:forward>")) break block6;
                            reader.skipSpaces();
                            if (reader.matches("<jsp:param")) ** GOTO lbl28
                            throw new ParseException(reader.mark(), Constants.getString("jsp.error.paramexpected"));
lbl-1000:
                            // 1 sources

                            {
                                reader.parsePluginParamTag(param);
                                reader.skipSpaces();
                                if (!reader.matches("/>")) {
                                    throw new ParseException(reader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{"<jsp:param"}));
                                }
                                reader.advance("/>".length());
                                reader.skipSpaces();
lbl28:
                                // 2 sources

                                ** while (reader.matches((String)"<jsp:param"))
                            }
                        }
                        if (!reader.matches("</jsp:forward>")) {
                            throw new ParseException(reader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{"<jsp:forward"}));
                        }
                        reader.advance("</jsp:forward>".length());
                        break block7;
                    }
                    reader.advance("/>".length());
                }
                stop = reader.mark();
                listener.handleForward(start, stop, attrs, param);
                return true;
            }
            return false;
        }
    }

    static final class Comment
    implements CoreElement {
        private static final String OPEN_COMMENT = "<%--";
        private static final String CLOSE_COMMENT = "--%>";

        Comment() {
        }

        public boolean accept(ParseEventListener listener, JspReader reader, Parser parser) throws JasperException {
            if (reader.matches(OPEN_COMMENT)) {
                reader.advance(OPEN_COMMENT.length());
                Mark start = reader.mark();
                Mark stop = reader.skipUntil(CLOSE_COMMENT);
                if (stop == null) {
                    throw new ParseException(Constants.getString("jsp.error.unterminated", new Object[]{OPEN_COMMENT}));
                }
                parser.flushCharData();
                return true;
            }
            return false;
        }
    }

    static final class Declaration
    implements CoreElement {
        private static final String OPEN_DECL = "<%!";
        private static final String CLOSE_DECL = "%>";
        private static final String OPEN_DECL_2 = "<jsp:decl>";
        private static final String CLOSE_DECL_2 = "</jsp:decl>";

        Declaration() {
        }

        public boolean accept(ParseEventListener listener, JspReader reader, Parser parser) throws JasperException {
            String close;
            String open;
            if (reader.matches(OPEN_DECL_2)) {
                open = OPEN_DECL_2;
                close = CLOSE_DECL_2;
            } else if (reader.matches(OPEN_DECL)) {
                open = OPEN_DECL;
                close = CLOSE_DECL;
            } else {
                return false;
            }
            reader.advance(open.length());
            Mark start = reader.mark();
            Mark stop = reader.skipUntil(close);
            if (stop == null) {
                throw new ParseException(Constants.getString("jsp.error.unterminated", new Object[]{open}));
            }
            listener.handleDeclaration(start, stop);
            return true;
        }
    }

    static final class Expression
    implements CoreElement {
        private static final String OPEN_EXPR = "<%=";
        private static final String CLOSE_EXPR = "%>";
        private static final String OPEN_EXPR_2 = "<jsp:expr>";
        private static final String CLOSE_EXPR_2 = "</jsp:expr>";

        Expression() {
        }

        public boolean accept(ParseEventListener listener, JspReader reader, Parser parser) throws JasperException {
            String close;
            String open;
            if (reader.matches(OPEN_EXPR_2)) {
                open = OPEN_EXPR_2;
                close = CLOSE_EXPR_2;
            } else if (reader.matches(OPEN_EXPR)) {
                open = OPEN_EXPR;
                close = CLOSE_EXPR;
            } else {
                return false;
            }
            reader.advance(open.length());
            Mark start = reader.mark();
            Mark stop = reader.skipUntil(close);
            if (stop == null) {
                throw new ParseException(reader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{open}));
            }
            listener.handleExpression(start, stop);
            return true;
        }
    }

    static final class Scriptlet
    implements CoreElement {
        private static final String OPEN_SCRIPTLET = "<%";
        private static final String CLOSE_SCRIPTLET = "%>";
        private static final String OPEN_SCRIPTLET_2 = "<jsp:scriptlet>";
        private static final String CLOSE_SCRIPTLET_2 = "</jsp:scriptlet>";

        Scriptlet() {
        }

        public boolean accept(ParseEventListener listener, JspReader reader, Parser parser) throws JasperException {
            String close;
            String open;
            if (reader.matches(OPEN_SCRIPTLET_2)) {
                open = OPEN_SCRIPTLET_2;
                close = CLOSE_SCRIPTLET_2;
            } else if (reader.matches(OPEN_SCRIPTLET)) {
                open = OPEN_SCRIPTLET;
                close = CLOSE_SCRIPTLET;
            } else {
                return false;
            }
            reader.advance(open.length());
            Mark start = reader.mark();
            Mark stop = reader.skipUntil(close);
            if (stop == null) {
                throw new ParseException(reader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{open}));
            }
            listener.handleScriptlet(start, stop);
            return true;
        }
    }

    static final class Bean
    implements CoreElement {
        private static final String OPEN_BEAN = "<jsp:useBean";
        private static final String CLOSE_BEAN = "/>";
        private static final String CLOSE_BEAN_2 = "</jsp:useBean>";
        private static final String CLOSE_BEAN_3 = ">";
        private static final String[] validAttributes = new String[]{"id", "scope", "class", "type", "beanName"};

        Bean() {
        }

        public boolean accept(ParseEventListener listener, JspReader reader, Parser parser) throws JasperException {
            if (reader.matches(OPEN_BEAN)) {
                Mark start = reader.mark();
                reader.advance(OPEN_BEAN.length());
                Hashtable attrs = reader.parseTagAttributesBean();
                Parser.checkAttributes("useBean", attrs.keys(), validAttributes);
                reader.skipSpaces();
                if (!reader.matches(CLOSE_BEAN)) {
                    if (!reader.matches(CLOSE_BEAN_3)) {
                        throw new ParseException(reader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{"useBean"}));
                    }
                    reader.advance(CLOSE_BEAN_3.length());
                    Mark stop = reader.mark();
                    listener.handleBean(start, stop, attrs);
                    int oldSize = reader.size;
                    parser.parse(CLOSE_BEAN_2);
                    if (oldSize != reader.size) {
                        throw new ParseException(reader.mark(), Constants.getString("jsp.error.usebean.notinsamefile"));
                    }
                    if (!reader.matches(CLOSE_BEAN_2)) {
                        throw new ParseException(reader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{OPEN_BEAN}));
                    }
                    reader.advance(CLOSE_BEAN_2.length());
                    listener.handleBeanEnd(start, stop, attrs);
                    return true;
                }
                reader.advance(CLOSE_BEAN.length());
                Mark stop = reader.mark();
                listener.handleBean(start, stop, attrs);
                listener.handleBeanEnd(start, stop, attrs);
                return true;
            }
            return false;
        }
    }

    static final class GetProperty
    implements CoreElement {
        private static final String OPEN_GETPROPERTY = "<jsp:getProperty";
        private static final String CLOSE_GETPROPERTY = "/>";
        private static final String[] validAttributes = new String[]{"name", "property"};

        GetProperty() {
        }

        public boolean accept(ParseEventListener listener, JspReader reader, Parser parser) throws JasperException {
            if (reader.matches(OPEN_GETPROPERTY)) {
                Mark start = reader.mark();
                reader.advance(OPEN_GETPROPERTY.length());
                Hashtable attrs = reader.parseTagAttributes();
                Parser.checkAttributes("getProperty", attrs.keys(), validAttributes);
                reader.skipSpaces();
                if (!reader.matches(CLOSE_GETPROPERTY)) {
                    throw new ParseException(reader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{OPEN_GETPROPERTY}));
                }
                reader.advance(CLOSE_GETPROPERTY.length());
                Mark stop = reader.mark();
                listener.handleGetProperty(start, stop, attrs);
                return true;
            }
            return false;
        }
    }

    static final class SetProperty
    implements CoreElement {
        private static final String OPEN_SETPROPERTY = "<jsp:setProperty";
        private static final String CLOSE_SETPROPERTY = "/>";
        private static final String[] validAttributes = new String[]{"name", "property", "value", "param"};

        SetProperty() {
        }

        public boolean accept(ParseEventListener listener, JspReader reader, Parser parser) throws JasperException {
            if (reader.matches(OPEN_SETPROPERTY)) {
                Mark start = reader.mark();
                reader.advance(OPEN_SETPROPERTY.length());
                Hashtable attrs = reader.parseTagAttributes();
                Parser.checkAttributes("setProperty", attrs.keys(), validAttributes);
                reader.skipSpaces();
                if (!reader.matches(CLOSE_SETPROPERTY)) {
                    throw new ParseException(reader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{OPEN_SETPROPERTY}));
                }
                reader.advance(CLOSE_SETPROPERTY.length());
                Mark stop = reader.mark();
                listener.handleSetProperty(start, stop, attrs);
                return true;
            }
            return false;
        }
    }

    static final class Tag
    implements CoreElement {
        private static final String CLOSE_1 = "/>";
        private static final String CLOSE = ">";

        Tag() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean accept(ParseEventListener listener, JspReader reader, Parser parser) throws JasperException {
            if (reader.peekChar() != 60) {
                return false;
            }
            Mark start = reader.mark();
            reader.nextChar();
            String tag = reader.parseToken(false);
            int i2 = tag.indexOf(58);
            if (i2 == -1) {
                reader.reset(start);
                return false;
            }
            String prefix = tag.substring(0, i2);
            String shortTagName = null;
            if (++i2 < tag.length() - 1) {
                shortTagName = tag.substring(i2);
            }
            if (shortTagName == null) {
                throw new ParseException(start, "Nothing after the :");
            }
            TagLibraries libraries = listener.getTagLibraries();
            if (!libraries.isUserDefinedTag(prefix, shortTagName)) {
                reader.reset(start);
                return false;
            }
            TagLibraryInfoImpl tli = libraries.getTagLibInfo(prefix);
            TagInfo ti = tli.getTag(shortTagName);
            if (ti == null) {
                throw new ParseException(start, "Unable to locate TagInfo for " + tag);
            }
            String bc2 = ti.getBodyContent();
            Hashtable attrs = reader.parseTagAttributes();
            reader.skipSpaces();
            Mark bodyStart = null;
            Object bodyStop = null;
            if (reader.matches(CLOSE_1) || bc2.equalsIgnoreCase("EMPTY")) {
                if (!reader.matches(CLOSE_1)) {
                    throw new ParseException(start, "Body is supposed to be empty for " + tag);
                }
                reader.advance(CLOSE_1.length());
                listener.handleTagBegin(start, attrs, prefix, shortTagName, tli, ti);
                listener.handleTagEnd(start, reader.mark(), prefix, shortTagName, attrs, tli, ti);
                return true;
            } else {
                if (!reader.matches(CLOSE)) throw new ParseException(start, "Unterminated user-defined tag");
                reader.advance(CLOSE.length());
                bodyStart = reader.mark();
                listener.handleTagBegin(bodyStart, attrs, prefix, shortTagName, tli, ti);
                if (!bc2.equalsIgnoreCase("TAGDEPENDENT") && !bc2.equalsIgnoreCase("JSP")) throw new ParseException(start, "Internal Error: Invalid BODY_CONTENT type");
                String tagEnd = "</" + tag + CLOSE;
                parser.parse(tagEnd);
                reader.advance(tagEnd.length());
                listener.handleTagEnd(bodyStart, reader.mark(), prefix, shortTagName, attrs, tli, ti);
            }
            return true;
        }
    }

    static final class Plugin
    implements CoreElement {
        private static final String OPEN_PLUGIN = "<jsp:plugin";
        private static final String END_OPEN_PLUGIN = ">";
        private static final String CLOSE_PLUGIN = "</jsp:plugin>";
        private static final String OPEN_PARAMS = "<jsp:params>";
        private static final String CLOSE_PARAMS = "</jsp:params>";
        private static final String OPEN_INDIVIDUAL_PARAM = "<jsp:param";
        private static final String CLOSE_INDIVIDUAL_PARAM = "/>";
        private static final String OPEN_FALLBACK = "<jsp:fallback>";
        private static final String CLOSE_FALLBACK = "</jsp:fallback>";
        private static final String[] validAttributes = new String[]{"type", "code", "codebase", "align", "archive", "height", "hspace", "jreversion", "name", "vspace", "width", "nspluginurl", "iepluginurl", "params", "fallback"};

        Plugin() {
        }

        public boolean accept(ParseEventListener listener, JspReader reader, Parser parser) throws JasperException {
            if (reader.matches(OPEN_PLUGIN)) {
                Mark start = reader.mark();
                reader.advance(OPEN_PLUGIN.length());
                Hashtable attrs = reader.parseTagAttributes();
                reader.skipSpaces();
                if (!reader.matches(END_OPEN_PLUGIN)) {
                    throw new ParseException(reader.mark(), Constants.getString("jsp.error.plugin.notclosed"));
                }
                reader.advance(END_OPEN_PLUGIN.length());
                reader.skipSpaces();
                Hashtable param = null;
                String fallback = null;
                Parser.checkAttributes("plugin", attrs.keys(), validAttributes);
                if (reader.matches(OPEN_PARAMS)) {
                    param = new Hashtable();
                    boolean paramsClosed = false;
                    reader.advance(OPEN_PARAMS.length());
                    while (reader.hasMoreInput()) {
                        reader.skipSpaces();
                        if (reader.matches(CLOSE_PARAMS)) {
                            paramsClosed = true;
                            reader.advance(CLOSE_PARAMS.length());
                            break;
                        }
                        if (!reader.matches(OPEN_INDIVIDUAL_PARAM)) {
                            throw new ParseException(reader.mark(), Constants.getString("jsp.error.paramexpected"));
                        }
                        reader.parsePluginParamTag(param);
                        reader.skipSpaces();
                        if (!reader.matches(CLOSE_INDIVIDUAL_PARAM)) {
                            throw new ParseException(reader.mark(), Constants.getString("jsp.error.closeindividualparam"));
                        }
                        reader.advance(CLOSE_INDIVIDUAL_PARAM.length());
                    }
                    if (!paramsClosed) {
                        throw new ParseException(reader.mark(), Constants.getString("jsp.error.closeparams"));
                    }
                    reader.skipSpaces();
                }
                if (reader.matches(OPEN_FALLBACK)) {
                    reader.advance(OPEN_FALLBACK.length());
                    reader.skipSpaces();
                    Mark fallBackStart = reader.mark();
                    Mark fallBackStop = reader.skipUntil(CLOSE_FALLBACK);
                    fallback = new String(reader.getChars(fallBackStart, fallBackStop));
                    reader.skipSpaces();
                }
                if (!reader.matches(CLOSE_PLUGIN)) {
                    throw new ParseException(reader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{OPEN_PLUGIN}));
                }
                reader.advance(CLOSE_PLUGIN.length());
                Mark stop = reader.mark();
                listener.handlePlugin(start, stop, attrs, param, fallback);
                return true;
            }
            return false;
        }
    }

    static final class QuoteEscape
    implements CoreElement {
        private static String QUOTED_START_TAG = "<\\%";
        private static String QUOTED_END_TAG = "%\\>";
        private static String START_TAG = "<%";
        private static String END_TAG = "%>";
        private static final String APOS = "&apos;";
        private static final String QUOTE = "&quote;";

        QuoteEscape() {
        }

        public boolean accept(ParseEventListener listener, JspReader reader, Parser parser) throws JasperException {
            try {
                if (reader.matches(QUOTED_START_TAG)) {
                    reader.advance(QUOTED_START_TAG.length());
                    parser.caw.write(START_TAG);
                    parser.flushCharData();
                    return true;
                }
                if (reader.matches(APOS)) {
                    reader.advance(APOS.length());
                    parser.caw.write("'");
                    parser.flushCharData();
                    return true;
                }
                if (reader.matches(QUOTE)) {
                    reader.advance(QUOTE.length());
                    parser.caw.write("\"");
                    parser.flushCharData();
                    return true;
                }
            }
            catch (IOException ex2) {
                System.out.println(ex2.getMessage());
            }
            return false;
        }
    }
}

