/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import org.apache.jasper.compiler.Mark;

public class ServletWriter {
    public static int TAB_WIDTH = 4;
    public static String SPACES = "                              ";
    int indent = 0;
    PrintWriter writer;

    public ServletWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void indent() {
        this.writer.print(SPACES.substring(0, this.indent));
    }

    public void popIndent() {
        if ((this.indent -= TAB_WIDTH) <= 0) {
            this.indent = 0;
        }
    }

    public void print(String s2) {
        this.writer.print(s2);
    }

    public void printComment(Mark start, Mark stop, char[] chars) {
        if (start != null && stop != null) {
            this.println("// from=" + start);
            this.println("//   to=" + stop);
        }
        if (chars != null) {
            int i2 = 0;
            while (i2 < chars.length) {
                this.indent();
                this.print("// ");
                while (chars[i2] != '\n' && i2 < chars.length) {
                    this.writer.print(chars[i2++]);
                }
            }
        }
    }

    public void printMultiLn(String multiline) {
        BufferedReader reader = new BufferedReader(new StringReader(multiline));
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                this.println(line);
            }
        }
        catch (IOException iOException) {}
    }

    public void println() {
        this.writer.println("");
    }

    public void println(String line) {
        this.writer.println(String.valueOf(SPACES.substring(0, this.indent)) + line);
    }

    public void pushIndent() {
        if ((this.indent += TAB_WIDTH) > SPACES.length()) {
            this.indent = SPACES.length();
        }
    }

    public String quoteString(String s2) {
        if (s2 == null) {
            return "null";
        }
        if (s2.indexOf(34) < 0 && s2.indexOf(92) < 0 && s2.indexOf(10) < 0 && s2.indexOf(13) < 0) {
            return "\"" + s2 + "\"";
        }
        StringBuffer sb = new StringBuffer();
        int len = s2.length();
        sb.append('\"');
        int i2 = 0;
        while (i2 < len) {
            char ch2 = s2.charAt(i2);
            if (ch2 == '\\' && i2 + 1 < len) {
                sb.append('\\');
                sb.append('\\');
                sb.append(s2.charAt(++i2));
            } else if (ch2 == '\"') {
                sb.append('\\');
                sb.append('\"');
            } else if (ch2 == '\n') {
                sb.append("\\n");
            } else if (ch2 == '\r') {
                sb.append("\\r");
            } else {
                sb.append(ch2);
            }
            ++i2;
        }
        sb.append('\"');
        return sb.toString();
    }
}

