/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.util.Hashtable;
import java.util.Stack;
import javax.servlet.jsp.tagext.VariableInfo;
import org.apache.jasper.compiler.GeneratorBase;
import org.apache.jasper.compiler.ServletWriter;

abstract class TagGeneratorBase
extends GeneratorBase {
    private static Stack tagHandlerStack = new Stack();
    private static Hashtable tagVarNumbers = new Hashtable();

    TagGeneratorBase() {
    }

    protected static void declareVariables(ServletWriter writer, VariableInfo[] vi, boolean declare, boolean update, int scope) {
        if (vi != null) {
            int i2 = 0;
            while (i2 < vi.length) {
                if (vi[i2].getScope() == scope) {
                    if (vi[i2].getDeclare() && declare) {
                        writer.println(String.valueOf(vi[i2].getClassName()) + " " + vi[i2].getVarName() + " = null;");
                    }
                    if (update) {
                        writer.println(String.valueOf(vi[i2].getVarName()) + " = (" + vi[i2].getClassName() + ") pageContext.getAttribute(" + writer.quoteString(vi[i2].getVarName()) + ");");
                    }
                }
                ++i2;
            }
        }
    }

    protected static String getTagVarName(String prefix, String shortTagName) {
        Hashtable hashtable = tagVarNumbers;
        synchronized (hashtable) {
            String tag = String.valueOf(prefix) + ":" + shortTagName;
            String varName = String.valueOf(prefix) + "_" + shortTagName + "_";
            if (tagVarNumbers.get(tag) != null) {
                Integer i2 = (Integer)tagVarNumbers.get(tag);
                varName = String.valueOf(varName) + i2;
                tagVarNumbers.put(tag, new Integer(i2 + 1));
                String string = varName;
                Object var4_8 = null;
                return string;
            }
            tagVarNumbers.put(tag, new Integer(1));
            String string = String.valueOf(varName) + "0";
            Object var4_9 = null;
            return string;
        }
    }

    protected static void tagBegin(TagVariableData tvd) {
        tagHandlerStack.push(tvd);
    }

    protected static TagVariableData tagEnd() {
        return (TagVariableData)tagHandlerStack.pop();
    }

    protected static TagVariableData topTag() {
        if (tagHandlerStack.empty()) {
            return null;
        }
        return (TagVariableData)tagHandlerStack.peek();
    }

    static class TagVariableData {
        String tagHandlerInstanceName;
        String tagEvalVarName;

        TagVariableData(String tagHandlerInstanceName, String tagEvalVarName) {
            this.tagHandlerInstanceName = tagHandlerInstanceName;
            this.tagEvalVarName = tagEvalVarName;
        }
    }
}

