/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import com.sun.xml.tree.XmlDocument;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspEngineContext;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.TagCache;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TagLibraryInfoImpl
extends TagLibraryInfo {
    private static final String TLD = "META-INF/taglib.tld";
    private static final String WEBAPP_INF = "/WEB-INF/web.xml";
    XmlDocument tld;
    Hashtable jarEntries;
    Hashtable tagCaches = new Hashtable();
    JspEngineContext ctxt;

    TagLibraryInfoImpl(JspEngineContext ctxt, String prefix, String uriIn) throws IOException, JasperException {
        super(prefix, uriIn);
        this.ctxt = ctxt;
        InputStream in = null;
        URL url = null;
        boolean relativeURL = false;
        this.uri = uriIn;
        if (!uriIn.endsWith("jar")) {
            URL dtdURL;
            XmlDocument webtld;
            NodeList nList;
            InputStream is = ctxt.getServletContext().getResourceAsStream(WEBAPP_INF);
            if (is != null && (nList = (webtld = JspUtil.parseXMLDoc(is, dtdURL = this.getClass().getResource("/org/apache/tomcat/deployment/web.dtd"), "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN")).getElementsByTagName("taglib")).getLength() != 0) {
                int i2 = 0;
                while (i2 < nList.getLength()) {
                    Element e10 = (Element)nList.item(i2);
                    NodeList list = e10.getChildNodes();
                    String tagLoc = null;
                    boolean match = false;
                    int j2 = 0;
                    while (j2 < list.getLength()) {
                        String tmpUri;
                        Text t2;
                        Element em2 = (Element)list.item(j2);
                        String tname = em2.getNodeName();
                        if (tname.equals("taglib-location") && (t2 = (Text)em2.getFirstChild()) != null && (tagLoc = t2.getData()) != null) {
                            tagLoc = tagLoc.trim();
                        }
                        if (tname.equals("taglib-uri") && (t2 = (Text)em2.getFirstChild()) != null && (tmpUri = t2.getData()) != null && (tmpUri = tmpUri.trim()).equals(uriIn)) {
                            match = true;
                        }
                        ++j2;
                    }
                    if (match && tagLoc != null) {
                        this.uri = tagLoc;
                    }
                    ++i2;
                }
            }
            if (!this.uri.startsWith("/")) {
                HttpServletRequest request = ctxt.getRequest();
                String actURI = request.getServletPath();
                String baseURI = actURI.substring(0, actURI.lastIndexOf(47));
                this.uri = String.valueOf(baseURI) + '/' + this.uri;
            }
            if ((in = ctxt.getServletContext().getResourceAsStream(this.uri)) == null) {
                throw new JasperException(Constants.getString("jsp.error.tld_not_found", new Object[]{TLD}));
            }
            this.parseTLD(in);
        }
        if (uriIn.endsWith("jar")) {
            ZipEntry entry;
            if (!uriIn.startsWith("/")) {
                url = new URL(uriIn);
                in = url.openStream();
            } else {
                relativeURL = true;
                in = ctxt.getServletContext().getResourceAsStream(uriIn);
            }
            ZipInputStream zin = new ZipInputStream(in);
            this.jarEntries = new Hashtable();
            this.ctxt = ctxt;
            File jspFile = new File(ctxt.getJspFile());
            String jarFileName = String.valueOf(ctxt.getOutputDir()) + File.separatorChar + jspFile.getParent().toString();
            File jspDir = new File(jarFileName);
            jspDir.mkdirs();
            jarFileName = relativeURL ? String.valueOf(jarFileName) + File.separatorChar + new File(this.uri).getName() : String.valueOf(jarFileName) + File.separatorChar + new File(url.getFile()).getName();
            Constants.message("jsp.message.copyinguri", new Object[]{this.uri, jarFileName}, 2);
            if (relativeURL) {
                TagLibraryInfoImpl.copy(ctxt.getServletContext().getResourceAsStream(this.uri), jarFileName);
            } else {
                TagLibraryInfoImpl.copy(url.openStream(), jarFileName);
            }
            ctxt.getClassLoader().addJar(jarFileName);
            boolean tldFound = false;
            while ((entry = zin.getNextEntry()) != null) {
                ByteArrayOutputStream baos;
                if (entry.getName().equals(TLD)) {
                    baos = new ByteArrayOutputStream();
                    while (zin.available() != 0) {
                        int b10 = ((InflaterInputStream)zin).read();
                        if (b10 == -1) break;
                        baos.write(b10);
                    }
                    baos.close();
                    ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                    tldFound = true;
                    this.parseTLD(bais);
                } else {
                    baos = new ByteArrayOutputStream();
                    while (zin.available() != 0) {
                        int b11 = ((InflaterInputStream)zin).read();
                        if (b11 == -1) break;
                        baos.write(b11);
                    }
                    baos.close();
                    this.jarEntries.put(entry.getName(), baos.toByteArray());
                }
                zin.closeEntry();
            }
            if (!tldFound) {
                throw new JasperException(Constants.getString("jsp.error.tld_not_found", new Object[]{TLD}));
            }
        }
    }

    static void copy(InputStream in, String fileName) throws IOException, FileNotFoundException {
        int nRead;
        byte[] buf = new byte[1024];
        FileOutputStream out = new FileOutputStream(fileName);
        while ((nRead = in.read(buf, 0, buf.length)) != -1) {
            out.write(buf, 0, nRead);
        }
    }

    TagAttributeInfo createAttribute(Element elem) {
        String name = null;
        boolean required = false;
        boolean rtexprvalue = false;
        boolean reqTime = false;
        String type = null;
        NodeList list = elem.getChildNodes();
        int i2 = 0;
        while (i2 < list.getLength()) {
            Text t2;
            Element e10 = (Element)list.item(i2);
            String tname = e10.getTagName();
            if (tname.equals("name")) {
                t2 = (Text)e10.getFirstChild();
                if (t2 != null) {
                    name = t2.getData();
                }
            } else if (tname.equals("required")) {
                t2 = (Text)e10.getFirstChild();
                if (t2 != null) {
                    required = Boolean.valueOf(t2.getData());
                }
            } else if (tname.equals("rtexprvalue")) {
                t2 = (Text)e10.getFirstChild();
                if (t2 != null) {
                    rtexprvalue = Boolean.valueOf(t2.getData());
                }
            } else if (tname.equals("type")) {
                t2 = (Text)e10.getFirstChild();
                if (t2 != null) {
                    type = t2.getData();
                }
            } else {
                Constants.message("jsp.warning.unknown.element.in.attribute", new Object[]{e10.getTagName()}, 0);
            }
            ++i2;
        }
        return new TagAttributeInfo(name, required, rtexprvalue, type);
    }

    private TagInfo createTagInfo(Element elem) throws JasperException {
        String name = null;
        String tagclass = null;
        String teiclass = null;
        String bodycontent = "JSP";
        String info = null;
        Vector<TagAttributeInfo> attributeVector = new Vector<TagAttributeInfo>();
        NodeList list = elem.getChildNodes();
        int i2 = 0;
        while (i2 < list.getLength()) {
            Text t2;
            Element e10 = (Element)list.item(i2);
            String tname = e10.getTagName();
            if (tname.equals("name")) {
                t2 = (Text)e10.getFirstChild();
                if (t2 != null) {
                    name = t2.getData();
                }
            } else if (tname.equals("tagclass")) {
                t2 = (Text)e10.getFirstChild();
                if (t2 != null) {
                    tagclass = t2.getData();
                }
            } else if (tname.equals("teiclass")) {
                t2 = (Text)e10.getFirstChild();
                if (t2 != null) {
                    teiclass = t2.getData();
                }
            } else if (tname.equals("bodycontent")) {
                t2 = (Text)e10.getFirstChild();
                if (t2 != null) {
                    bodycontent = t2.getData();
                }
            } else if (tname.equals("info")) {
                t2 = (Text)e10.getFirstChild();
                if (t2 != null) {
                    info = t2.getData();
                }
            } else if (tname.equals("attribute")) {
                attributeVector.addElement(this.createAttribute(e10));
            } else {
                Constants.message("jsp.warning.unknown.element.in.tag", new Object[]{e10.getTagName()}, 0);
            }
            ++i2;
        }
        Object[] tagAttributeInfo = new TagAttributeInfo[attributeVector.size()];
        attributeVector.copyInto(tagAttributeInfo);
        TagExtraInfo tei = null;
        if (teiclass != null && !teiclass.equals("")) {
            try {
                Class<?> teiClass = this.ctxt.getClassLoader().loadClass(teiclass);
                tei = (TagExtraInfo)teiClass.newInstance();
            }
            catch (ClassNotFoundException cex) {
                Constants.message("jsp.warning.teiclass.is.null", new Object[]{teiclass, cex.getMessage()}, 0);
            }
            catch (IllegalAccessException iae) {
                Constants.message("jsp.warning.teiclass.is.null", new Object[]{teiclass, iae.getMessage()}, 0);
            }
            catch (InstantiationException ie) {
                Constants.message("jsp.warning.teiclass.is.null", new Object[]{teiclass, ie.getMessage()}, 0);
            }
        }
        TagInfo taginfo = new TagInfo(name, tagclass, bodycontent, info, this, tei, (TagAttributeInfo[])tagAttributeInfo);
        return taginfo;
    }

    TagCache getTagCache(String shortTagName) {
        return (TagCache)this.tagCaches.get(shortTagName);
    }

    private void parseTLD(InputStream in) throws JasperException {
        URL tagUrl = this.getClass().getResource("/org/apache/jasper/resources/web-jsptaglib_1_1.dtd");
        this.tld = JspUtil.parseXMLDoc(in, tagUrl, "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN");
        Vector<TagInfo> tagVector = new Vector<TagInfo>();
        NodeList list = this.tld.getElementsByTagName("taglib");
        if (list.getLength() != 1) {
            throw new JasperException(Constants.getString("jsp.error.more.than.one.taglib"));
        }
        Element elem = (Element)list.item(0);
        list = elem.getChildNodes();
        int i2 = 0;
        while (i2 < list.getLength()) {
            Text t2;
            Element e10 = (Element)list.item(i2);
            String tname = e10.getTagName();
            if (tname.equals("tlibversion")) {
                t2 = (Text)e10.getFirstChild();
                if (t2 != null) {
                    this.tlibversion = t2.getData();
                }
            } else if (tname.equals("jspversion")) {
                t2 = (Text)e10.getFirstChild();
                if (t2 != null) {
                    this.jspversion = t2.getData();
                }
            } else if (tname.equals("shortname")) {
                t2 = (Text)e10.getFirstChild();
                if (t2 != null) {
                    this.shortname = t2.getData();
                }
            } else if (tname.equals("urn")) {
                t2 = (Text)e10.getFirstChild();
                if (t2 != null) {
                    this.urn = t2.getData();
                }
            } else if (tname.equals("info")) {
                t2 = (Text)e10.getFirstChild();
                if (t2 != null) {
                    this.info = t2.getData();
                }
            } else if (tname.equals("tag")) {
                tagVector.addElement(this.createTagInfo(e10));
            } else {
                Constants.message("jsp.warning.unknown.element.in.TLD", new Object[]{e10.getTagName()}, 0);
            }
            ++i2;
        }
        this.tags = new TagInfo[tagVector.size()];
        tagVector.copyInto(this.tags);
    }

    private final void print(String name, String value, PrintWriter w2) {
        if (value != null) {
            w2.print(String.valueOf(name) + " = {\n\t");
            w2.print(value);
            w2.print("\n}\n");
        }
    }

    void putTagCache(String shortTagName, TagCache tc) {
        this.tagCaches.put(shortTagName, tc);
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        this.print("tlibversion", this.tlibversion, out);
        this.print("jspversion", this.jspversion, out);
        this.print("shortname", this.shortname, out);
        this.print("urn", this.urn, out);
        this.print("info", this.info, out);
        int i2 = 0;
        while (i2 < this.tags.length) {
            out.println(this.tags[i2].toString());
            ++i2;
        }
        return sw.toString();
    }
}

