/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import com.sun.enterprise.util.FileUtil;
import com.sun.web.server.WebServer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspEngineContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Compiler;

public class JspLoader
extends ClassLoader {
    private static ProtectionDomain pd = null;
    Hashtable loadedJSPs = new Hashtable();
    ClassLoader parent;
    ServletContext context;
    Options options;
    private Vector jars = new Vector();

    JspLoader(ServletContext context, ClassLoader cl2, Options options) {
        this.context = context;
        this.parent = cl2;
        this.options = options;
    }

    public void addJar(String jarFileName) throws IOException {
        if (!this.jars.contains(jarFileName)) {
            Constants.message("jsp.message.adding_jar", new Object[]{jarFileName}, 2);
            this.jars.addElement(jarFileName);
        }
    }

    public final Class defClass(String className, byte[] classData) {
        return this.defineClass(className, classData, 0, classData.length, JspLoader.getProtectionDomain());
    }

    protected Class findClass(String className) throws ClassNotFoundException {
        try {
            int beg = className.lastIndexOf(".") == -1 ? 0 : className.lastIndexOf(".") + 1;
            int end = className.lastIndexOf("_jsp_");
            if (end <= 0) {
                byte[] classBytes = this.loadClassDataFromJar(className);
                if (classBytes == null) {
                    throw new ClassNotFoundException(className);
                }
                return this.defClass(className, classBytes);
            }
            String fileName = null;
            String outputDir = this.options.scratchDir().toString();
            if (className.indexOf(36, end) != -1) {
                fileName = String.valueOf(outputDir) + File.separatorChar + className.replace('.', File.separatorChar) + ".class";
            } else {
                fileName = String.valueOf(className.substring(beg, end)) + ".class";
                fileName = String.valueOf(outputDir) + File.separatorChar + fileName;
            }
            FileInputStream fin = new FileInputStream(fileName);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int i2 = 0;
            while ((i2 = fin.read(buf)) != -1) {
                baos.write(buf, 0, i2);
            }
            fin.close();
            baos.close();
            byte[] classBytes = baos.toByteArray();
            return this.defClass(className, classBytes);
        }
        catch (Exception exception) {
            throw new ClassNotFoundException(Constants.getString("jsp.error.unable.loadclass", new Object[]{className}));
        }
    }

    private byte[] getClassData(InputStream istream) throws IOException {
        byte[] buf = new byte[1024];
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int num = 0;
        while ((num = istream.read(buf)) != -1) {
            bout.write(buf, 0, num);
        }
        return bout.toByteArray();
    }

    public String getClassPath() {
        StringBuffer cpath = new StringBuffer();
        String sep = System.getProperty("path.separator");
        int i2 = 0;
        while (i2 < this.jars.size()) {
            cpath.append(String.valueOf((String)this.jars.elementAt(i2)) + sep);
            ++i2;
        }
        return cpath.toString();
    }

    public Class getJspServletClass(String name) {
        return (Class)this.loadedJSPs.get(name);
    }

    static ProtectionDomain getProtectionDomain() {
        if (pd == null) {
            File wDir = new File(FileUtil.getAbsolutePath(WebServer.getDocumentRoot()));
            URL url = null;
            try {
                url = wDir.toURL();
            }
            catch (Exception e10) {
                e10.printStackTrace();
            }
            final CodeSource cs2 = new CodeSource(url, null);
            pd = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new ProtectionDomain(cs2, Policy.getPolicy().getPermissions(cs2));
                }
            });
        }
        return pd;
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c10 = this.findLoadedClass(name);
        if (c10 == null) {
            try {
                c10 = this.parent != null ? this.parent.loadClass(name) : this.findSystemClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                c10 = this.findClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(c10);
        }
        return c10;
    }

    private byte[] loadClassDataFromJar(String className) {
        String entryName = String.valueOf(className.replace('.', '/')) + ".class";
        InputStream classStream = null;
        int i2 = 0;
        while (i2 < this.jars.size()) {
            File thisFile = new File((String)this.jars.elementAt(i2));
            try {
                if (!thisFile.exists()) {
                    return null;
                }
                if (thisFile.isFile()) {
                    ZipFile zip = new ZipFile(thisFile);
                    ZipEntry entry = zip.getEntry(entryName);
                    if (entry != null) {
                        classStream = zip.getInputStream(entry);
                        byte[] classData = this.getClassData(classStream);
                        zip.close();
                        return classData;
                    }
                    zip.close();
                } else {
                    File classFile = new File(thisFile, entryName.replace('/', File.separatorChar));
                    if (classFile.exists()) {
                        classStream = new FileInputStream(classFile);
                        byte[] classData = this.getClassData(classStream);
                        classStream.close();
                        return classData;
                    }
                }
            }
            catch (IOException iOException) {
                return null;
            }
            ++i2;
        }
        return null;
    }

    public boolean loadJSP(String name, String classpath, boolean isErrorPage, HttpServletRequest req, HttpServletResponse res) throws JasperException, FileNotFoundException {
        Class jspClass = (Class)this.loadedJSPs.get(name);
        boolean firstTime = jspClass == null;
        JspEngineContext ctxt = new JspEngineContext(this, classpath, this.context, name, isErrorPage, this.options, req, res);
        boolean outDated = false;
        final Compiler compiler = ctxt.createCompiler();
        try {
            try {
                Boolean ret = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new Boolean(compiler.compile());
                    }
                });
                outDated = ret;
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
        catch (FileNotFoundException ex2) {
            throw ex2;
        }
        catch (JasperException ex3) {
            throw ex3;
        }
        catch (Exception ex4) {
            throw new JasperException(Constants.getString("jsp.error.unable.compile"), ex4);
        }
        if (jspClass == null || outDated) {
            try {
                jspClass = this.loadClass(ctxt.getFullClassName(), true);
            }
            catch (ClassNotFoundException cex) {
                throw new JasperException(Constants.getString("jsp.error.unable.load"), cex);
            }
            this.loadedJSPs.put(name, jspClass);
        }
        return outDated;
    }
}

