/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.HttpJspPage;
import javax.servlet.jsp.JspFactory;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.Options;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspFactoryImpl;
import org.apache.jasper.runtime.JspLoader;
import org.apache.jasper.runtime.ServletEngine;

public class JspServlet
extends HttpServlet {
    ServletContext context = null;
    Hashtable jsps = new Hashtable();
    ServletConfig config;
    JspLoader loader;
    Options options;
    ClassLoader parentClassLoader;
    ServletEngine engine;
    String serverInfo;
    static boolean firstTime = true;

    public void destroy() {
        if (Constants.matchVerbosity(2)) {
            System.err.println("JspServlet.destroy()");
        }
        Enumeration servlets = this.jsps.elements();
        while (servlets.hasMoreElements()) {
            ((JspServletWrapper)servlets.nextElement()).destroy();
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.config = config;
        this.context = config.getServletContext();
        this.serverInfo = this.context.getServerInfo();
        this.engine = ServletEngine.getServletEngine(this.serverInfo);
        if (this.engine == null) {
            Constants.message("jsp.error.bad-servlet-engine", Integer.MIN_VALUE);
        } else {
            this.options = new Options(config, this.context);
            this.parentClassLoader = (ClassLoader)this.context.getAttribute("org.apache.tomcat.classloader");
            if (this.parentClassLoader == null) {
                this.parentClassLoader = this.getClass().getClassLoader();
            }
            Constants.message("jsp.message.parent_class_loader_is", new Object[]{this.parentClassLoader.toString()}, 2);
            this.loader = new JspLoader(this.context, this.parentClassLoader, this.options);
            if (firstTime) {
                firstTime = false;
                Constants.message("jsp.message.scratch.dir.is", new Object[]{this.options.scratchDir().toString()}, 1);
                Constants.message("jsp.message.dont.modify.servlets", 1);
            }
        }
        JspFactory.setDefaultFactory(new JspFactoryImpl());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean preCompile(HttpServletRequest request) throws ServletException {
        boolean precompile = false;
        String precom = request.getParameter("jsp_precompile");
        String qString = request.getQueryString();
        if (precom != null) {
            if (precom.equals("true")) {
                return true;
            }
            if (!precom.equals("false")) throw new ServletException("Can't have request parameter  jsp_precomile set to " + precom);
            return false;
        }
        if (qString == null) return precompile;
        if (qString.startsWith("jsp_precompile")) return true;
        if (qString.indexOf("&jsp_precompile") == -1) return precompile;
        return true;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String includeUri = (String)request.getAttribute("javax.servlet.include.request_uri");
            String jspUri = includeUri == null ? request.getServletPath() : includeUri;
            boolean precompile = this.preCompile(request);
            if (Constants.matchVerbosity(2)) {
                System.err.println("JspEngine --> " + jspUri);
                System.err.println("\t     ServletPath: " + request.getServletPath());
                System.err.println("\t        PathInfo: " + request.getPathInfo());
                System.err.println("\t        RealPath: " + this.getServletConfig().getServletContext().getRealPath(jspUri));
                System.err.println("\t      RequestURI: " + request.getRequestURI());
                System.err.println("\t     QueryString: " + request.getQueryString());
                System.err.println("\t  Request Params: ");
                Enumeration e10 = request.getParameterNames();
                while (e10.hasMoreElements()) {
                    String name = (String)e10.nextElement();
                    System.err.println("\t\t " + name + " = " + request.getParameter(name));
                }
            }
            this.serviceJspFile(request, response, jspUri, null, precompile);
        }
        catch (RuntimeException e11) {
            throw e11;
        }
        catch (ServletException e12) {
            throw e12;
        }
        catch (Exception e13) {
            throw new ServletException(e13);
        }
        catch (Throwable t2) {
            this.unknownException(response, t2);
        }
    }

    private void serviceJspFile(HttpServletRequest request, HttpServletResponse response, String jspUri, Throwable exception, boolean precompile) throws ServletException, IOException {
        boolean isErrorPage = exception != null;
        JspServletWrapper wrapper = (JspServletWrapper)this.jsps.get(jspUri);
        if (wrapper == null) {
            wrapper = new JspServletWrapper(jspUri, isErrorPage);
            this.jsps.put(jspUri, wrapper);
        }
        wrapper.service(request, response, precompile);
    }

    final void unknownException(HttpServletResponse response, Throwable t2) {
        block10: {
            PrintWriter writer = new PrintWriter(System.err, true);
            if (this.options.sendErrorToClient()) {
                try {
                    response.setContentType("text/html");
                    writer = response.getWriter();
                }
                catch (IOException iOException) {
                    writer = new PrintWriter(System.err, true);
                }
            }
            writer.println(Constants.getString("jsp.error.unknownException"));
            if (this.options.sendErrorToClient()) {
                writer.println("<pre>");
            }
            if (t2 instanceof JasperException) {
                Throwable x2 = ((JasperException)t2).getRootCause();
                (x2 != null ? x2 : t2).printStackTrace(writer);
            } else {
                t2.printStackTrace(writer);
            }
            if (this.options.sendErrorToClient()) {
                writer.println("</pre>");
            }
            if (this.options.sendErrorToClient()) break block10;
            try {
                String message = t2.getMessage();
                if (message == null) {
                    message = "No detailed message";
                }
                response.sendError(500, message);
            }
            catch (IOException iOException) {}
        }
    }

    class JspServletWrapper {
        HttpJspPage theServlet;
        String jspUri;
        boolean isErrorPage;

        JspServletWrapper(String jspUri, boolean isErrorPage) {
            this.jspUri = jspUri;
            this.isErrorPage = isErrorPage;
            this.theServlet = null;
        }

        public void destroy() {
            if (this.theServlet != null) {
                this.theServlet.destroy();
            }
        }

        private void load() throws JasperException, ServletException {
            try {
                Class servletClass = JspServlet.this.loader.getJspServletClass(this.jspUri);
                this.destroy();
                this.theServlet = (HttpJspPage)servletClass.newInstance();
            }
            catch (Exception ex2) {
                throw new JasperException(ex2);
            }
            this.theServlet.init(JspServlet.this.config);
            if (this.theServlet instanceof HttpJspBase) {
                ((HttpJspBase)this.theServlet).setClassLoader(JspServlet.this.parentClassLoader);
            }
        }

        private void loadIfNecessary(HttpServletRequest req, HttpServletResponse res) throws JasperException, ServletException, FileNotFoundException {
            String accordingto;
            String cp2 = (String)JspServlet.this.context.getAttribute("org.apache.tomcat.jsp_classpath");
            if (cp2 == null || cp2.equals("")) {
                accordingto = "according to the init parameter is";
                cp2 = JspServlet.this.options.getClassPath();
            } else {
                accordingto = "according to the Servlet Engine is";
            }
            Constants.message("jsp.message.cp_is", new Object[]{accordingto, cp2}, 2);
            if (JspServlet.this.loader.loadJSP(this.jspUri, cp2, this.isErrorPage, req, res) || this.theServlet == null) {
                this.load();
            }
        }

        public void service(HttpServletRequest request, HttpServletResponse response, boolean precompile) throws ServletException, IOException, FileNotFoundException {
            try {
                this.loadIfNecessary(request, response);
                if (precompile) {
                    return;
                }
                this.theServlet.service(request, response);
            }
            catch (FileNotFoundException ex2) {
                response.sendError(404, Constants.getString("jsp.error.file.not.found", new Object[]{ex2.getMessage()}));
                return;
            }
        }
    }
}

