/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ServerSession;
import org.apache.tomcat.core.SessionContextImpl;
import org.apache.tomcat.util.StringManager;

public class ApplicationSession
implements HttpSession {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.core");
    private Hashtable values = new Hashtable();
    private String id;
    private ServerSession serverSession;
    private Context context;
    private long creationTime;
    private long thisAccessTime = this.creationTime = System.currentTimeMillis();
    private long lastAccessed = this.creationTime;
    private int inactiveInterval = -1;
    private boolean valid = true;

    ApplicationSession(String id, ServerSession serverSession, Context context) {
        this.serverSession = serverSession;
        this.context = context;
        this.id = id;
        this.inactiveInterval = context.getSessionTimeOut();
        if (this.inactiveInterval != -1) {
            this.inactiveInterval *= 60;
        }
    }

    void accessed() {
        this.lastAccessed = this.thisAccessTime;
        this.thisAccessTime = System.currentTimeMillis();
        this.validate();
    }

    public Object getAttribute(String name) {
        if (!this.valid) {
            String msg = this.sm.getString("applicationSession.session.ise");
            throw new IllegalStateException(msg);
        }
        if (name == null) {
            String msg = this.sm.getString("applicationSession.value.iae");
            throw new IllegalArgumentException(msg);
        }
        return this.values.get(name);
    }

    public Enumeration getAttributeNames() {
        if (!this.valid) {
            String msg = this.sm.getString("applicationSession.session.ise");
            throw new IllegalStateException(msg);
        }
        Hashtable valuesClone = (Hashtable)this.values.clone();
        return valuesClone.keys();
    }

    public long getCreationTime() {
        if (this.valid) {
            return this.creationTime;
        }
        String msg = this.sm.getString("applicationSession.session.ise");
        throw new IllegalStateException(msg);
    }

    public String getId() {
        if (this.valid) {
            return this.id;
        }
        String msg = this.sm.getString("applicationSession.session.ise");
        throw new IllegalStateException(msg);
    }

    public long getLastAccessedTime() {
        if (this.valid) {
            return this.lastAccessed;
        }
        String msg = this.sm.getString("applicationSession.session.ise");
        throw new IllegalStateException(msg);
    }

    public int getMaxInactiveInterval() {
        if (!this.valid) {
            String msg = this.sm.getString("applicationSession.session.ise");
            throw new IllegalStateException(msg);
        }
        return this.inactiveInterval;
    }

    public HttpSessionContext getSessionContext() {
        return new SessionContextImpl();
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public String[] getValueNames() {
        Enumeration e10 = this.getAttributeNames();
        Vector names = new Vector();
        while (e10.hasMoreElements()) {
            names.addElement(e10.nextElement());
        }
        Object[] valueNames = new String[names.size()];
        names.copyInto(valueNames);
        return valueNames;
    }

    public void invalidate() {
        this.serverSession.removeApplicationSession(this.context);
        Enumeration enumeration = this.values.keys();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            this.removeValue(name);
        }
        this.valid = false;
    }

    public boolean isNew() {
        if (!this.valid) {
            String msg = this.sm.getString("applicationSession.session.ise");
            throw new IllegalStateException(msg);
        }
        return this.thisAccessTime == this.creationTime;
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        if (!this.valid) {
            String msg = this.sm.getString("applicationSession.session.ise");
            throw new IllegalStateException(msg);
        }
        if (name == null) {
            String msg = this.sm.getString("applicationSession.value.iae");
            throw new IllegalArgumentException(msg);
        }
        Object o2 = this.values.get(name);
        if (o2 instanceof HttpSessionBindingListener) {
            HttpSessionBindingEvent e10 = new HttpSessionBindingEvent(this, name);
            ((HttpSessionBindingListener)o2).valueUnbound(e10);
        }
        this.values.remove(name);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        if (!this.valid) {
            String msg = this.sm.getString("applicationSession.session.ise");
            throw new IllegalStateException(msg);
        }
        if (name == null) {
            String msg = this.sm.getString("applicationSession.value.iae");
            throw new IllegalArgumentException(msg);
        }
        this.removeValue(name);
        if (value != null && value instanceof HttpSessionBindingListener) {
            HttpSessionBindingEvent e10 = new HttpSessionBindingEvent(this, name);
            ((HttpSessionBindingListener)value).valueBound(e10);
        }
        this.values.put(name, value);
    }

    public void setMaxInactiveInterval(int interval) {
        if (!this.valid) {
            String msg = this.sm.getString("applicationSession.session.ise");
            throw new IllegalStateException(msg);
        }
        this.inactiveInterval = interval;
    }

    void validate() {
        int thisInterval;
        if (this.inactiveInterval != -1 && (thisInterval = (int)(System.currentTimeMillis() - this.lastAccessed) / 1000) > this.inactiveInterval) {
            this.invalidate();
        }
    }
}

