/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.IOException;
import javax.servlet.ServletInputStream;

public abstract class BufferedServletInputStream
extends ServletInputStream {
    private int bytesRead = 0;
    private int limit = -1;

    public abstract int doRead() throws IOException;

    public abstract int doRead(byte[] var1, int var2, int var3) throws IOException;

    public int read() throws IOException {
        if (this.limit != -1) {
            if (this.bytesRead < this.limit) {
                ++this.bytesRead;
                return this.doRead();
            }
            return -1;
        }
        return this.doRead();
    }

    public int read(byte[] b10) throws IOException {
        return this.read(b10, 0, b10.length);
    }

    public int read(byte[] b10, int off, int len) throws IOException {
        if (this.limit != -1) {
            int numRead;
            if (this.bytesRead == this.limit) {
                return -1;
            }
            if (this.bytesRead + len > this.limit) {
                len = this.limit - this.bytesRead;
            }
            if ((numRead = this.doRead(b10, off, len)) > 0) {
                this.bytesRead += numRead;
            }
            return numRead;
        }
        return this.doRead(b10, off, len);
    }

    public String readLine() throws IOException {
        byte[] buf = new byte[1024];
        int count = this.readLine(buf, 0, buf.length);
        if (count >= 0) {
            return new String(buf, 0, count);
        }
        return "";
    }

    public void setLimit(int limit) {
        this.bytesRead = 0;
        this.limit = limit;
    }
}

