/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import org.apache.tomcat.core.ResponseImpl;
import org.apache.tomcat.util.StringManager;

public abstract class BufferedServletOutputStream
extends ServletOutputStream {
    protected StringManager sm = StringManager.getManager("org.apache.tomcat.core");
    protected boolean usingWriter = false;
    protected static final int DEFAULT_BUFFER_SIZE = 8192;
    protected byte[] buffer = new byte[8192];
    protected int bufferSize = 8192;
    protected int bufferCount = 0;
    protected int totalCount = 0;
    protected boolean committed = false;
    protected boolean closed = false;
    ResponseImpl response;

    protected BufferedServletOutputStream() {
    }

    public void close() throws IOException {
        this.reallyFlush();
        this.closed = true;
        this.endResponse();
    }

    protected abstract void doWrite(byte[] var1, int var2, int var3) throws IOException;

    protected void endResponse() throws IOException {
    }

    public void flush() throws IOException {
        if (!this.usingWriter) {
            this.reallyFlush();
        }
    }

    public int getBufferSize() {
        return this.buffer.length;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public boolean isContentWritten() {
        return this.totalCount > 0;
    }

    public void print(String s2) throws IOException {
        if (s2 == null) {
            s2 = "null";
        }
        int len = s2.length();
        int i2 = 0;
        while (i2 < len) {
            char c10 = s2.charAt(i2);
            if ((c10 & 0xFF00) != 0) {
                String errMsg = this.sm.getString("servletOutputStream.fmt.not_iso8859_1", new Object[]{new Character(c10)});
                throw new IOException(errMsg);
            }
            this.write(c10);
            ++i2;
        }
    }

    public void reallyFlush() throws IOException {
        block3: {
            try {
                if (!this.committed) {
                    this.sendHeaders();
                    this.committed = true;
                }
                if (this.bufferCount <= 0) break block3;
                this.doWrite(this.buffer, 0, this.bufferCount);
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.bufferCount = 0;
                throw throwable;
            }
        }
        Object var2_1 = null;
        this.bufferCount = 0;
    }

    public void recycle() {
        this.bufferCount = 0;
        this.totalCount = 0;
        this.committed = false;
        this.closed = false;
    }

    public void reset() throws IllegalStateException {
        if (this.isCommitted()) {
            String msg = this.sm.getString("servletOutputStreamImpl.reset.ise");
            throw new IllegalStateException(msg);
        }
        this.bufferCount = 0;
        this.totalCount = 0;
    }

    protected void sendHeaders() throws IOException {
        this.response.writeHeaders();
    }

    public void setBufferSize(int size) throws IllegalStateException {
        if (size <= this.bufferSize) {
            return;
        }
        int eightK = 8192;
        if (size % eightK != 0) {
            size = (size / eightK + 1) * eightK;
        }
        this.bufferSize = size;
        this.buffer = new byte[size];
    }

    public void setResponse(ResponseImpl response) {
        this.response = response;
    }

    public void setUsingWriter(boolean uwrt) {
        this.usingWriter = uwrt;
    }

    public void write(int i2) throws IOException {
        if (this.closed) {
            return;
        }
        this.buffer[this.bufferCount] = (byte)i2;
        ++this.bufferCount;
        ++this.totalCount;
        if (this.bufferCount >= this.buffer.length) {
            this.reallyFlush();
        }
    }

    public void write(byte[] b10) throws IOException {
        this.write(b10, 0, b10.length);
    }

    public void write(byte[] b10, int off, int len) throws IOException {
        if (this.closed) {
            return;
        }
        if (len < 0) {
            String msg = this.sm.getString("servletOutputStreamImpl.write.iae");
            throw new IllegalArgumentException(msg);
        }
        int i2 = 0;
        while (i2 < len) {
            this.write(b10[off + i2]);
            ++i2;
        }
    }
}

