/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.LookupResult;
import org.apache.tomcat.core.RequestMapper;
import org.apache.tomcat.core.ServletLoader;
import org.apache.tomcat.core.ServletWrapper;

public class Container {
    private Context context;
    private ServletLoader servletLoader;
    private Hashtable servlets = new Hashtable();
    private Hashtable prefixMappedServlets = new Hashtable();
    private Hashtable extensionMappedServlets = new Hashtable();
    private Hashtable pathMappedServlets = new Hashtable();
    private ServletWrapper defaultServlet = null;
    private URL servletBase = null;
    private Vector classPaths = new Vector();
    private Vector libPaths = new Vector();

    Container(Context context) {
        this.context = context;
    }

    public void addClassPath(String path) {
        this.classPaths.addElement(path);
    }

    public void addJSP(String name, String path) {
        this.addJSP(name, null, path);
    }

    public void addJSP(String name, String path, String description) {
        ServletWrapper wrapper = new ServletWrapper(this);
        wrapper.setServletName(name);
        wrapper.setServletDescription(description);
        wrapper.setPath(path);
        this.servlets.put(name, wrapper);
    }

    public void addLibPath(String path) {
        this.libPaths.addElement(path);
    }

    public void addMapping(String servletName, String path) {
        ServletWrapper sw = (ServletWrapper)this.servlets.get(servletName);
        if (sw == null) {
            if (!servletName.startsWith("/")) {
                this.addServlet(servletName, null, servletName, null);
            } else {
                this.addJSP(servletName, servletName);
            }
            sw = (ServletWrapper)this.servlets.get(servletName);
        }
        path = path.trim();
        if (sw != null && path.length() > 0) {
            if (path.startsWith("/") && path.endsWith("/*")) {
                this.prefixMappedServlets.put(path, sw);
            } else if (path.startsWith("*.")) {
                this.extensionMappedServlets.put(path, sw);
            } else if (!path.equals("/")) {
                this.pathMappedServlets.put(path, sw);
            } else {
                this.defaultServlet = sw;
            }
        }
    }

    public void addServlet(String name, Class clazz) {
        this.addServlet(name, null, null, clazz);
    }

    public void addServlet(String name, Class clazz, String description) {
        this.addServlet(name, description, null, clazz);
    }

    public void addServlet(String name, String className) {
        this.addServlet(name, null, className, null);
    }

    public void addServlet(String name, String className, String description) {
        this.addServlet(name, description, className, null);
    }

    private void addServlet(String name, String description, String className, Class clazz) {
        if (this.servlets.get(name) != null) {
            this.removeServlet(name);
            this.removeServletByName(name);
        }
        ServletWrapper wrapper = new ServletWrapper(this);
        wrapper.setServletName(name);
        wrapper.setServletDescription(description);
        if (className != null) {
            wrapper.setServletClass(className);
        }
        if (clazz != null) {
            wrapper.setServletClass(clazz);
        }
        this.servlets.put(name, wrapper);
    }

    boolean containsJSP(String path) {
        ServletWrapper[] sw = this.getServletsByPath(path);
        return sw != null && sw.length > 0;
    }

    boolean containsMapping(String mapping) {
        return this.prefixMappedServlets.containsKey(mapping = mapping.trim()) || this.extensionMappedServlets.containsKey(mapping) || this.pathMappedServlets.containsKey(mapping);
    }

    boolean containsServlet(String className) {
        ServletWrapper[] sw = this.getServlets(className);
        return sw != null && sw.length > 0;
    }

    boolean containsServletByName(String name) {
        return this.servlets.containsKey(name);
    }

    public Enumeration getClassPaths() {
        return this.classPaths.elements();
    }

    Context getContext() {
        return this.context;
    }

    public Enumeration getLibPaths() {
        return this.libPaths.elements();
    }

    ServletLoader getLoader() {
        if (this.servletLoader == null) {
            this.servletLoader = new ServletLoader(this);
        }
        return this.servletLoader;
    }

    public URL getServletBase() {
        return this.servletBase;
    }

    private ServletWrapper[] getServlets(String name) {
        Vector<ServletWrapper> servletWrappers = new Vector<ServletWrapper>();
        Enumeration enumeration = this.servlets.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            ServletWrapper sw = (ServletWrapper)this.servlets.get(key);
            if (sw.getServletClass() == null || !sw.getServletClass().equals(name)) continue;
            servletWrappers.addElement(sw);
        }
        Object[] wrappers = new ServletWrapper[servletWrappers.size()];
        servletWrappers.copyInto(wrappers);
        return wrappers;
    }

    ServletWrapper[] getServletsByPath(String path) {
        Vector<ServletWrapper> servletWrappers = new Vector<ServletWrapper>();
        Enumeration enumeration = this.servlets.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            ServletWrapper sw = (ServletWrapper)this.servlets.get(key);
            if (sw.getPath() == null || !sw.getPath().equals(path)) continue;
            servletWrappers.addElement(sw);
        }
        Object[] wrappers = new ServletWrapper[servletWrappers.size()];
        servletWrappers.copyInto(wrappers);
        return wrappers;
    }

    ServletWrapper loadServlet(String servletClassName) {
        ServletWrapper wrapper = new ServletWrapper(this);
        wrapper.setServletClass(servletClassName);
        this.servlets.put(servletClassName, wrapper);
        return wrapper;
    }

    LookupResult lookupServlet(String lookupPath) {
        RequestMapper requestMapper = new RequestMapper(this);
        requestMapper.setPathMaps(this.pathMappedServlets);
        requestMapper.setPrefixMaps(this.prefixMappedServlets);
        requestMapper.setExtensionMaps(this.extensionMappedServlets);
        LookupResult lookupResult = requestMapper.lookupServlet(lookupPath);
        if (lookupResult == null) {
            ServletWrapper wrapper = null;
            wrapper = this.defaultServlet != null ? this.defaultServlet : (ServletWrapper)this.servlets.get("default");
            String servletPath = "";
            String pathInfo = lookupPath;
            lookupResult = new LookupResult(wrapper, servletPath, pathInfo);
        }
        return lookupResult;
    }

    LookupResult lookupServletAndLoadByName(String servletName) {
        ServletWrapper wrapper = new ServletWrapper(this);
        wrapper.setServletClass(servletName);
        this.servlets.put(servletName, wrapper);
        return new LookupResult(wrapper, null, "");
    }

    LookupResult lookupServletByName(String servletName) {
        LookupResult lookupResult = null;
        ServletWrapper wrapper = (ServletWrapper)this.servlets.get(servletName);
        if (wrapper != null) {
            lookupResult = new LookupResult(wrapper, null, "");
        }
        return lookupResult;
    }

    void removeJSP(String path) {
        this.removeServlets(this.getServletsByPath(path));
    }

    void removeMapping(String mapping) {
        mapping = mapping.trim();
        this.prefixMappedServlets.remove(mapping);
        this.extensionMappedServlets.remove(mapping);
        this.pathMappedServlets.remove(mapping);
    }

    void removeServlet(String className) {
        this.removeServlets(this.getServlets(className));
    }

    void removeServletByName(String servletName) {
        ServletWrapper wrapper = (ServletWrapper)this.servlets.get(servletName);
        if (wrapper != null) {
            ServletWrapper[] wa = new ServletWrapper[]{wrapper};
            this.removeServlets(wa);
        }
    }

    private void removeServlets(ServletWrapper[] sw) {
        if (sw != null) {
            int i2 = 0;
            while (i2 < sw.length) {
                String key;
                Enumeration enumeration;
                if (this.prefixMappedServlets.contains(sw[i2])) {
                    enumeration = this.prefixMappedServlets.keys();
                    while (enumeration.hasMoreElements()) {
                        key = (String)enumeration.nextElement();
                        if (!this.prefixMappedServlets.get(key).equals(sw[i2])) continue;
                        this.prefixMappedServlets.remove(key);
                    }
                }
                if (this.extensionMappedServlets.contains(sw[i2])) {
                    enumeration = this.extensionMappedServlets.keys();
                    while (enumeration.hasMoreElements()) {
                        key = (String)enumeration.nextElement();
                        if (!this.extensionMappedServlets.get(key).equals(sw[i2])) continue;
                        this.extensionMappedServlets.remove(key);
                    }
                }
                if (this.pathMappedServlets.contains(sw[i2])) {
                    enumeration = this.pathMappedServlets.keys();
                    while (enumeration.hasMoreElements()) {
                        key = (String)enumeration.nextElement();
                        if (!this.pathMappedServlets.get(key).equals(sw[i2])) continue;
                        this.pathMappedServlets.remove(key);
                    }
                }
                this.servlets.remove(sw[i2].getServletName());
                ++i2;
            }
        }
    }

    public void setServletBase(URL servletBase) {
        this.servletBase = servletBase;
    }

    public void setServletInitParams(String name, Hashtable initParams) {
        ServletWrapper wrapper = (ServletWrapper)this.servlets.get(name);
        if (wrapper != null) {
            wrapper.setInitArgs(initParams);
        }
    }

    void shutdown() {
        Enumeration enumeration = this.servlets.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            ServletWrapper wrapper = (ServletWrapper)this.servlets.get(key);
            this.servlets.remove(key);
            wrapper.destroy();
        }
    }
}

