/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.RequestImpl;
import org.apache.tomcat.core.ResponseImpl;
import org.apache.tomcat.core.Server;
import org.apache.tomcat.util.StringManager;

public class ContextManager
implements Server {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.core");
    private Context defaultContext;
    private Hashtable contexts = new Hashtable();
    private Hashtable contextMaps = new Hashtable();
    private String serverInfo = null;
    String hostname;
    int port;

    public Context addContext(String path, URL docBase) {
        if (path == null) {
            String msg = this.sm.getString("server.defaultContext.path.npe");
            throw new NullPointerException(msg);
        }
        if ((path = path.trim()).length() > 0 && docBase == null) {
            String msg = this.sm.getString("server.defaultContext.docBase.npe");
            throw new NullPointerException(msg);
        }
        if (this.contexts.get(path) != null) {
            String msg = this.sm.getString("server.createctx.existname", path);
            throw new IllegalStateException(msg);
        }
        if (this.contextMaps.get(path) != null) {
            String msg = this.sm.getString("server.createctx.existmap", path);
            throw new IllegalStateException(msg);
        }
        Context context = new Context(this, path);
        if (docBase != null) {
            context.setDocumentBase(docBase);
        }
        if (path.length() == 0) {
            this.contexts.put("default", context);
        } else {
            this.contexts.put(path, context);
            this.contextMaps.put(path, context);
        }
        return context;
    }

    public Context getContext(String name) {
        return (Context)this.contexts.get(name);
    }

    public Context getContextByPath(String path) {
        String realPath = path;
        Context ctx = null;
        do {
            if ((ctx = (Context)this.contextMaps.get(path)) != null) continue;
            int i2 = path.lastIndexOf(47);
            if (i2 <= -1 || path.length() <= 1) break;
            if ((path = path.substring(0, i2)).length() != 0) continue;
            path = "/";
        } while (ctx == null);
        if (ctx == null) {
            ctx = this.defaultContext;
        }
        return ctx;
    }

    public Enumeration getContextNames() {
        return this.contexts.keys();
    }

    public Context getDefaultContext() {
        return this.defaultContext;
    }

    public URL getDocumentBase() {
        return this.defaultContext.getDocumentBase();
    }

    public String getHostName() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    public void removeContext(String name) {
        if (name.equals("default")) {
            throw new IllegalArgumentException(name);
        }
        Context context = (Context)this.contexts.get(name);
        if (context != null) {
            context.shutdown();
            this.contexts.remove(name);
            this.contextMaps.remove(name);
        }
    }

    public void service(RequestImpl rrequest, ResponseImpl rresponse) {
        try {
            rrequest.setResponse(rresponse);
            rresponse.setRequest(rrequest);
            if (rresponse.getStatus() >= 400) {
                rresponse.finish();
                rrequest.recycle();
                rresponse.recycle();
                return;
            }
            String path = rrequest.getRequestURI();
            Context ctx = this.getContextByPath(path);
            String ctxPath = ctx.getPath();
            String pathInfo = path.substring(ctxPath.length(), path.length());
            if (rrequest.getProtocol() == null) {
                rresponse.setOmitHeaders(true);
            }
            ctx.handleRequest(rrequest, rresponse);
            rresponse.finish();
            rresponse.endResponse();
        }
        catch (Exception e10) {
            System.out.println("HANDLER THREAD PROBLEM: " + e10);
            e10.printStackTrace();
        }
    }

    public void setDefaultContext(Context ctx) {
        this.defaultContext = ctx;
    }

    public void setDocumentBase(URL docBase) {
        this.defaultContext.setDocumentBase(docBase);
    }

    public void setHostName(String host) {
        this.hostname = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setServerInfo(String serverInfo) {
        this.serverInfo = serverInfo;
    }
}

