/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomcat.core.Constants;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ServletContextFacade;
import org.apache.tomcat.util.FilePathUtil;
import org.apache.tomcat.util.MimeMap;
import org.apache.tomcat.util.StringManager;
import org.apache.tomcat.util.URLUtil;

public class DefaultServlet
extends HttpServlet {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.core");
    private ServletContextFacade facade;
    private String servletInfo = "DefaultServlet";
    private Context context;
    private MimeMap mimeTypes;
    private String datePattern = "EEE, dd MMM yyyyy HH:mm z";
    private DateFormat dateFormat = new SimpleDateFormat(this.datePattern);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        URL url;
        String pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
        String requestURI = (String)request.getAttribute("javax.servlet.include.request_uri");
        if (pathInfo == null) {
            pathInfo = request.getPathInfo();
        }
        if (requestURI == null) {
            requestURI = request.getRequestURI();
        }
        if ((url = this.getServletContext().getResource(pathInfo)) != null) {
            if (url.getProtocol().equals("war") && this.context.isWARExpanded()) {
                String s2 = String.valueOf(this.context.getWARDir().toString()) + pathInfo;
                url = URLUtil.resolve(s2);
            }
            if (url.getProtocol().equalsIgnoreCase("file")) {
                File f2 = new File(url.getFile());
                if (f2.exists()) {
                    this.processFile(f2, url, request, response);
                } else {
                    response.sendError(404, "File Not Found: " + requestURI);
                }
            } else if (url.getProtocol().equalsIgnoreCase("war")) {
                String documentBase = this.context.getDocumentBase().toString();
                if (documentBase.endsWith("/")) {
                    documentBase = documentBase.substring(0, documentBase.length() - 1);
                }
                URL mappedURL = new URL(String.valueOf(documentBase) + "!" + pathInfo);
                this.serveURL(mappedURL, request, response);
            } else {
                this.serveURL(url, request, response);
            }
        } else {
            System.out.println("Got null URL: " + url);
            response.sendError(404, "File Not Found<br>" + requestURI);
        }
    }

    public String getServletInfo() {
        return this.servletInfo;
    }

    private String getWelcomeFile(File file) {
        String welcomeFile = null;
        Enumeration enumeration = this.context.getWelcomeFiles();
        while (enumeration.hasMoreElements()) {
            File f2;
            String fileName = (String)enumeration.nextElement();
            if (fileName == null || fileName.trim().length() <= 0 || !(f2 = new File(file, fileName)).exists()) continue;
            welcomeFile = fileName;
            break;
        }
        return welcomeFile;
    }

    public void init() throws ServletException {
        this.facade = (ServletContextFacade)this.getServletContext();
        this.context = this.facade.getRealContext();
        this.mimeTypes = this.context.getMimeMap();
    }

    private boolean isDirMasked(String basedir, String subdir) {
        int i2 = 0;
        while (i2 < Constants.Context.MASKED_DIR.length) {
            if (subdir.equalsIgnoreCase(Constants.Context.MASKED_DIR[i2])) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private boolean isFileMasked(String docBase, String requestedFile) {
        int i2 = 0;
        while (i2 < Constants.Context.MASKED_DIR.length) {
            String maskFile = Constants.Context.MASKED_DIR[i2];
            if (requestedFile.toLowerCase().startsWith(FilePathUtil.patch(String.valueOf(docBase) + maskFile).toLowerCase())) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private void processFile(File file, URL url, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String requestURI = (String)request.getAttribute("javax.servlet.include.request_uri");
        if (requestURI == null) {
            requestURI = request.getRequestURI();
        }
        String absPath = file.getAbsolutePath();
        String docBase = "";
        if (this.context.getDocumentBase().getProtocol().equalsIgnoreCase("war") && this.context.isWARExpanded()) {
            String s2 = this.context.getWARDir().getAbsolutePath();
            docBase = FilePathUtil.patch(s2);
        } else {
            docBase = this.context.getDocumentBase().getFile();
        }
        absPath = FilePathUtil.patch(absPath);
        if (!docBase.endsWith("/")) {
            docBase = String.valueOf(docBase) + "/";
        }
        if (this.isFileMasked(docBase, absPath)) {
            response.sendError(404);
            return;
        }
        if (file.isDirectory()) {
            String welcomeFile = this.getWelcomeFile(file);
            if (welcomeFile != null) {
                if (requestURI.endsWith("/")) {
                    int index;
                    String path = requestURI;
                    String contextPath = this.context.getPath();
                    if (contextPath.length() == 0) {
                        contextPath = "/";
                    }
                    if ((index = requestURI.indexOf(contextPath)) > -1) {
                        path = requestURI.substring(index + contextPath.length());
                    }
                    if (!path.startsWith("/")) {
                        path = "/" + path;
                    }
                    ServletContext context = this.getServletContext().getContext(contextPath);
                    RequestDispatcher rd = context.getRequestDispatcher(String.valueOf(path) + welcomeFile);
                    rd.forward(request, response);
                } else {
                    boolean inInclude = false;
                    Object o2 = request.getAttribute("javax.servlet.dispatch.request_uri");
                    if (o2 != null) {
                        inInclude = true;
                    }
                    if (!inInclude) {
                        response.sendRedirect(String.valueOf(requestURI) + "/");
                    }
                }
            } else {
                this.serveDir(file, request, response);
            }
        } else if (!url.getFile().endsWith("/") && !url.getFile().endsWith("\\")) {
            this.serveFile(file, request, response);
        } else {
            response.sendError(404, "File Not Found<br>" + requestURI);
        }
    }

    private void serveDir(File file, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String fileName;
        File f2;
        Enumeration e10;
        boolean shaderow = false;
        String absPath = file.getAbsolutePath();
        String canPath = file.getCanonicalPath();
        absPath = FilePathUtil.patch(absPath);
        if (File.separatorChar == '\\') {
            if (!absPath.equalsIgnoreCase(canPath)) {
                response.sendError(404);
                return;
            }
        } else if (absPath.indexOf("..") != -1) {
            response.sendError(404);
            return;
        }
        Vector<File> dirs = new Vector<File>();
        Vector<File> files = new Vector<File>();
        String[] fileNames = file.list();
        String docBase = "";
        if (this.context.getDocumentBase().getProtocol().equalsIgnoreCase("war") && this.context.isWARExpanded()) {
            String s2 = this.context.getWARDir().getAbsolutePath();
            docBase = FilePathUtil.patch(s2);
        } else {
            docBase = this.context.getDocumentBase().getFile();
        }
        if (!docBase.endsWith("/")) {
            docBase = String.valueOf(docBase) + "/";
        }
        int i2 = 0;
        while (i2 < fileNames.length) {
            String fileName2 = fileNames[i2];
            File f3 = new File(file, fileName2);
            if (!f3.isDirectory() || !this.isDirMasked(docBase, fileName2)) {
                if (f3.isDirectory()) {
                    dirs.addElement(f3);
                } else {
                    files.addElement(f3);
                }
            }
            ++i2;
        }
        String requestURI = request.getRequestURI();
        String slashedRequestURI = null;
        slashedRequestURI = requestURI.endsWith("/") ? requestURI : String.valueOf(requestURI) + "/";
        boolean inInclude = false;
        Object o2 = request.getAttribute("javax.servlet.dispatch.request_uri");
        if (o2 != null) {
            inInclude = true;
        }
        StringBuffer buf = new StringBuffer();
        if (!inInclude) {
            response.setContentType("text/html");
            buf.append("<html>\r\n");
            buf.append("<head>\r\n");
            buf.append("<title>Directory Listing for: " + requestURI);
            buf.append("</title>\r\n</head><body bgcolor=white>\r\n");
        }
        buf.append("<table width=90% cellspacing=0 ");
        buf.append("cellpadding=5 align=center>");
        buf.append("<tr><td colspan=3><font size=+2><strong>");
        buf.append("Directory Listing for: " + requestURI);
        buf.append("</strong></td></tr>\r\n");
        if (!requestURI.equals("/")) {
            buf.append("<tr><td colspan=3 bgcolor=#ffffff>");
            String toPath = requestURI;
            if (toPath.endsWith("/")) {
                toPath = toPath.substring(0, toPath.length() - 1);
            }
            if ((toPath = toPath.substring(0, toPath.lastIndexOf("/"))).length() == 0) {
                toPath = "/";
            }
            buf.append("<a href=\"" + toPath + "\"><tt>Up to: " + toPath);
            buf.append("</tt></a></td></tr>\r\n");
        }
        if (dirs.size() > 0) {
            buf.append("<tr><td colspan=3 bgcolor=#cccccc>");
            buf.append("<font size=+2><strong>Subdirectories:</strong>\r\n");
            buf.append("</font></td></tr>\r\n");
            e10 = dirs.elements();
            while (e10.hasMoreElements()) {
                f2 = (File)e10.nextElement();
                fileName = f2.getName();
                buf.append("<tr");
                if (shaderow) {
                    buf.append(" bgcolor=#eeeeee");
                    shaderow = false;
                } else {
                    shaderow = true;
                }
                buf.append("><td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                buf.append("<tt><a href=\"" + slashedRequestURI + fileName + "\">" + fileName + "/</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + "</tt>\r\n");
                buf.append("</td><td><tt>&nbsp;&nbsp;</tt></td>");
                buf.append("<td align=right><tt>");
                buf.append(this.dateFormat.format(new Date(f2.lastModified())));
                buf.append("</tt></td></tr>\r\n");
            }
            buf.append("\r\n");
        }
        shaderow = false;
        buf.append("<tr><td colspan=3 bgcolor=#ffffff>&nbsp;</td></tr>");
        if (files.size() > 0) {
            buf.append("<tr><td colspan=4 bgcolor=#cccccc>");
            buf.append("<font size=+2><strong>Files:</strong>");
            buf.append("</font></td></tr>");
            e10 = files.elements();
            while (e10.hasMoreElements()) {
                buf.append("<tr");
                if (shaderow) {
                    buf.append(" bgcolor=#eeeeee");
                    shaderow = false;
                } else {
                    shaderow = true;
                }
                buf.append("><td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n");
                f2 = (File)e10.nextElement();
                fileName = f2.getName();
                buf.append("<tt><a href=\"" + slashedRequestURI + fileName + "\">" + fileName + "</a>");
                buf.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<tt>");
                buf.append("</td></td>\r\n<td align=right><tt>");
                int filesize = (int)f2.length();
                int leftside = filesize / 1024;
                int rightside = filesize % 1024 / 103;
                if (leftside == 0 && rightside == 0 && filesize != 0) {
                    rightside = 1;
                }
                buf.append(String.valueOf(leftside) + "." + rightside + " KB");
                buf.append("</tt></td>");
                buf.append("<td align=right><tt>");
                buf.append(this.dateFormat.format(new Date(f2.lastModified())));
                buf.append("</tt></td></tr>\r\n");
            }
            buf.append("\r\n");
        }
        buf.append("<tr><td colspan=3 bgcolor=#ffffff>&nbsp;</td></tr>");
        buf.append("<tr><td colspan=3 bgcolor=#cccccc>");
        buf.append("<font size=-1>");
        buf.append("Tomcat Web Server");
        buf.append(" v");
        buf.append("2.2");
        buf.append("</font></td></tr></table>");
        if (!inInclude) {
            buf.append("</body></html>\r\n");
        }
        String output = buf.toString();
        byte[] bytes = output.getBytes();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.serveStream(in, request, response);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void serveFile(File file, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String mimeType;
        String absPath = file.getAbsolutePath();
        String canPath = file.getCanonicalPath();
        absPath = FilePathUtil.patch(absPath);
        if (File.separatorChar == '\\') {
            if (!absPath.equalsIgnoreCase(canPath)) {
                response.sendError(404);
                return;
            }
        } else if (absPath.indexOf("..") != -1) {
            response.sendError(404);
            return;
        }
        if ((mimeType = this.mimeTypes.getContentTypeFor(file.getName())) == null) {
            mimeType = "text/plain";
        }
        response.setContentType(mimeType);
        response.setContentLength((int)file.length());
        response.setDateHeader("Last-Modified", file.lastModified());
        FileInputStream in = new FileInputStream(file);
        try {
            try {
                this.serveStream(in, request, response);
            }
            catch (FileNotFoundException fileNotFoundException) {
                String requestURI = (String)request.getAttribute("javax.servlet.include.request_uri");
                if (requestURI == null) {
                    requestURI = request.getRequestURI();
                }
                response.sendError(404, "File Not Found<br>" + requestURI);
            }
            catch (SocketException socketException) {
                Object var9_9 = null;
                if (in == null) return;
                in.close();
                return;
            }
            Object var9_10 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (in == null) throw throwable;
            in.close();
            throw throwable;
        }
        in.close();
    }

    private void serveStream(InputStream in, HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            ServletOutputStream out = response.getOutputStream();
            this.serveStreamAsStream(in, out);
        }
        catch (IllegalStateException illegalStateException) {
            PrintWriter out = response.getWriter();
            this.serveStreamAsWriter(in, out);
        }
    }

    private void serveStreamAsStream(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[1024];
        int read = 0;
        while ((read = in.read(buf)) != -1) {
            out.write(buf, 0, read);
        }
    }

    private void serveStreamAsWriter(InputStream in, PrintWriter out) throws IOException {
        InputStreamReader r2 = new InputStreamReader(in);
        char[] buf = new char[1024];
        int read = 0;
        while ((read = r2.read(buf)) != -1) {
            out.write(buf, 0, read);
        }
    }

    private void serveURL(URL url, HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            URLConnection con = url.openConnection();
            con.connect();
            String contentType = con.getContentType();
            int contentLength = con.getContentLength();
            String lastModified = Long.toString(con.getLastModified());
            response.setContentType(contentType != null ? contentType : "text/html");
            response.setContentLength(contentLength >= 0 ? contentLength : 0);
            response.setHeader("Last-Modified", lastModified != null ? lastModified : "");
            InputStream in = con.getInputStream();
            this.serveStream(in, request, response);
            in.close();
        }
        catch (IOException iOException) {
            String requestURI = (String)request.getAttribute("javax.servlet.include.request_uri");
            if (requestURI == null) {
                requestURI = request.getRequestURI();
            }
            response.sendError(404, "File Not Found<br>" + requestURI);
        }
    }
}

