/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.util.StringManager;

public class HttpServletResponseFacade
implements HttpServletResponse {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.core");
    private Response response;

    public HttpServletResponseFacade(Response response) {
        this.response = response;
    }

    public void addCookie(Cookie cookie) {
        this.response.addCookie(cookie);
    }

    public void addDateHeader(String name, long value) {
        this.response.addDateHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this.response.addHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        this.response.addIntHeader(name, value);
    }

    public boolean containsHeader(String name) {
        return this.response.containsHeader(name);
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public String encodeRedirectUrl(String location) {
        return this.encodeRedirectURL(location);
    }

    public String encodeURL(String url) {
        return url;
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public void flushBuffer() throws IOException {
        this.response.flushBuffer();
    }

    public int getBufferSize() {
        return this.response.getBufferSize();
    }

    public String getCharacterEncoding() {
        return this.response.getCharacterEncoding();
    }

    public Locale getLocale() {
        return this.response.getLocale();
    }

    public ServletOutputStream getOutputStream() {
        return this.response.getOutputStream();
    }

    Response getRealResponse() {
        return this.response;
    }

    public PrintWriter getWriter() throws IOException {
        return this.response.getWriter();
    }

    public boolean isCommitted() {
        return this.response.isBufferCommitted();
    }

    public void reset() throws IllegalStateException {
        this.response.reset();
    }

    public void sendError(int sc) throws IOException {
        this.response.sendError(sc);
    }

    public void sendError(int sc, String msg) throws IOException {
        this.response.sendError(sc, msg);
    }

    public void sendRedirect(String location) throws IOException, IllegalArgumentException {
        if (location == null) {
            String msg = this.sm.getString("hsrf.redirect.iae");
            throw new IllegalArgumentException(msg);
        }
        this.response.sendRedirect(location);
    }

    public void setBufferSize(int size) throws IllegalStateException {
        this.response.setBufferSize(size);
    }

    public void setContentLength(int len) {
        this.response.setContentLength(len);
    }

    public void setContentType(String type) {
        this.response.setContentType(type);
    }

    public void setDateHeader(String name, long date) {
        this.response.setDateHeader(name, date);
    }

    public void setHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.response.setIntHeader(name, value);
    }

    public void setLocale(Locale loc) {
        this.response.setLocale(loc);
    }

    public void setStatus(int sc) {
        this.response.setStatus(sc);
    }

    public void setStatus(int sc, String msg) {
        this.response.setStatus(sc);
    }
}

