/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomcat.core.Container;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.HttpServletRequestFacade;
import org.apache.tomcat.core.HttpServletResponseFacade;
import org.apache.tomcat.core.LookupResult;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ServletContextFacade;
import org.apache.tomcat.util.StringManager;

public class InvokerServlet
extends HttpServlet {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.core");
    private Context context;
    private Container container;

    public void doError(HttpServletResponse response) throws ServletException, IOException {
        response.sendError(404);
    }

    public void init() throws ServletException {
        ServletContextFacade facade = (ServletContextFacade)this.getServletContext();
        this.context = facade.getRealContext();
        this.container = this.context.getContainer();
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LookupResult result;
        String requestPath = request.getRequestURI();
        String pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
        if (pathInfo == null) {
            pathInfo = request.getPathInfo();
        }
        String includedRequestURI = (String)request.getAttribute("javax.servlet.include.request_uri");
        boolean inInclude = false;
        inInclude = includedRequestURI != null;
        String servletName = "";
        String newServletPath = "";
        String newPathInfo = "";
        if (pathInfo != null && pathInfo.startsWith("/") && pathInfo.length() > 2) {
            servletName = pathInfo.substring(1, pathInfo.length());
            if (servletName.indexOf("/") > -1) {
                servletName = servletName.substring(0, servletName.indexOf("/"));
            }
            newServletPath = !inInclude ? String.valueOf(request.getServletPath()) + "/" + servletName : String.valueOf((String)request.getAttribute("javax.servlet.include.servlet_path")) + "/" + servletName;
            try {
                newPathInfo = inInclude ? includedRequestURI.substring(newServletPath.length(), includedRequestURI.length()) : requestPath.substring(this.context.getPath().length() + newServletPath.length(), requestPath.length());
                int i2 = newPathInfo.indexOf("?");
                if (i2 > -1) {
                    newPathInfo = newPathInfo.substring(0, i2);
                }
                if (newPathInfo.length() < 1) {
                    newPathInfo = null;
                }
            }
            catch (Exception exception) {
                newPathInfo = null;
            }
        } else {
            this.doError(response);
            return;
        }
        if ((result = this.container.lookupServletByName(servletName)) == null) {
            result = this.container.lookupServletAndLoadByName(servletName);
        }
        if (result == null) {
            this.doError(response);
            return;
        }
        HttpServletRequestFacade requestfacade = (HttpServletRequestFacade)request;
        HttpServletResponseFacade responsefacade = (HttpServletResponseFacade)response;
        Request realRequest = requestfacade.getRealRequest();
        Response realResponse = responsefacade.getRealResponse();
        String savedServletPath = (String)realRequest.getAttribute("javax.servlet.include.servlet_path");
        String savedPathInfo = (String)realRequest.getAttribute("javax.servlet.include.path_info");
        if (!inInclude) {
            realRequest.setServletPath(newServletPath);
            realRequest.setPathInfo(newPathInfo);
        } else {
            if (newServletPath != null) {
                realRequest.setAttribute("javax.servlet.include.servlet_path", newServletPath);
            }
            if (newPathInfo != null) {
                realRequest.setAttribute("javax.servlet.include.path_info", newPathInfo);
            }
            if (newPathInfo == null) {
                realRequest.removeAttribute("javax.servlet.include.path_info");
            }
        }
        result.getWrapper().handleRequest(requestfacade, responsefacade);
        if (inInclude) {
            if (savedServletPath != null) {
                realRequest.setAttribute("javax.servlet.include.servlet_path", savedServletPath);
            } else {
                realRequest.removeAttribute("javax.servlet.include.servlet_path");
            }
            if (savedPathInfo != null) {
                realRequest.setAttribute("javax.servlet.include.path_info", savedPathInfo);
            } else {
                realRequest.removeAttribute("javax.servlet.include.path_info");
            }
        }
    }
}

