/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpUtils;
import org.apache.tomcat.core.ApplicationSession;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.HttpServletRequestFacade;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ServerSession;
import org.apache.tomcat.core.ServerSessionManager;

public abstract class Request {
    protected Response response;
    protected HttpServletRequestFacade requestFacade;
    protected String scheme = "http";
    protected Context context;
    protected Hashtable attributes = new Hashtable();
    protected Hashtable parameters = new Hashtable();
    protected Vector cookies = new Vector();
    protected String protocol;
    protected String requestURI;
    protected String contextPath;
    protected String lookupPath;
    protected String servletPath;
    protected String pathInfo;
    protected String queryString;
    protected String method;
    protected int contentLength = -1;
    protected String contentType = "";
    protected String charEncoding = null;
    protected String authType;
    protected String remoteUser;
    protected String reqSessionId;
    protected ServerSession serverSession;
    protected boolean didReadFormData;

    public Request() {
        this.requestFacade = new HttpServletRequestFacade(this);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getCharacterEncoding() {
        return this.charEncoding;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Context getContext() {
        return this.context;
    }

    Vector getCookies() {
        return this.cookies;
    }

    public abstract long getDateHeader(String var1);

    public HttpServletRequestFacade getFacade() {
        return this.requestFacade;
    }

    public abstract String getHeader(String var1);

    public abstract Enumeration getHeaderNames();

    public abstract Enumeration getHeaders(String var1);

    public abstract ServletInputStream getInputStream() throws IOException;

    public abstract int getIntHeader(String var1);

    public String getLookupPath() {
        return this.lookupPath;
    }

    public String getMethod() {
        return this.method;
    }

    public Enumeration getParameterNames() {
        if (!this.didReadFormData) {
            this.readFormData();
        }
        return this.parameters.keys();
    }

    public String[] getParameterValues(String name) {
        if (!this.didReadFormData) {
            this.readFormData();
        }
        return (String[])this.parameters.get(name);
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public abstract BufferedReader getReader() throws IOException;

    public abstract String getRemoteAddr();

    public abstract String getRemoteHost();

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getRequestedSessionId() {
        return this.reqSessionId;
    }

    public String getScheme() {
        return this.scheme;
    }

    public abstract String getServerName();

    public abstract int getServerPort();

    ServerSession getServerSession(boolean create) {
        if (this.context == null) {
            System.out.println("CONTEXT WAS NEVER SET");
            return null;
        }
        if (this.serverSession == null && create) {
            this.serverSession = ServerSessionManager.getManager().getServerSession(this, this.response, create);
            this.serverSession.accessed();
        }
        return this.serverSession;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public ApplicationSession getSession() {
        return this.getSession(true);
    }

    public ApplicationSession getSession(boolean create) {
        this.getServerSession(create);
        ApplicationSession appSession = null;
        if (this.serverSession != null) {
            appSession = this.serverSession.getApplicationSession(this.context, create);
        }
        return appSession;
    }

    private Hashtable mergeParameters(Hashtable one, Hashtable two) {
        if (one.size() == 0) {
            return two;
        }
        if (two.size() == 0) {
            return one;
        }
        Hashtable combined = (Hashtable)one.clone();
        Enumeration e10 = two.keys();
        while (e10.hasMoreElements()) {
            String[] combinedValue;
            String name = (String)e10.nextElement();
            String[] oneValue = (String[])one.get(name);
            String[] twoValue = (String[])two.get(name);
            if (oneValue == null) {
                combinedValue = twoValue;
            } else {
                combinedValue = new String[oneValue.length + twoValue.length];
                System.arraycopy(oneValue, 0, combinedValue, 0, oneValue.length);
                System.arraycopy(twoValue, 0, combinedValue, oneValue.length, twoValue.length);
            }
            combined.put(name, combinedValue);
        }
        return combined;
    }

    private void readFormData() {
        block2: {
            this.didReadFormData = true;
            if (this.contentType == null || !this.contentType.equals("application/x-www-form-urlencoded")) break block2;
            try {
                ServletInputStream is = this.getInputStream();
                Hashtable postParameters = HttpUtils.parsePostData(this.contentLength, is);
                this.parameters = this.mergeParameters(this.parameters, postParameters);
            }
            catch (IOException iOException) {}
        }
    }

    protected void recycle() {
        this.response = null;
        this.scheme = "http";
        this.context = null;
        this.attributes.clear();
        this.parameters.clear();
        this.cookies.removeAllElements();
        this.method = null;
        this.protocol = null;
        this.requestURI = null;
        this.queryString = null;
        this.contentLength = -1;
        this.contentType = "";
        this.charEncoding = null;
        this.authType = null;
        this.remoteUser = null;
        this.reqSessionId = null;
        this.serverSession = null;
        this.didReadFormData = false;
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public void setCharacterEncoding(String charEncoding) {
        this.charEncoding = charEncoding;
    }

    void setContext(Context context) {
        this.context = context;
        this.contextPath = context.getPath();
        this.lookupPath = this.requestURI.substring(this.contextPath.length(), this.requestURI.length());
        int qindex = this.lookupPath.indexOf("?");
        if (qindex > -1) {
            this.lookupPath = this.lookupPath.substring(0, qindex);
        }
        if (this.lookupPath.length() < 1) {
            this.lookupPath = "/";
        }
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
        try {
            this.parameters = HttpUtils.parseQueryString(queryString);
        }
        catch (Exception exception) {
            this.parameters.clear();
        }
    }

    void setRequestedSessionId(String reqSessionId) {
        this.reqSessionId = reqSessionId;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    void setServerSession(ServerSession serverSession) {
        this.serverSession = serverSession;
    }

    void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    void setURI(String requestURI) {
        this.requestURI = requestURI;
    }
}

