/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ForwardedRequest;
import org.apache.tomcat.core.HttpServletRequestFacade;
import org.apache.tomcat.core.HttpServletResponseFacade;
import org.apache.tomcat.core.IncludedResponse;
import org.apache.tomcat.core.LookupResult;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.util.StringManager;

public class RequestDispatcherImpl
implements RequestDispatcher {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.core");
    private Context context;
    private LookupResult lookupResult = null;
    private String name = null;
    private String urlPath;
    private String queryString;

    RequestDispatcherImpl(Context context) {
        this.context = context;
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequestFacade reqFacade = (HttpServletRequestFacade)request;
        HttpServletResponseFacade resFacade = (HttpServletResponseFacade)response;
        Request realRequest = reqFacade.getRealRequest();
        Response realResponse = resFacade.getRealResponse();
        if (realResponse.isStarted()) {
            String msg = this.sm.getString("rdi.forward.ise");
            throw new IllegalStateException(msg);
        }
        this.urlPath = String.valueOf(this.context.getPath()) + this.urlPath;
        ForwardedRequest fRequest = new ForwardedRequest(realRequest, this.urlPath);
        String aggregatedQueryString = this.queryString;
        if (realRequest.getQueryString() != null && realRequest.getQueryString().trim().length() > 0) {
            aggregatedQueryString = aggregatedQueryString == null ? realRequest.getQueryString() : String.valueOf(aggregatedQueryString) + "&" + realRequest.getQueryString();
        }
        fRequest.setServletPath(this.lookupResult.getServletPath());
        fRequest.setPathInfo(this.lookupResult.getPathInfo());
        fRequest.setQueryString(aggregatedQueryString);
        this.lookupResult.getWrapper().handleRequest(fRequest, resFacade);
    }

    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        String request_uri = (String)req.getAttribute("javax.servlet.include.request_uri");
        String servlet_path = (String)req.getAttribute("javax.servlet.include.servlet_path");
        String path_info = (String)req.getAttribute("javax.servlet.include.path_info");
        String query_string = (String)req.getAttribute("javax.servlet.include.query_string");
        HttpServletRequestFacade reqFacade = (HttpServletRequestFacade)request;
        HttpServletResponseFacade resFacade = (HttpServletResponseFacade)response;
        Request realRequest = reqFacade.getRealRequest();
        Response realResponse = resFacade.getRealResponse();
        String originalQueryString = realRequest.getQueryString();
        if (this.urlPath != null) {
            req.setAttribute("javax.servlet.include.request_uri", this.urlPath);
        }
        if (this.lookupResult.getServletPath() != null) {
            req.setAttribute("javax.servlet.include.servlet_path", this.lookupResult.getServletPath());
        }
        if (this.lookupResult.getPathInfo() != null) {
            req.setAttribute("javax.servlet.include.path_info", this.lookupResult.getPathInfo());
        }
        String aggregatedQueryString = this.queryString;
        if (realRequest.getQueryString() != null && realRequest.getQueryString().trim().length() > 0) {
            aggregatedQueryString = aggregatedQueryString == null ? realRequest.getQueryString() : String.valueOf(aggregatedQueryString) + "&" + realRequest.getQueryString();
        }
        if (aggregatedQueryString != null) {
            req.setAttribute("javax.servlet.include.query_string", aggregatedQueryString);
        }
        reqFacade.getRealRequest().setQueryString(aggregatedQueryString);
        IncludedResponse iResponse = new IncludedResponse(realResponse);
        this.lookupResult.getWrapper().handleRequest(reqFacade, iResponse);
        reqFacade.getRealRequest().setQueryString(originalQueryString);
        if (request_uri != null) {
            req.setAttribute("javax.servlet.include.request_uri", request_uri);
        } else {
            reqFacade.removeAttribute("javax.servlet.include.request_uri");
        }
        if (servlet_path != null) {
            req.setAttribute("javax.servlet.include.servlet_path", servlet_path);
        } else {
            reqFacade.removeAttribute("javax.servlet.include.servlet_path");
        }
        if (path_info != null) {
            req.setAttribute("javax.servlet.include.path_info", path_info);
        } else {
            reqFacade.removeAttribute("javax.servlet.include.path_info");
        }
        if (query_string != null) {
            req.setAttribute("javax.servlet.include.query_string", query_string);
        } else {
            reqFacade.removeAttribute("javax.servlet.include.query_string");
        }
    }

    boolean isValid() {
        return this.lookupResult != null;
    }

    void setName(String name) {
        this.name = name;
        this.lookupResult = this.context.getContainer().lookupServletByName(this.name);
    }

    void setPath(String urlPath) {
        int i2 = urlPath.indexOf("?");
        if (i2 > -1) {
            try {
                this.queryString = urlPath.substring(i2 + 1, urlPath.length());
            }
            catch (Exception exception) {}
            urlPath = urlPath.substring(0, i2);
        }
        this.urlPath = urlPath;
        this.lookupResult = this.context.getContainer().lookupServlet(this.urlPath);
    }
}

