/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpUtils;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.util.MimeHeaders;
import org.apache.tomcat.util.StringManager;

public class RequestImpl
extends Request {
    protected StringManager sm = StringManager.getManager("org.apache.tomcat.core");
    protected ServletInputStream in;
    protected MimeHeaders headers = new MimeHeaders();
    protected String serverName = "";
    protected int serverPort;
    protected String remoteAddr;
    protected String remoteHost;

    public String getCharsetFromContentType(String type) {
        if (type == null) {
            return null;
        }
        int semi = type.indexOf(";");
        if (semi == -1) {
            return null;
        }
        String afterSemi = type.substring(semi + 1);
        int charsetLocation = afterSemi.indexOf("charset=");
        if (charsetLocation == -1) {
            return null;
        }
        String afterCharset = afterSemi.substring(charsetLocation + 8);
        String encoding = afterCharset.trim();
        return encoding;
    }

    public long getDateHeader(String name) {
        return this.headers.getDateHeader(name);
    }

    public String getHeader(String name) {
        return this.headers.getHeader(name);
    }

    public Enumeration getHeaderNames() {
        return this.headers.names();
    }

    public Enumeration getHeaders(String name) {
        String[] headers = this.headers.getHeaders(name);
        Vector<String> v2 = new Vector<String>();
        if (headers != null) {
            int i2 = 0;
            while (i2 < headers.length) {
                v2.addElement(headers[i2]);
                ++i2;
            }
        }
        return v2.elements();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.in == null) {
            String msg = this.sm.getString("serverRequest.inputStream.npe");
            throw new IOException(msg);
        }
        return this.in;
    }

    public int getIntHeader(String name) {
        return this.headers.getIntHeader(name);
    }

    public BufferedReader getReader() throws IOException {
        String encoding = this.getCharacterEncoding();
        if (encoding == null) {
            encoding = "ISO-8859-1";
        }
        InputStreamReader r2 = new InputStreamReader((InputStream)this.getInputStream(), encoding);
        return new BufferedReader(r2);
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void processCookies() {
        String cookieString = this.headers.getHeader("cookie");
        if (cookieString != null) {
            StringTokenizer tok = new StringTokenizer(cookieString, ";", false);
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int i2 = token.indexOf("=");
                if (i2 <= -1) continue;
                String name = token.substring(0, i2).trim();
                String value = token.substring(i2 + 1, token.length()).trim();
                Cookie cookie = new Cookie(name, value);
                this.cookies.addElement(cookie);
            }
        }
    }

    public void processFormData(InputStream in, int contentLength) {
        byte[] buf = new byte[contentLength];
        int read = 0;
        try {
            while ((read += in.read(buf, read, buf.length - read)) < contentLength && read != -1) {
            }
        }
        catch (IOException iOException) {}
        String s2 = new String(buf, 0, read);
        this.processFormData(s2);
    }

    public void processFormData(String data) {
        StringTokenizer tok = new StringTokenizer(data, "&", false);
        while (tok.hasMoreTokens()) {
            String[] values;
            String pair = tok.nextToken();
            int pos = pair.indexOf(61);
            if (pos == -1) continue;
            String key = this.unUrlDecode(pair.substring(0, pos));
            String value = this.unUrlDecode(pair.substring(pos + 1, pair.length()));
            if (this.parameters.containsKey(key)) {
                String[] oldValues = (String[])this.parameters.get(key);
                values = new String[oldValues.length + 1];
                int i2 = 0;
                while (i2 < oldValues.length) {
                    values[i2] = oldValues[i2];
                    ++i2;
                }
                values[oldValues.length] = value;
            } else {
                values = new String[]{value};
            }
            this.parameters.put(key, values);
        }
    }

    public void recycle() {
        super.recycle();
        this.in = null;
        this.headers.clear();
        this.serverName = "";
    }

    public void setCharEncoding(String enc) {
        this.charEncoding = enc;
    }

    public void setContentLength(int len) {
        this.contentLength = len;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public void setHeaders(MimeHeaders h2) {
        this.headers = h2;
    }

    public void setMethod(String meth) {
        this.method = meth;
    }

    public void setParameters(Hashtable parameters) {
        if (parameters != null) {
            this.parameters = parameters;
        }
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
        try {
            this.setParameters(HttpUtils.parseQueryString(queryString));
        }
        catch (Exception exception) {
            this.parameters.clear();
        }
    }

    public void setRemoteAddress(String addr) {
        this.remoteAddr = addr;
    }

    public void setRemoteHost(String host) {
        this.remoteHost = host;
    }

    public void setRequestURI(String r2) {
        this.requestURI = r2;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setServerPort(int port) {
        this.serverPort = port;
    }

    public void setServletInputStream(ServletInputStream in) {
        this.in = in;
    }

    public String unUrlDecode(String data) {
        StringBuffer buf = new StringBuffer();
        int i2 = 0;
        while (i2 < data.length()) {
            char c10 = data.charAt(i2);
            switch (c10) {
                case '+': {
                    buf.append(' ');
                    break;
                }
                case '%': {
                    try {
                        buf.append((char)Integer.parseInt(data.substring(i2 + 1, i2 + 3), 16));
                        i2 += 2;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        String msg = this.sm.getString("serverRequest.urlDecode.nfe", data);
                        throw new IllegalArgumentException(msg);
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        String rest = data.substring(i2);
                        buf.append(rest);
                        if (rest.length() != 2) break;
                        ++i2;
                        break;
                    }
                }
                default: {
                    buf.append(c10);
                    break;
                }
            }
            ++i2;
        }
        return buf.toString();
    }
}

