/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpUtils;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.HttpServletResponseFacade;
import org.apache.tomcat.core.LocaleToCharsetMap;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.ServletContextFacade;

public abstract class Response {
    protected Request request;
    protected HttpServletResponseFacade responseFacade;
    protected Vector userCookies = new Vector();
    protected Vector systemCookies = new Vector();
    protected String contentType = "text/plain";
    protected String contentLanguage = null;
    protected String characterEncoding = System.getProperty("file.encoding", "8859_1");
    protected int contentLength = -1;
    protected int status = 200;
    private Locale locale = new Locale("en", "");

    public Response() {
        this.responseFacade = new HttpServletResponseFacade(this);
    }

    public void addCookie(Cookie cookie) {
        this.userCookies.addElement(cookie);
    }

    public abstract void addDateHeader(String var1, long var2);

    public abstract void addHeader(String var1, String var2);

    public abstract void addIntHeader(String var1, int var2);

    public void addSystemCookie(Cookie cookie) {
        this.systemCookies.addElement(cookie);
    }

    private void close() throws IOException {
        try {
            PrintWriter out = this.getWriter();
            out.close();
        }
        catch (IllegalStateException illegalStateException) {
            ServletOutputStream out = this.getOutputStream();
            out.close();
        }
    }

    String constructLocalizedContentType(String type, Locale loc) {
        String charset;
        int semi = type.indexOf(";");
        if (semi != -1) {
            type = type.substring(0, semi);
        }
        if ((charset = LocaleToCharsetMap.getCharset(loc)) != null) {
            type = String.valueOf(type) + "; charset=" + charset;
        }
        return type;
    }

    public abstract boolean containsHeader(String var1);

    public abstract void flushBuffer() throws IOException;

    public abstract int getBufferSize();

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    private String getCharsetFromContentType(String type) {
        if (type == null) {
            return null;
        }
        int semi = type.indexOf(";");
        if (semi == -1) {
            return null;
        }
        String afterSemi = type.substring(semi + 1);
        int charsetLocation = afterSemi.indexOf("charset=");
        if (charsetLocation == -1) {
            return null;
        }
        String afterCharset = afterSemi.substring(charsetLocation + 8);
        String encoding = afterCharset.trim();
        return encoding;
    }

    public HttpServletResponseFacade getFacade() {
        return this.responseFacade;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public abstract ServletOutputStream getOutputStream();

    public int getStatus() {
        return this.status;
    }

    public abstract PrintWriter getWriter() throws IOException;

    public abstract boolean isBufferCommitted();

    public abstract boolean isCommitted();

    public abstract boolean isStarted();

    private String makeAbsolute(String location) {
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException malformedURLException) {
            String requrl = HttpUtils.getRequestURL(this.request.getFacade()).toString();
            try {
                url = new URL(new URL(requrl), location);
            }
            catch (MalformedURLException malformedURLException2) {
                return location;
            }
        }
        return url.toString();
    }

    public void recycle() {
        this.userCookies.removeAllElements();
        this.systemCookies.removeAllElements();
        this.contentType = "text/plain";
        this.locale = new Locale("en", "");
        this.characterEncoding = System.getProperty("file.encoding", "8859_1");
        this.contentLength = -1;
        this.status = 200;
    }

    public void reset() throws IllegalStateException {
        this.userCookies.removeAllElements();
        this.contentType = "text/plain";
        this.locale = new Locale("en", "");
        this.characterEncoding = System.getProperty("file.encoding", "8859_1");
        this.contentLength = -1;
        this.status = 200;
    }

    public void sendBodyText(String s2) throws IOException {
        try {
            PrintWriter out = this.getWriter();
            out.print(s2);
        }
        catch (IllegalStateException illegalStateException) {
            ServletOutputStream out = this.getOutputStream();
            out.print(s2);
        }
    }

    public void sendError(int sc) throws IOException {
        this.sendError(sc, "No detailed message");
    }

    public void sendError(int sc, String msg) throws IOException {
        this.status = sc;
        Context context = this.request.getContext();
        if (context == null) {
            this.sendPrivateError(sc, msg);
            return;
        }
        ServletContextFacade contextFacade = context.getFacade();
        String path = context.getErrorPage(String.valueOf(sc));
        if (path != null) {
            RequestDispatcher rd = contextFacade.getRequestDispatcher(path);
            this.request.setAttribute("javax.servlet.error.status_code", String.valueOf(sc));
            this.request.setAttribute("javax.servlet.error.message", msg);
            try {
                this.reset();
                rd.forward(this.request.getFacade(), this.getFacade());
            }
            catch (IllegalStateException illegalStateException) {
                try {
                    rd.include(this.request.getFacade(), this.getFacade());
                }
                catch (ServletException servletException) {
                    this.sendPrivateError(sc, msg);
                }
            }
            catch (ServletException servletException) {
                this.sendPrivateError(sc, msg);
            }
        } else {
            this.sendPrivateError(sc, msg);
        }
        this.close();
    }

    private void sendPrivateError(int sc, String msg) throws IOException {
        this.setContentType("text/html");
        StringBuffer buf = new StringBuffer();
        buf.append("<h1>Error: " + sc + "</h1>\r\n");
        buf.append(String.valueOf(msg) + "\r\n");
        this.sendBodyText(buf.toString());
    }

    public void sendRedirect(String location) throws IOException {
        this.setStatus(302);
        this.setContentType("text/html");
        location = this.makeAbsolute(location);
        this.setHeader("Location", location);
        StringBuffer buf = new StringBuffer();
        buf.append("<head><title>Document moved</title></head>\r\n");
        buf.append("<body><h1>Document moved</h1>\r\n");
        buf.append("This document has moved <a href=\"");
        buf.append(location);
        buf.append("\">here</a>.<p>\r\n");
        buf.append("</body>\r\n");
        String body = buf.toString();
        this.setContentLength(body.length());
        this.sendBodyText(body);
        this.close();
    }

    public abstract void setBufferSize(int var1) throws IllegalStateException;

    private void setCharacterEncoding(String encoding) {
        this.characterEncoding = encoding;
    }

    private void setCharacterEncodingFromContentType(String type) {
        String encoding = this.getCharsetFromContentType(type);
        if (encoding != null) {
            this.setCharacterEncoding(encoding);
        }
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
        this.setCharacterEncodingFromContentType(contentType);
    }

    public abstract void setDateHeader(String var1, long var2);

    public abstract void setHeader(String var1, String var2);

    public abstract void setIntHeader(String var1, int var2);

    public void setLocale(Locale locale) {
        if (locale == null) {
            return;
        }
        this.locale = locale;
        this.contentLanguage = locale.getLanguage();
        String newType = this.constructLocalizedContentType(this.contentType, locale);
        this.setContentType(newType);
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public void setStatus(int status) {
        this.status = status;
    }
}

