/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.SocketException;
import java.util.Enumeration;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import org.apache.tomcat.core.BufferedServletOutputStream;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.util.CookieTools;
import org.apache.tomcat.util.MimeHeaders;
import org.apache.tomcat.util.StringManager;

public class ResponseImpl
extends Response {
    protected StringManager sm = StringManager.getManager("org.apache.tomcat.core");
    protected MimeHeaders headers = new MimeHeaders();
    protected BufferedServletOutputStream out;
    protected PrintWriter writer;
    protected boolean usingStream = false;
    protected boolean usingWriter = false;
    protected boolean started = false;
    protected boolean committed = false;
    protected boolean omitHeaders = false;
    protected String serverHeader = null;

    public void addDateHeader(String name, long date) {
        this.headers.addDateHeader(name, date);
    }

    public void addHeader(String name, String value) {
        this.headers.addHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        this.headers.addIntHeader(name, value);
    }

    public boolean containsHeader(String name) {
        return this.headers.containsHeader(name);
    }

    public void endResponse() throws IOException {
    }

    public void finish() throws IOException {
        try {
            if (this.usingWriter) {
                this.writer.flush();
            }
            this.out.reallyFlush();
        }
        catch (SocketException socketException) {
            return;
        }
    }

    protected void fixHeaders() throws IOException {
        Cookie c02;
        Cookie c10;
        this.headers.putIntHeader("Status", this.status);
        this.headers.putHeader("Content-Type", this.contentType);
        if (this.contentLength != -1) {
            this.headers.putIntHeader("Content-Length", this.contentLength);
        }
        Enumeration cookieEnum = null;
        cookieEnum = this.systemCookies.elements();
        while (cookieEnum.hasMoreElements()) {
            c10 = (Cookie)cookieEnum.nextElement();
            this.headers.putHeader(CookieTools.getCookieHeaderName(c10), CookieTools.getCookieHeaderValue(c10));
            if (c10.getVersion() != 1) continue;
            c02 = (Cookie)c10.clone();
            c02.setVersion(0);
            this.headers.putHeader(CookieTools.getCookieHeaderName(c02), CookieTools.getCookieHeaderValue(c02));
        }
        cookieEnum = this.userCookies.elements();
        while (cookieEnum.hasMoreElements()) {
            c10 = (Cookie)cookieEnum.nextElement();
            this.headers.putHeader(CookieTools.getCookieHeaderName(c10), CookieTools.getCookieHeaderValue(c10));
            if (c10.getVersion() != 1) continue;
            c02 = (Cookie)c10.clone();
            c02.setVersion(0);
            this.headers.putHeader(CookieTools.getCookieHeaderName(c02), CookieTools.getCookieHeaderValue(c02));
        }
    }

    public void flushBuffer() throws IOException {
        if (this.usingWriter) {
            this.writer.flush();
        }
        this.out.reallyFlush();
    }

    public int getBufferSize() {
        return this.out.getBufferSize();
    }

    public ServletOutputStream getOutputStream() {
        this.started = true;
        if (this.usingWriter) {
            String msg = this.sm.getString("serverResponse.outputStream.ise");
            throw new IllegalStateException(msg);
        }
        this.usingStream = true;
        return this.out;
    }

    public String getServerHeader() {
        return this.serverHeader;
    }

    public PrintWriter getWriter() throws IOException {
        this.started = true;
        if (this.usingStream) {
            String msg = this.sm.getString("serverResponse.writer.ise");
            throw new IllegalStateException(msg);
        }
        this.usingWriter = true;
        if (this.writer == null) {
            String encoding = this.getCharacterEncoding();
            this.writer = encoding == null ? new PrintWriter(new OutputStreamWriter(this.out)) : new PrintWriter(new OutputStreamWriter((OutputStream)this.out, encoding));
        }
        this.out.setUsingWriter(this.usingWriter);
        return this.writer;
    }

    public boolean isBufferCommitted() {
        return this.out.isCommitted();
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void recycle() {
        super.recycle();
        this.headers.clear();
        this.usingWriter = false;
        this.usingStream = false;
        this.writer = null;
        this.out = null;
        this.started = false;
        this.committed = false;
        this.omitHeaders = false;
    }

    public void reset() throws IllegalStateException {
        if (this.usingWriter) {
            this.writer.flush();
        }
        this.out.reset();
        super.reset();
        this.headers.clear();
    }

    public void setBufferSize(int size) throws IllegalStateException {
        if (this.usingWriter) {
            this.writer.flush();
        }
        if (this.out.isContentWritten()) {
            String msg = this.sm.getString("servletOutputStreamImpl.setbuffer.ise");
            throw new IllegalStateException(msg);
        }
        this.out.setBufferSize(size);
    }

    public void setBufferedServeletOutputStream(BufferedServletOutputStream out) {
        this.out = out;
    }

    public void setDateHeader(String name, long date) {
        this.headers.putDateHeader(name, date);
    }

    public void setHeader(String name, String value) {
        this.headers.putHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.headers.putIntHeader(name, value);
    }

    public void setOmitHeaders(boolean omitHeaders) {
        this.omitHeaders = omitHeaders;
    }

    public void setServerHeader(String serverHeader) {
        this.serverHeader = serverHeader;
    }

    public void writeHeaders() throws IOException {
    }
}

