/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.Cookie;
import org.apache.tomcat.core.ApplicationSession;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.Reaper;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ServerSession;
import org.apache.tomcat.util.SessionIdGenerator;
import org.apache.tomcat.util.StringManager;

public class ServerSessionManager {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.core");
    private static ServerSessionManager manager = new ServerSessionManager();
    private Hashtable sessions = new Hashtable();
    private Reaper reaper = Reaper.getReaper();

    private ServerSessionManager() {
        this.reaper.setServerSessionManager(this);
        this.reaper.start();
    }

    static ServerSessionManager getManager() {
        return manager;
    }

    ServerSession getServerSession(Request request, Response response, boolean create) {
        Cookie cookie;
        String sessionId = null;
        ServerSession session = null;
        Enumeration enumeration = request.getCookies().elements();
        while (enumeration.hasMoreElements()) {
            cookie = (Cookie)enumeration.nextElement();
            if (!cookie.getName().equals("JSESSIONID") || (sessionId = cookie.getValue()) == null) continue;
            request.setRequestedSessionId(sessionId);
            session = (ServerSession)this.sessions.get(sessionId);
        }
        if (session == null && create) {
            if (sessionId == null) {
                sessionId = SessionIdGenerator.generateId();
                cookie = new Cookie("JSESSIONID", sessionId);
                cookie.setMaxAge(-1);
                cookie.setPath("/");
                cookie.setVersion(1);
                response.addSystemCookie(cookie);
            }
            session = new ServerSession(sessionId);
            this.sessions.put(sessionId, session);
        }
        return session;
    }

    synchronized void reap() {
        Enumeration enumeration = this.sessions.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            ServerSession session = (ServerSession)this.sessions.get(key);
            session.reap();
            session.validate();
        }
    }

    void removeApplicationSessions(Context context) {
        Enumeration enumeration = this.sessions.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            ServerSession session = (ServerSession)this.sessions.get(key);
            ApplicationSession appSession = session.getApplicationSession(context, false);
            if (appSession == null) continue;
            appSession.invalidate();
        }
    }

    synchronized void removeSession(ServerSession session) {
        String id = session.getId();
        session.invalidate();
        this.sessions.remove(id);
    }
}

