/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tomcat.core.Container;
import org.apache.tomcat.core.JarFinder;
import org.apache.tomcat.core.ServletWrapper;
import org.apache.tomcat.util.StringManager;

class ServletLoader
extends ClassLoader {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.core");
    private Container container;
    protected Hashtable classes = new Hashtable();

    ServletLoader(Container container) {
        this.container = container;
    }

    private String classPathFormat(Enumeration e10) {
        String cp2 = "";
        while (e10.hasMoreElements()) {
            URL u2 = (URL)e10.nextElement();
            if (u2 == null) continue;
            cp2 = String.valueOf(cp2) + (cp2.length() > 0 ? File.pathSeparator : "") + u2.getFile();
        }
        return cp2;
    }

    private byte[] getBytes(URL u2) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream is = u2.openConnection().getInputStream();
        byte[] buf = new byte[1024];
        int read = 0;
        while ((read = is.read(buf)) != -1) {
            baos.write(buf, 0, read);
        }
        is.close();
        return baos.toByteArray();
    }

    String getClassPath() {
        String cp2 = "";
        URL base = this.container.getServletBase();
        if (base != null) {
            Enumeration e10 = this.getPaths(base, this.container.getClassPaths()).elements();
            cp2 = this.classPathFormat(e10);
            e10 = this.getJars(base, this.container.getLibPaths()).elements();
            cp2 = String.valueOf(cp2) + (cp2.length() > 0 ? File.pathSeparator : "") + this.classPathFormat(e10);
        }
        return cp2;
    }

    private Vector getJarURLs(URL base, String path, String entryName) {
        File f2;
        Vector<URL> v2 = new Vector<URL>();
        URL u2 = null;
        try {
            u2 = this.resolveURL(base, path);
        }
        catch (MalformedURLException malformedURLException) {}
        if (u2 != null && (f2 = new File(u2.getFile())).exists() && f2.isDirectory()) {
            JarFinder jarFinder = new JarFinder();
            String[] jars = jarFinder.getJars(f2);
            int i2 = 0;
            while (i2 < jars.length) {
                String s2 = String.valueOf(f2.toString()) + File.separator + jars[i2];
                try {
                    URL jURL;
                    URL tURL = new URL("file", null, s2);
                    u2 = jURL = new URL("jar:" + tURL + "!/" + entryName);
                }
                catch (MalformedURLException mue) {
                    mue.printStackTrace();
                    u2 = null;
                }
                if (u2 != null) {
                    v2.addElement(u2);
                }
                ++i2;
            }
        }
        return v2;
    }

    private Vector getJars(URL base, Enumeration paths) {
        Vector<URL> v2 = new Vector<URL>();
        while (paths.hasMoreElements()) {
            File f2;
            String path = (String)paths.nextElement();
            URL u2 = null;
            try {
                u2 = this.resolveURL(base, path);
            }
            catch (MalformedURLException malformedURLException) {}
            if (u2 == null || !(f2 = new File(u2.getFile())).exists() || !f2.isDirectory()) continue;
            JarFinder jarFinder = new JarFinder();
            String[] jars = jarFinder.getJars(f2);
            int i2 = 0;
            while (i2 < jars.length) {
                String s2 = String.valueOf(f2.toString()) + File.separator + jars[i2];
                try {
                    URL tURL = new URL("file", null, s2);
                    u2 = this.resolveURL(tURL);
                }
                catch (MalformedURLException malformedURLException) {
                    u2 = null;
                }
                if (u2 != null) {
                    v2.addElement(u2);
                }
                ++i2;
            }
        }
        return v2;
    }

    private Vector getPathURL(URL base, String path, String entryName) {
        Vector<URL> v2 = new Vector<URL>();
        URL u2 = null;
        try {
            u2 = this.resolveURL(base, path, entryName);
        }
        catch (MalformedURLException malformedURLException) {
            u2 = null;
        }
        if (u2 != null) {
            v2.addElement(u2);
        }
        return v2;
    }

    private Vector getPaths(URL base, Enumeration paths) {
        Vector<URL> v2 = new Vector<URL>();
        while (paths.hasMoreElements()) {
            String path = (String)paths.nextElement();
            URL u2 = null;
            try {
                u2 = this.resolveURL(base, path);
            }
            catch (MalformedURLException malformedURLException) {}
            if (u2 == null) continue;
            v2.addElement(u2);
        }
        return v2;
    }

    public URL getResource(String name) {
        URL u2 = null;
        URL base = this.container.getServletBase();
        if (base != null && (u2 = this.getResource(base, this.container.getClassPaths(), name)) == null) {
            u2 = this.getResource(base, this.container.getLibPaths(), name, true);
        }
        return u2;
    }

    private URL getResource(URL base, Enumeration paths, String name) {
        return this.getResource(base, paths, name, false);
    }

    private URL getResource(URL base, Enumeration paths, String name, boolean lib) {
        URL u2 = null;
        block2: while (paths.hasMoreElements()) {
            String path = (String)paths.nextElement();
            Vector v2 = new Vector();
            v2 = !lib ? this.getPathURL(base, path, name) : this.getJarURLs(base, path, name);
            Enumeration enumeration = v2.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    u2 = (URL)enumeration.nextElement();
                    u2.openStream();
                    continue block2;
                }
                catch (IOException iOException) {
                    u2 = null;
                }
            }
        }
        return u2;
    }

    public InputStream getResourceAsStream(String name) {
        InputStream is;
        block2: {
            is = null;
            URL u2 = this.getResource(name);
            if (u2 == null) break block2;
            try {
                is = u2.openStream();
            }
            catch (IOException iOException) {}
        }
        return is;
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class clazz = null;
        clazz = this.loadFromSystemLoader(name);
        if (clazz == null) {
            clazz = (Class)this.classes.get(name);
        }
        if (clazz == null) {
            clazz = this.loadFromLocalLoader(name);
        }
        if (clazz != null) {
            this.classes.put(name, clazz);
            if (resolve) {
                this.resolveClass(clazz);
            }
        }
        return clazz;
    }

    private byte[] loadClassData(String name) throws ClassNotFoundException {
        byte[] ba2 = null;
        URL base = this.container.getServletBase();
        if (base != null && (ba2 = this.loadClassData(base, this.container.getClassPaths(), name)) == null) {
            ba2 = this.loadClassData(base, this.container.getLibPaths(), name, true);
        }
        if (ba2 == null) {
            String msg = this.sm.getString("servletLoader.load.cnfe", name);
            throw new ClassNotFoundException(msg);
        }
        return ba2;
    }

    private byte[] loadClassData(URL base, Enumeration paths, String name) {
        return this.loadClassData(base, paths, name, false);
    }

    private byte[] loadClassData(URL base, Enumeration paths, String name, boolean lib) {
        byte[] ba2 = null;
        block2: while (paths.hasMoreElements()) {
            String path = (String)paths.nextElement();
            String entryName = String.valueOf(name.replace('.', '/')) + ".class";
            Vector v2 = new Vector();
            v2 = !lib ? this.getPathURL(base, path, entryName) : this.getJarURLs(base, path, entryName);
            Enumeration enumeration = v2.elements();
            while (enumeration.hasMoreElements()) {
                URL u2 = (URL)enumeration.nextElement();
                try {
                    ba2 = this.getBytes(u2);
                }
                catch (IOException iOException) {}
                if (ba2 != null) continue block2;
            }
        }
        return ba2;
    }

    private Class loadFromLocalLoader(String name) throws ClassNotFoundException {
        byte[] ba2 = this.loadClassData(name);
        return this.defineClass(name, ba2, 0, ba2.length);
    }

    private Class loadFromSystemLoader(String name) {
        Class<?> clazz = null;
        try {
            ClassLoader parent = this.container.getContext().getClassLoader();
            clazz = parent != null ? parent.loadClass(name) : this.findSystemClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return clazz;
    }

    synchronized Class loadServlet(ServletWrapper wrapper, String name) throws ClassNotFoundException {
        Class clazz = this.loadClass(name, true);
        return clazz;
    }

    private URL resolveURL(URL base) throws MalformedURLException {
        return this.resolveURL(base, null, null);
    }

    private URL resolveURL(URL base, String path) throws MalformedURLException {
        return this.resolveURL(base, path, null);
    }

    private URL resolveURL(URL base, String path, String name) throws MalformedURLException {
        URL u2 = null;
        String s2 = "";
        if (path != null && path.trim().length() > 0) {
            s2 = String.valueOf(s2) + (s2.length() > 0 ? "/" : "") + path.trim();
        }
        if (name != null && name.trim().length() > 0) {
            s2 = String.valueOf(s2) + (!s2.endsWith("/") ? "/" : "") + name.trim();
        }
        u2 = base.getProtocol().equalsIgnoreCase("jar") ? new URL(String.valueOf(base.toString()) + (s2.length() > 0 ? "!" : "") + s2) : new URL(String.valueOf(base.toString()) + (s2.length() > 0 ? "/" : "") + s2);
        return u2;
    }
}

