/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.security.file;

import java.security.Principal;
import java.util.Enumeration;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.security.RealmConnector;
import org.apache.tomcat.security.file.FileRealmDatabase;
import org.apache.tomcat.security.file.FileRealmGroup;
import org.apache.tomcat.security.file.FileRealmUser;

public final class FileRealmConnector
implements RealmConnector {
    private Context context = null;
    private FileRealmDatabase database = null;

    public Principal authenticate(String username, String credentials) {
        if (this.context == null) {
            throw new IllegalStateException("FileRealmConnector:  Not started");
        }
        FileRealmUser user = this.database.getUser(username);
        if (user == null) {
            return null;
        }
        if (user.authenticate(credentials)) {
            return user;
        }
        return null;
    }

    public boolean hasRole(Principal principal, String role) {
        if (this.context == null) {
            throw new IllegalStateException("FileRealmConnector:  Not started");
        }
        FileRealmUser user = this.database.getUser(principal.getName());
        if (user == null) {
            return false;
        }
        if (user.hasRole(role)) {
            return true;
        }
        Enumeration groups = user.getGroups();
        while (groups.hasMoreElements()) {
            FileRealmGroup group = (FileRealmGroup)groups.nextElement();
            if (!group.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public void start(Context context) {
        this.context = context;
    }

    public void stop() {
        this.context = null;
        this.database = null;
    }
}

