/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.security.file;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tomcat.security.file.FileRealmDatabase;
import org.apache.tomcat.security.file.FileRealmUser;

final class FileRealmGroup {
    private FileRealmDatabase database = null;
    private String name = null;
    private Hashtable roles = new Hashtable();
    private Hashtable users = new Hashtable();

    FileRealmGroup(FileRealmDatabase database, String name) {
        this.database = database;
        this.name = name;
        database.add(this);
    }

    public void add(String role) {
        this.database.add(role);
        this.roles.put(role, role);
    }

    void add(FileRealmUser user) {
        this.users.put(user.getName(), user);
    }

    public void destroy() {
        Enumeration users = this.database.getUsers();
        while (users.hasMoreElements()) {
            FileRealmUser user = (FileRealmUser)users.nextElement();
            user.remove(this);
        }
        this.database.remove(this);
    }

    public String getName() {
        return this.name;
    }

    public Enumeration getRoles() {
        return this.roles.elements();
    }

    public Enumeration getUsers() {
        return this.users.elements();
    }

    public boolean hasRole(String role) {
        return this.roles.get(role) != null;
    }

    public void remove(String role) {
        this.roles.remove(role);
    }

    void remove(FileRealmUser user) {
        this.users.remove(user.getName());
    }
}

