/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.server;

import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.server.Endpoint;
import org.apache.tomcat.server.EndpointManager;
import org.apache.tomcat.server.HttpServer;
import org.apache.tomcat.server.ServerRequest;
import org.apache.tomcat.server.ServerResponse;
import org.apache.tomcat.server.ServletInputStreamImpl;
import org.apache.tomcat.util.StringManager;

class ConnectionHandler
extends Thread {
    protected StringManager sm = StringManager.getManager("org.apache.tomcat.server");
    protected EndpointManager manager;
    protected ServerRequest request = new ServerRequest();
    protected ServerResponse response = new ServerResponse();
    protected Endpoint endpoint;
    protected Socket socket;

    ConnectionHandler() {
    }

    ConnectionHandler(EndpointManager manager) {
        this.manager = manager;
    }

    void recycle() {
        this.request.recycle();
        this.response.recycle();
        this.endpoint = null;
        this.socket = null;
    }

    public void run() {
        if (this.endpoint == null || this.socket == null) {
            String msg = this.sm.getString("conhandler.run.ise");
            throw new IllegalStateException(msg);
        }
        try {
            boolean count = true;
            this.request.setSocket(this.socket);
            this.response.setSocket(this.socket);
            while (this.request.hasMoreRequests()) {
                this.request.setResponse(this.response);
                this.response.setRequest(this.request);
                this.request.readNextRequest();
                if (this.request.getProtocol() == null) {
                    this.response.setOmitHeaders(true);
                }
                if (this.response.getStatus() >= 400) {
                    this.response.finish();
                    this.request.recycle();
                    this.response.recycle();
                    break;
                }
                String hostHeader = this.request.getHeader("host");
                if (hostHeader != null) {
                    int i2 = hostHeader.indexOf(58);
                    if (i2 > -1) {
                        hostHeader = hostHeader.substring(0, i2);
                    }
                    this.request.setServerName(hostHeader);
                } else {
                    InetAddress localAddress = this.socket.getLocalAddress();
                    this.request.setServerName(localAddress.getHostName());
                }
                int contentLength = this.request.getIntHeader("content-length");
                if (contentLength != -1) {
                    ServletInputStreamImpl sis = (ServletInputStreamImpl)this.request.getInputStream();
                    sis.setLimit(contentLength + 2);
                }
                HttpServer server = this.manager.resolveServer(this.endpoint, hostHeader);
                String path = this.request.getRequestURI();
                int index = path.indexOf("?");
                this.response.setServerHeader(server.getServerHeader());
                if (index > 0) {
                    path = path.substring(0, index);
                }
                Context ctx = server.getContextByPath(path);
                String ctxPath = ctx.getPath();
                String pathInfo = path.substring(ctxPath.length(), path.length());
                ctx.handleRequest(this.request, this.response);
                this.response.finish();
                this.request.recycle();
                this.response.recycle();
            }
            try {
                InputStream is = this.socket.getInputStream();
                if (is.available() > 1) {
                    is.read();
                    is.read();
                }
                this.socket.close();
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (SocketException socketException) {}
        }
        catch (Exception e10) {
            System.out.println("HANDLER THREAD PROBLEM: " + e10);
            e10.printStackTrace();
        }
        this.manager.returnHandler(this);
    }

    void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    void setEndpointManager(EndpointManager manager) {
        this.manager = manager;
    }

    void setSocket(Socket socket) {
        this.socket = socket;
    }
}

