/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.server;

import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.tomcat.server.ConnectionHandler;
import org.apache.tomcat.server.EndpointManager;
import org.apache.tomcat.util.StringManager;

class Endpoint
implements Runnable {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.server");
    private EndpointManager manager = EndpointManager.getManager();
    private boolean running = true;
    private InetAddress inet;
    private int port;
    private ServerSocket serverSocket;

    Endpoint(InetAddress inet, int port) {
        this.inet = inet;
        this.port = port;
    }

    InetAddress getAddress() {
        return this.inet;
    }

    int getPort() {
        return this.port;
    }

    public void run() {
        while (this.running) {
            try {
                Socket socket = this.serverSocket.accept();
                if (!this.running) {
                    socket.close();
                    break;
                }
                ConnectionHandler handler = this.manager.getHandler();
                handler.setEndpoint(this);
                handler.setSocket(socket);
                handler.start();
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (Exception e10) {
                this.running = false;
                String msg = this.sm.getString("endpoint.err.fatal", this.serverSocket, e10);
                System.err.println(msg);
            }
        }
        this.manager.notifyEndpointDown(this);
    }

    void setServerSocket(ServerSocket ss) {
        this.serverSocket = ss;
    }

    void shutdown() {
        this.running = false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.inet != null) {
            buf.append(this.inet);
        }
        buf.append(":" + this.port);
        return buf.toString();
    }
}

