/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Server;
import org.apache.tomcat.core.ServerConnector;
import org.apache.tomcat.net.ServerSocketFactory;
import org.apache.tomcat.server.HttpServerConnector;
import org.apache.tomcat.server.HttpServerException;
import org.apache.tomcat.util.StringManager;

public class HttpServer
implements Server {
    public static final String VHOST_PORT = "vhost_port";
    public static final String VHOST_NAME = "vhost_name";
    public static final String SERVER = "server";
    public static final String VHOST_ADDRESS = "vhost_address";
    public static final String SOCKET_FACTORY = "socketFactory";
    public static final String CONNECTOR_PROP = "/connector.properties";
    ContextManager contextM;
    public static final int MAX_CONNECTORS = 10;
    ServerConnector[] connector = new ServerConnector[10];
    int connector_count = 0;
    InetAddress address;
    ServerSocketFactory factory;
    Properties props;
    private StringManager sm = StringManager.getManager("org.apache.tomcat.server");
    private String hostname = "";
    private String serverHeader = null;

    public HttpServer() {
    }

    public HttpServer(int port, InetAddress address, String hostname) {
        this.contextM = new ContextManager();
        this.init(port, address, hostname, this.contextM);
    }

    public HttpServer(int port, InetAddress address, String hostname, ContextManager contextM) {
        this.init(port, address, hostname, contextM);
    }

    public synchronized void addConnector(ServerConnector con) {
        this.connector[this.connector_count] = con;
        ++this.connector_count;
    }

    public Context addContext(String path, URL docBase) {
        return this.contextM.addContext(path, docBase);
    }

    private ServerConnector findDefaultConnector(Properties def, String host, int port) {
        Properties props = new Properties(def);
        this.getProperties(props, CONNECTOR_PROP);
        String key = "connector." + host + "." + port + ".";
        String classN = props.getProperty(String.valueOf(key) + "class");
        if (classN != null) {
            ServerConnector conn = null;
            try {
                Class<?> c10 = Class.forName(classN);
                conn = (ServerConnector)c10.newInstance();
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
                return new HttpServerConnector();
            }
            if (conn != null) {
                int off = key.length();
                Enumeration e10 = ((Hashtable)props).keys();
                while (e10.hasMoreElements()) {
                    String n2 = (String)e10.nextElement();
                    if (!n2.startsWith(key)) continue;
                    String pn = n2.substring(off);
                    conn.setProperty(pn, props.getProperty(n2));
                }
                return conn;
            }
        }
        HttpServerConnector con = new HttpServerConnector();
        return con;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public ServerConnector getConnector(int i2) {
        return this.connector[i2];
    }

    public int getConnectorCount() {
        return this.connector_count;
    }

    public Context getContext(String name) {
        return this.contextM.getContext(name);
    }

    public Context getContextByPath(String path) {
        return this.contextM.getContextByPath(path);
    }

    public ContextManager getContextManager() {
        return this.contextM;
    }

    public Enumeration getContextNames() {
        return this.contextM.getContextNames();
    }

    public Context getDefaultContext() {
        return this.contextM.getDefaultContext();
    }

    public String getHostName() {
        return this.contextM.getHostName();
    }

    public int getPort() {
        return this.contextM.getPort();
    }

    private Properties getProperties(Properties props, String propertyFileName) {
        try {
            InputStream is = this.getClass().getResourceAsStream(propertyFileName);
            if (is == null) {
                return props;
            }
            props.load(is);
        }
        catch (IOException iOException) {}
        return props;
    }

    public String getServerHeader() {
        return this.serverHeader;
    }

    public String getServerInfo() {
        return this.contextM.getServerInfo();
    }

    public void init(int port, InetAddress address, String hostname, ContextManager contextM) {
        this.contextM = contextM;
        if (hostname == null || "".equals(hostname)) {
            hostname = "localhost";
        }
        this.setPort(port);
        this.setAddress(address);
        this.setHostName(hostname);
        if (contextM.getDefaultContext() == null) {
            Context defaultContext = contextM.addContext("", null);
            contextM.setDefaultContext(defaultContext);
            contextM.setServerInfo(contextM.getDefaultContext().getEngineHeader());
        }
        this.props = new Properties();
        this.getProperties(this.props, "server.properties");
        this.serverHeader = this.props.getProperty("server.header", "server.header");
    }

    private void initConnector() {
        if (this.connector_count == 0) {
            this.addConnector(this.findDefaultConnector(this.props, this.getHostName(), this.getPort()));
        }
        int i2 = 0;
        while (i2 < this.connector_count) {
            this.connector[i2].setAttribute(SERVER, this);
            this.connector[i2].setContextManager(this.contextM);
            this.connector[i2].setAttribute(VHOST_PORT, new Integer(this.getPort()));
            this.connector[i2].setAttribute(VHOST_ADDRESS, this.address);
            this.connector[i2].setAttribute(SOCKET_FACTORY, this.factory);
            this.connector[i2].setAttribute(VHOST_NAME, this.getHostName());
            ++i2;
        }
    }

    public void removeContext(String name) {
        this.contextM.removeContext(name);
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public void setContextManager(ContextManager cm2) {
        this.contextM = cm2;
    }

    public void setDefaultSocketFactory(ServerSocketFactory factory) {
        this.factory = factory;
    }

    public void setHostName(String hostname) {
        this.contextM.setHostName(hostname);
    }

    public void setPort(int port) {
        this.contextM.setPort(port);
    }

    public void setServerInfo(String serverInfo) {
        this.contextM.setServerInfo(serverInfo);
    }

    public void start() throws HttpServerException {
        Context defaultContext = this.contextM.getDefaultContext();
        if (defaultContext == null || defaultContext.getDocumentBase() == null) {
            String msg = this.sm.getString("server.defaultContext.npe");
            throw new HttpServerException(msg);
        }
        Enumeration enumeration = this.contextM.getContextNames();
        while (enumeration.hasMoreElements()) {
            Context context = this.contextM.getContext((String)enumeration.nextElement());
            context.init();
        }
        this.initConnector();
        int i2 = 0;
        while (i2 < this.connector_count) {
            try {
                this.connector[i2].start();
            }
            catch (Exception ex2) {
                throw new HttpServerException(ex2);
            }
            ++i2;
        }
    }

    public void stop() throws HttpServerException {
        System.out.println("Shutting down Http Server");
        int i2 = 0;
        while (i2 < this.connector_count) {
            try {
                this.connector[i2].stop();
            }
            catch (Exception ex2) {
                throw new HttpServerException(ex2);
            }
            ++i2;
        }
        Enumeration enumeration = this.contextM.getContextNames();
        while (enumeration.hasMoreElements()) {
            Context context = this.contextM.getContext((String)enumeration.nextElement());
            System.out.println("Taking down context: " + context.getPath());
            context.shutdown();
        }
    }
}

