/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import org.apache.tomcat.core.RequestImpl;
import org.apache.tomcat.server.ServletInputStreamImpl;
import org.apache.tomcat.util.StringManager;

public class ServerRequest
extends RequestImpl {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.server");
    private Socket socket;
    private boolean moreRequests = false;

    public String getRemoteAddr() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public String getRemoteHost() {
        return this.socket.getInetAddress().getHostName();
    }

    public int getServerPort() {
        return this.socket.getLocalPort();
    }

    public Socket getSocket() {
        return this.socket;
    }

    boolean hasMoreRequests() {
        return this.moreRequests;
    }

    public void processRequestLine(String line) {
        String s2;
        String buffer = line.trim();
        int firstDelim = buffer.indexOf(32);
        int lastDelim = buffer.lastIndexOf(32);
        if (firstDelim == -1 && lastDelim == -1 && buffer.trim().length() > 0) {
            firstDelim = buffer.trim().length();
            lastDelim = buffer.trim().length();
        }
        if (firstDelim != lastDelim && (s2 = buffer.substring(firstDelim, lastDelim)).trim().length() == 0) {
            firstDelim = lastDelim;
        }
        if (firstDelim != lastDelim) {
            this.method = buffer.substring(0, firstDelim).trim();
            this.protocol = buffer.substring(lastDelim + 1).trim();
            this.requestURI = buffer.substring(firstDelim + 1, lastDelim).trim();
        } else if (firstDelim != -1 && lastDelim != -1) {
            this.method = buffer.substring(0, firstDelim).trim();
            this.protocol = null;
            if (lastDelim < buffer.length()) {
                this.requestURI = buffer.substring(lastDelim + 1).trim();
            }
        }
        if (this.protocol != null && !this.protocol.toLowerCase().startsWith("http/")) {
            this.requestURI = String.valueOf(this.requestURI) + " " + this.protocol;
            this.protocol = null;
        }
        int requestErrorCode = 0;
        try {
            int len = line.length();
            if (len < 2) {
                requestErrorCode = 400;
            } else if (line.charAt(len - 1) != '\n') {
                requestErrorCode = 414;
                this.protocol = "HTTP/1.0";
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        if (requestErrorCode == 0 && (this.requestURI == null || this.requestURI.indexOf(32) > -1 || this.requestURI.indexOf(47) != 0)) {
            requestErrorCode = 400;
        }
        if (requestErrorCode != 0) {
            try {
                this.response.sendError(requestErrorCode);
            }
            catch (IOException iOException) {}
            return;
        }
        if (this.requestURI.indexOf("?") > -1) {
            this.queryString = this.requestURI.substring(this.requestURI.indexOf("?") + 1, this.requestURI.length());
            this.processFormData(this.queryString);
            this.requestURI = this.requestURI.substring(0, this.requestURI.indexOf("?"));
        }
    }

    void readNextRequest() throws IOException {
        ServletInputStreamImpl sis;
        block4: {
            InputStream sin = this.socket.getInputStream();
            sis = new ServletInputStreamImpl(this, sin);
            this.in = sis;
            try {
                this.processRequestLine(sis.readLine());
            }
            catch (IOException iOException) {
                if (this.response.getStatus() != 200) break block4;
                this.response.setStatus(500);
                return;
            }
        }
        if (this.response.getStatus() >= 400) {
            return;
        }
        if (this.protocol != null) {
            this.headers.read(sis);
        }
        this.processCookies();
        this.contentLength = this.headers.getIntHeader("content-length");
        this.contentType = this.headers.getHeader("content-type");
        this.charEncoding = this.getCharsetFromContentType(this.contentType);
        this.moreRequests = false;
    }

    void setSocket(Socket socket) {
        this.socket = socket;
        this.moreRequests = true;
    }
}

