/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.server;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Enumeration;
import javax.servlet.http.Cookie;
import org.apache.tomcat.core.ResponseImpl;
import org.apache.tomcat.server.ServletOutputStreamImpl;
import org.apache.tomcat.util.CookieUtils;
import org.apache.tomcat.util.HttpDate;
import org.apache.tomcat.util.MimeHeaderField;
import org.apache.tomcat.util.StringManager;

public class ServerResponse
extends ResponseImpl {
    protected StringManager sm = StringManager.getManager("org.apache.tomcat.server");
    Socket socket;

    public Socket getSocket() {
        return this.socket;
    }

    public void setOutputStream(OutputStream os) {
        super.setBufferedServeletOutputStream(new ServletOutputStreamImpl(this, os));
    }

    void setSocket(Socket socket) throws IOException {
        this.socket = socket;
        OutputStream sout = socket.getOutputStream();
        super.setBufferedServeletOutputStream(new ServletOutputStreamImpl(this, sout));
    }

    void writeHeaders(OutputStream sout) throws IOException {
        Cookie c10;
        if (this.omitHeaders) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        String statusPhrase = this.sm.getString("sc." + this.status);
        buf.append("HTTP/1.0 " + this.status);
        if (statusPhrase != null) {
            buf.append(" " + statusPhrase);
        }
        buf.append("\r\n");
        HttpDate date = new HttpDate(System.currentTimeMillis());
        buf.append("Date: " + date + "\r\n");
        buf.append("Server: " + this.getServerHeader() + "\r\n");
        if (this.request.getContext() != null) {
            buf.append("Servlet-Engine: " + this.request.getContext().getEngineHeader() + "\r\n");
        }
        buf.append("Content-Type: " + this.contentType + "\r\n");
        if (this.contentLanguage != null) {
            buf.append("Content-Language: " + this.contentLanguage + "\r\n");
        }
        if (this.contentLength != -1) {
            buf.append("Content-Length: " + this.contentLength + "\r\n");
        }
        Enumeration cookieEnum = null;
        cookieEnum = this.systemCookies.elements();
        while (cookieEnum.hasMoreElements()) {
            c10 = (Cookie)cookieEnum.nextElement();
            buf.append(String.valueOf(CookieUtils.getCookieHeader(c10)) + "\r\n");
        }
        cookieEnum = this.userCookies.elements();
        while (cookieEnum.hasMoreElements()) {
            c10 = (Cookie)cookieEnum.nextElement();
            buf.append(String.valueOf(CookieUtils.getCookieHeader(c10)) + "\r\n");
        }
        int size = this.headers.size();
        int i2 = 0;
        while (i2 < size) {
            MimeHeaderField h2 = this.headers.getField(i2);
            buf.append(String.valueOf(String.valueOf(h2)) + "\r\n");
            ++i2;
        }
        buf.append("\r\n");
        sout.write(buf.toString().getBytes());
    }
}

