/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Hashtable;
import org.apache.tomcat.core.RequestImpl;
import org.apache.tomcat.service.Ajp11;
import org.apache.tomcat.service.http.HttpServletIS;
import org.apache.tomcat.util.StringManager;

class AJPRequest
extends RequestImpl {
    StringManager sm = StringManager.getManager("org.apache.tomcat.service");
    Socket socket;

    public AJPRequest(Socket so) {
        this.socket = so;
    }

    protected void readNextRequest() throws IOException {
        String sport;
        InputStream sin = this.socket.getInputStream();
        this.in = new HttpServletIS(sin);
        Hashtable env_vars = new Hashtable();
        Ajp11.readAJPData(this.in, env_vars, this.headers);
        this.method = (String)env_vars.get("REQUEST_METHOD");
        this.protocol = (String)env_vars.get("SERVER_PROTOCOL");
        this.requestURI = (String)env_vars.get("REQUEST_URI");
        this.queryString = (String)env_vars.get("QUERY_STRING");
        if (this.queryString != null && !"".equals(this.queryString)) {
            this.processFormData(this.queryString);
        }
        if (this.requestURI.indexOf("?") > -1) {
            this.requestURI = this.requestURI.substring(0, this.requestURI.indexOf("?"));
        }
        if ((sport = (String)env_vars.get("SERVER_PORT")) == null) {
            sport = "80";
        }
        this.serverPort = new Integer(sport);
        this.remoteAddr = (String)env_vars.get("REMOTE_ADDR");
        this.remoteHost = (String)env_vars.get("REMOTE_ADDR");
        this.processCookies();
        this.contentLength = this.headers.getIntHeader("content-length");
        this.contentType = this.headers.getHeader("content-type");
        this.charEncoding = this.getCharsetFromContentType(this.contentType);
    }
}

