/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service;

import java.net.Socket;
import org.apache.tomcat.core.BufferedServletInputStream;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.service.AJPRequest;
import org.apache.tomcat.service.AJPResponse;
import org.apache.tomcat.service.TcpConnection;
import org.apache.tomcat.service.TcpConnectionHandler;
import org.apache.tomcat.util.StringManager;

public class Ajp11ConnectionHandler
implements TcpConnectionHandler {
    StringManager sm = StringManager.getManager("org.apache.tomcat.service");
    ContextManager contextM;

    public void init() {
    }

    public void processConnection(TcpConnection connection) {
        try {
            Socket socket = connection.getSocket();
            socket.setSoLinger(true, 100);
            AJPRequest request = new AJPRequest(socket);
            AJPResponse response = new AJPResponse();
            response.setOutputStream(socket.getOutputStream());
            boolean count = true;
            request.setResponse(response);
            response.setRequest(request);
            request.readNextRequest();
            if (response.getStatus() >= 400) {
                response.finish();
                socket.close();
                return;
            }
            int contentLength = request.getIntHeader("content-length");
            if (contentLength != -1) {
                BufferedServletInputStream sis = (BufferedServletInputStream)request.getInputStream();
                sis.setLimit(contentLength);
            }
            this.contextM.service(request, response);
            response.finish();
            socket.close();
        }
        catch (Exception e10) {
            System.out.println("HANDLER THREAD PROBLEM: " + e10);
            e10.printStackTrace();
        }
    }

    public void setAttribute(String name, Object value) {
        if ("context.manager".equals(name)) {
            this.contextM = (ContextManager)value;
        }
    }

    public void setContextManager(ContextManager contextM) {
        this.contextM = contextM;
    }
}

