/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service;

import java.io.IOException;
import java.net.Socket;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.service.Ajp22Request;
import org.apache.tomcat.service.Ajp22Response;
import org.apache.tomcat.service.MessageConnector;
import org.apache.tomcat.service.TcpConnection;
import org.apache.tomcat.service.TcpConnectionHandler;

public class Ajp22ConnectionHandler
implements TcpConnectionHandler {
    ContextManager contextM;

    public void init() {
    }

    public void processConnection(TcpConnection connection) {
        Ajp22Response rresponse = null;
        Ajp22Request rrequest = null;
        try {
            MessageConnector msg = null;
            boolean recycle_is_broken = false;
            Socket socket = connection.getSocket();
            if (!recycle_is_broken) {
                msg = new MessageConnector(socket);
                rresponse = new Ajp22Response(msg);
                rrequest = new Ajp22Request(msg);
                rrequest.setResponse(rresponse);
                rresponse.setRequest(rrequest);
            }
            boolean moreRequests = true;
            while (moreRequests) {
                if (recycle_is_broken) {
                    msg = new MessageConnector(socket);
                    rresponse = new Ajp22Response(msg);
                    rrequest = new Ajp22Request(msg);
                    rrequest.setResponse(rresponse);
                    rresponse.setRequest(rrequest);
                }
                try {
                    int err = rrequest.readNextRequest();
                    if (err < 0) {
                        moreRequests = false;
                    }
                }
                catch (IOException iOException) {}
                break;
                if (rresponse.getStatus() >= 400) {
                    rresponse.finish();
                    rrequest.recycle();
                    rresponse.recycle();
                    break;
                }
                String path = rrequest.getRequestURI();
                Context ctx = this.contextM.getContextByPath(path);
                String ctxPath = ctx.getPath();
                String pathInfo = path.substring(ctxPath.length(), path.length());
                if (rrequest.getProtocol() == null) {
                    rresponse.setOmitHeaders(true);
                }
                ctx.handleRequest(rrequest, rresponse);
                rresponse.finish();
                msg.endResponse();
                rrequest.recycle();
                rresponse.recycle();
            }
            System.out.println("Closing connection");
            socket.close();
        }
        catch (Exception e10) {
            System.out.println("HANDLER THREAD PROBLEM: " + e10);
            e10.printStackTrace();
        }
    }

    public void setAttribute(String name, Object value) {
        if ("context.manager".equals(name)) {
            this.contextM = (ContextManager)value;
        }
    }

    public void setContextManager(ContextManager contextM) {
        this.contextM = contextM;
    }
}

