/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.tomcat.net.ServerSocketFactory;
import org.apache.tomcat.service.TcpConnection;
import org.apache.tomcat.service.TcpConnectionHandler;
import org.apache.tomcat.service.TcpConnectionThread;
import org.apache.tomcat.service.TcpListenerThread;
import org.apache.tomcat.util.StringManager;

public class TcpEndpoint {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.util");
    private static final int BACKLOG = 50;
    private static final int TIMEOUT = 1000;
    private int backlog = 50;
    private int timeout = 1000;
    String handlerClassName;
    TcpConnectionHandler handler;
    private InetAddress inet;
    private int port;
    private ServerSocketFactory factory;
    private ServerSocket serverSocket;
    TcpListenerThread listener;
    boolean running = true;

    void acceptConnections() {
        try {
            Socket socket = this.serverSocket.accept();
            if (!this.running) {
                socket.close();
            }
            this.processSocket(socket);
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (Exception e10) {
            this.running = false;
            String msg = this.sm.getString("endpoint.err.fatal", this.serverSocket, e10);
            System.err.println(msg);
        }
    }

    public InetAddress getAddress() {
        return this.inet;
    }

    public TcpConnectionHandler getConnectionHandler() {
        return this.handler;
    }

    public int getPort() {
        return this.port;
    }

    void processSocket(Socket s2) throws IOException {
        s2.setSoLinger(true, 100);
        TcpConnection con = new TcpConnection();
        con.setEndpoint(this);
        con.setSocket(s2);
        TcpConnectionHandler handler = this.getConnectionHandler();
        TcpConnectionThread handlerThread = new TcpConnectionThread(handler, con);
        new Thread(handlerThread).start();
    }

    public void setAddress(InetAddress inet) {
        this.inet = inet;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public void setConnectionHandler(TcpConnectionHandler handler) {
        this.handler = handler;
    }

    public void setConnectionHandlerClassName(String classN) {
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setServerSocket(ServerSocket ss) {
        this.serverSocket = ss;
    }

    public void setServerSocketFactory(ServerSocketFactory factory) {
        this.factory = factory;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void startEndpoint() {
        try {
            if (this.factory == null) {
                this.factory = ServerSocketFactory.getDefault();
            }
            if (this.serverSocket == null) {
                this.serverSocket = this.inet != null ? this.factory.createSocket(this.port, this.backlog) : this.factory.createSocket(this.port, this.backlog, this.inet);
            }
        }
        catch (IOException ex2) {
            ex2.printStackTrace();
            this.running = false;
        }
        catch (InstantiationException ex1) {
            ex1.printStackTrace();
            this.running = false;
        }
        this.running = true;
        System.out.println("Starting tcp endpoint on " + this.port + " with " + this.handler.getClass().getName());
        this.listener = new TcpListenerThread(this);
        Thread thread = new Thread(this.listener);
        thread.start();
    }

    public void stopEndpoint() {
        this.running = false;
    }
}

